/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.dgfip.utils.StringUtilities;
import fr.gouv.finances.dgfip.xemelios.common.config.CritereModel;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.SqlConfigMapping;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.XsString;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TCriteria
implements XmlMarshallable {
    private static final Logger logger = Logger.getLogger(TCriteria.class);
    public static final String DATE_FORMAT = System.getProperty("xemelios.date.format", "yyyy-MM-dd");
    public static final String TIME_FORMAT = "HH:mm:ss.";
    public static final SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
    public static final SimpleDateFormat sdfTime = new SimpleDateFormat("HH:mm:ss.");
    public static final String TAG = "criteria";
    public static final transient QName QN = new QName("criteria");
    private String id;
    private String sqlIndexId;
    private XsString whereClause;
    private static Hashtable<String, FunctionEvaluator> evaluators = null;

    public TCriteria(QName tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (SqlConfigMapping.WHERE_CLAUSE.equals(tagName)) {
            this.whereClause = (XsString)child;
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.sqlIndexId = attributes.getValue("sql-index-id");
        return this;
    }

    public void marshall(XmlOutputter output) {
    }

    public void validate() throws InvalidXmlDefinition {
    }

    public TCriteria clone() {
        TCriteria other = new TCriteria(QN);
        other.id = this.id;
        other.sqlIndexId = this.sqlIndexId;
        other.whereClause = this.whereClause.clone();
        return other;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSqlIndexId() {
        return this.sqlIndexId;
    }

    public void setSqlIndexId(String sqlIndexId) {
        this.sqlIndexId = sqlIndexId;
    }

    public String getWhereClause() {
        return this.whereClause.getData();
    }

    public void setWhereClause(XsString whereClause) {
        this.whereClause = whereClause;
    }

    public String getSubstitutedWhereClause(CritereModel cm) throws DataConfigurationException {
        return this.getSubstituteClause(this.whereClause.getData(), cm);
    }

    protected String getSubstituteClause(String clause, CritereModel cm) throws DataConfigurationException {
        String expr = clause;
        int ix = expr.indexOf("##");
        while (ix >= 0) {
            String sTmp = expr.substring(ix + 2);
            int pos = sTmp.indexOf("##");
            if (pos < 0) {
                throw new DataConfigurationException(clause + " is not valid");
            }
            String middle = sTmp.substring(0, pos);
            String property = cm.getProperty(middle);
            if (property == null) {
                throw new DataConfigurationException("Property ##" + middle + "## not found in criteria " + cm.getId());
            }
            expr = expr.replace("##" + middle + "##", StringEscapeUtils.escapeSql(property));
            ix = expr.indexOf("##");
        }
        ix = expr.indexOf("fn:");
        while (ix >= 0) {
            int openningParenthesisPos = expr.indexOf("(", ix);
            String functionName = expr.substring(ix + 3, openningParenthesisPos);
            try {
                int closingParenthesisPos = StringUtilities.getClosingParenthesisPos(expr, openningParenthesisPos);
                String args = expr.substring(openningParenthesisPos + 1, closingParenthesisPos);
                String ret = evaluators.get(functionName).evaluate(args, cm);
                expr = expr.substring(0, ix) + ret + expr.substring(closingParenthesisPos + 1);
            }
            catch (ParseException pEx) {
                throw new DataConfigurationException("expression " + clause + " has unbalanced parenthesis");
            }
            ix = expr.indexOf("fn:");
        }
        return expr;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        return null;
    }

    public QName getQName() {
        return QN;
    }

    static {
        evaluators = new Hashtable();
        evaluators.put("string-compare", new StrCompareEvaluator());
        evaluators.put("date-compare", new DateCompareEvaluator());
    }

    private static class TimeCompareEvaluator
    implements FunctionEvaluator {
        public String evaluate(String args, CritereModel cm) throws DataConfigurationException {
            int pos = args.indexOf(44);
            String arg1 = args.substring(0, pos);
            String arg2 = args.substring(pos + 1);
            String comparator = cm.getProperty("OPERATEUR:" + arg2);
            String tmpValue = cm.getProperty("VALEUR:" + arg2);
            String value = null;
            try {
                Date d = sdf.parse(tmpValue);
                value = StringEscapeUtils.escapeSql(DataLayerManager.getImplementation().getDateFormatter().format(d));
            }
            catch (Throwable t) {
                logger.error((Object)(tmpValue + " is not a valid date"));
            }
            if (value == null) {
                value = tmpValue;
            }
            if ("xem:DateEquals".equals(comparator)) {
                return arg1 + "=STR_TO_DATE('" + value + "','%Y-%m-%d')";
            }
            if ("xem:DateBefore".equals(comparator)) {
                return arg1 + "<STR_TO_DATE('" + value + "','%Y-%m-%d')";
            }
            if ("xem:DateAfter".equals(comparator)) {
                return arg1 + ">STR_TO_DATE('" + value + "','%Y-%m-%d')";
            }
            throw new DataConfigurationException("unknown comparator: " + comparator);
        }
    }

    private static class DateCompareEvaluator
    implements FunctionEvaluator {
        public String evaluate(String args, CritereModel cm) throws DataConfigurationException {
            int pos = args.indexOf(44);
            String arg1 = args.substring(0, pos);
            String arg2 = args.substring(pos + 1);
            String comparator = cm.getProperty("OPERATEUR:" + arg2);
            String tmpValue = cm.getProperty("VALEUR:" + arg2);
            String value = null;
            try {
                Date d = sdf.parse(tmpValue);
                value = StringEscapeUtils.escapeSql(DataLayerManager.getImplementation().getDateFormatter().format(d));
            }
            catch (Throwable t) {
                logger.error((Object)(tmpValue + " is not a valid date"));
            }
            if (value == null) {
                value = tmpValue;
            }
            if ("xem:DateEquals".equals(comparator)) {
                return arg1 + "=STR_TO_DATE('" + value + "','%Y-%m-%d')";
            }
            if ("xem:DateBefore".equals(comparator)) {
                return arg1 + "<=STR_TO_DATE('" + value + "','%Y-%m-%d')";
            }
            if ("xem:DateAfter".equals(comparator)) {
                return arg1 + ">=STR_TO_DATE('" + value + "','%Y-%m-%d')";
            }
            throw new DataConfigurationException("unknown comparator: " + comparator);
        }
    }

    private static class StrCompareEvaluator
    implements FunctionEvaluator {
        public String evaluate(String args, CritereModel cm) throws DataConfigurationException {
            int pos = args.indexOf(44);
            String arg1 = args.substring(0, pos);
            String arg2 = args.substring(pos + 1);
            String comparator = cm.getProperty("OPERATEUR:" + arg2);
            String value = StringEscapeUtils.escapeSql(cm.getProperty("VALEUR:" + arg2));
            if ("xem:StringEquals".equals(comparator)) {
                return arg1 + "='" + value + "'";
            }
            if ("xem:StringDiffers".equals(comparator)) {
                return arg1 + "<>'" + value + "'";
            }
            if ("xem:ends-with".equals(comparator)) {
                return arg1 + " LIKE BINARY '%" + value + "'";
            }
            if ("xem:does-not-contain".equals(comparator)) {
                return arg1 + " NOT LIKE '%" + value + "%'";
            }
            if ("contains".equals(comparator)) {
                return arg1 + " LIKE BINARY '%" + value + "%'";
            }
            if ("starts-with".equals(comparator)) {
                return arg1 + " LIKE BINARY '" + value + "%'";
            }
            if ("xem:StringIsNull".equals(comparator)) {
                return arg1 + " IS NULL";
            }
            if ("xem:StringIsNotNull".equals(comparator)) {
                return arg1 + " IS NOT NULL";
            }
            throw new DataConfigurationException("unknown comparator: " + comparator);
        }
    }

    private static interface FunctionEvaluator {
        public String evaluate(String var1, CritereModel var2) throws DataConfigurationException;
    }
}

