/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.data.impl.pool;

import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionInfo {
    private String driver;
    private String driverVersion;
    private String database;
    private String databaseVersion;
    private String url;
    private String username;

    public static ConnectionInfo fromConnection(Connection connection) throws SQLException {
        return new ConnectionInfo(connection.getMetaData().getDriverName(), connection.getMetaData().getDriverVersion(), connection.getMetaData().getDatabaseProductName(), connection.getMetaData().getDatabaseProductVersion(), connection.getMetaData().getURL(), connection.getMetaData().getUserName());
    }

    public ConnectionInfo(String driver, String driverVersion, String database, String databaseVersion, String url, String username) {
        this.driver = driver;
        this.driverVersion = driverVersion;
        this.database = database;
        this.databaseVersion = databaseVersion;
        this.url = url;
        this.username = username;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Driver : " + this.driver + " " + this.driverVersion + "\n");
        sb.append("Database : " + this.database + " " + this.databaseVersion + "\n");
        sb.append("Url : " + this.url);
        sb.append("Username : " + this.username);
        return sb.toString();
    }
}

