/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.dgfip.xemelios.common.config.VariableModel;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentModel
implements NoeudModifiable {
    private static Logger logger = Logger.getLogger(EnvironmentModel.class);
    private NoeudModifiable _NMParent = null;
    public static final transient String TAG = "environment";
    public static final transient QName QN = new QName("environment");
    public static final int ALL_DOMAINS = -1;
    private Vector<VariableModel> vVariables = new Vector();
    private Hashtable<Integer, Vector<VariableModel>> variablesByDomain = new Hashtable();
    private HashMap<String, VariableModel> hVariableModels = new HashMap();
    private String configXPath = null;

    public EnvironmentModel(QName tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        VariableModel vm = (VariableModel)child;
        String key = vm.getName() + "|" + vm.getDomain();
        if (this.hVariableModels.containsKey(key)) {
            VariableModel old = this.hVariableModels.get(key);
            this.vVariables.remove(old);
            this.hVariableModels.remove(key);
        }
        vm.setParentAsNoeudModifiable(this);
        this.hVariableModels.put(key, vm);
        this.vVariables.add(vm);
        Integer domain = new Integer(vm.getDomain());
        Vector<VariableModel> vars = this.variablesByDomain.get(domain);
        if (vars == null) {
            vars = new Vector();
            this.variablesByDomain.put(domain, vars);
        }
        vars.add(vm);
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        return this;
    }

    public void marshall(XmlOutputter output) {
    }

    public void validate() throws InvalidXmlDefinition {
        for (VariableModel vm : this.vVariables) {
            vm.validate();
        }
    }

    public EnvironmentModel clone() {
        EnvironmentModel other = new EnvironmentModel(QN);
        for (VariableModel vm : this.vVariables) {
            try {
                other.addChild((XmlMarshallable)vm.clone(), VariableModel.QN);
            }
            catch (Throwable t) {
                logger.error((Object)"clone().variable", t);
            }
        }
        return other;
    }

    public Enumeration<VariableModel> getVariables(int domain) {
        if (domain == -1) {
            return this.vVariables.elements();
        }
        Vector<VariableModel> ret = this.variablesByDomain.get(new Integer(domain));
        if (ret == null) {
            return null;
        }
        return ret.elements();
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        StringTokenizer st = new StringTokenizer(id, "|");
        String sId = st.nextToken() + "|";
        sId = "documents".equals(st.nextToken()) ? sId + 1 : sId + 2;
        return this.hVariableModels.get(sId);
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            logger.error((Object)("Erreur lors de la mise \u00ef\u00bf\u00bd jour des attributs : " + e));
        }
    }

    public String[] getChildIdAttrName(String childTagName) {
        return new String[]{"name", "domain"};
    }

    public void resetCharData() {
    }

    public String getIdValue() {
        return null;
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/environment";
        }
        return this.configXPath;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        return (XmlMarshallable)this.hVariableModels.get(atts.getValue("name") + "|" + atts.getValue("domain"));
    }

    public QName getQName() {
        return QN;
    }
}

