/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.dgfip.xemelios.common.config.BlankModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsMapping;
import fr.gouv.finances.dgfip.xemelios.common.config.InputModel;
import fr.gouv.finances.dgfip.xemelios.common.config.PropertyModel;
import fr.gouv.finances.dgfip.xemelios.common.config.SelectModel;
import fr.gouv.finances.dgfip.xemelios.common.config.XPathModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CritereModel
implements NoeudModifiable {
    private static Logger logger = Logger.getLogger(CritereModel.class);
    private NoeudModifiable _NMParent = null;
    private String configXPath = null;
    public static final transient String TAG = "critere";
    public static final transient QName QN = new QName("critere");
    public static final int MODE_NORMAL = 1;
    public static final int MODE_ANOMALY = 2;
    public static final int MODE_BOTH = 3;
    private String libelle;
    private String id;
    private String idAffichage;
    private boolean displayOptional = false;
    private boolean affichable = true;
    private XPathModel path;
    private Vector<XmlMarshallable> vInputs;
    private HashMap<String, NoeudModifiable> hInputs;
    private Vector<PropertyModel> valeurs;
    private HashMap<String, PropertyModel> properties;
    private BlankModel blank = null;
    private int mode = 3;
    private QName qn;
    private Object additionnalData = null;

    public boolean equals(Object o) {
        if (o instanceof CritereModel) {
            CritereModel other = (CritereModel)o;
            return other.getId().equals(this.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public CritereModel(QName tagName) {
        this.qn = tagName;
        this.vInputs = new Vector();
        this.hInputs = new HashMap();
        this.valeurs = new Vector();
        this.properties = new HashMap();
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (DocumentsMapping.PATH.equals(tagName)) {
            this.path = (XPathModel)child;
            this.path.setParentAsNoeudModifiable(this);
        } else if (PropertyModel.QN.equals(tagName)) {
            PropertyModel pm = (PropertyModel)child;
            if (this.properties.containsKey(pm.getName())) {
                PropertyModel old = this.properties.get(pm.getName());
                this.valeurs.remove(old);
                this.properties.remove(old.getName());
            }
            pm.setParentAsNoeudModifiable(this);
            this.valeurs.add(pm);
            this.properties.put(pm.getName(), pm);
        } else if (BlankModel.QN.equals(tagName)) {
            this.blank = (BlankModel)child;
            this.blank.setParentAsNoeudModifiable(this);
        } else if (InputModel.QN.equals(tagName)) {
            InputModel im = (InputModel)child;
            if (this.hInputs.containsKey(im.getId())) {
                InputModel old = (InputModel)this.hInputs.get(im.getId());
                this.vInputs.remove(old);
                this.hInputs.remove(old.getId());
            }
            im.setParentAsNoeudModifiable(this);
            this.vInputs.add((XmlMarshallable)im);
            this.hInputs.put(im.getId(), im);
        } else if (SelectModel.QN.equals(tagName)) {
            SelectModel sm = (SelectModel)child;
            if (this.hInputs.containsKey(sm.getId())) {
                SelectModel old = (SelectModel)this.hInputs.get(sm.getId());
                this.vInputs.remove(old);
                this.hInputs.remove(old.getId());
            }
            sm.setParentAsNoeudModifiable(this);
            this.vInputs.add((XmlMarshallable)sm);
            this.hInputs.put(sm.getId(), sm);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        String sTmp;
        this.libelle = attributes.getValue("libelle") != null ? attributes.getValue("libelle") : this.libelle;
        this.id = attributes.getValue("id") != null ? attributes.getValue("id") : this.id;
        String string = this.idAffichage = attributes.getValue("optional-display-id") != null ? attributes.getValue("optional-display-id") : this.idAffichage;
        if (attributes.getValue("optional-display") != null && attributes.getValue("optional-display").equals("true")) {
            this.displayOptional = true;
        }
        if (attributes.getValue("affichable") != null) {
            this.affichable = attributes.getBooleanValue("affichable");
            logger.debug((Object)(this.getId() + ".affichable set to " + Boolean.toString(this.affichable)));
        }
        if ((sTmp = attributes.getValue("mode")) != null) {
            if ("both".equals(sTmp)) {
                this.mode = 3;
            } else if ("anomaly".equals(sTmp)) {
                this.mode = 2;
            } else if ("normal".equals(sTmp)) {
                this.mode = 1;
            }
        }
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.getId());
        output.addAttribute("libelle", this.libelle);
        if (this.getIdAffichage() != null) {
            output.addAttribute("optional-display-id", this.getIdAffichage());
        }
        if (this.isDisplayOptional()) {
            output.addAttribute("optional-display", "true");
        }
        this.path.marshall(output);
        if (this.hasBlank()) {
            this.blank.marshall(output);
        }
        for (XmlMarshallable xm : this.vInputs) {
            xm.marshall(output);
        }
        for (PropertyModel pm : this.valeurs) {
            pm.marshall(output);
        }
        output.endTag(TAG);
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.id == null || this.id.length() == 0) {
            throw new InvalidXmlDefinition("//critere/@id is required (" + this.getParentAsNoeudModifiable().getConfigXPath() + "/" + TAG + ")");
        }
        this.path.validate();
        for (XmlMarshallable xm : this.vInputs) {
            xm.validate();
        }
    }

    public Vector<XmlMarshallable> getInputs() {
        return this.vInputs;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public XPathModel getPath() {
        return this.path;
    }

    public String toString() {
        return this.getLibelle();
    }

    public Vector<PropertyModel> getValeurs() {
        return this.valeurs;
    }

    public CritereModel clone() {
        CritereModel cm = new CritereModel(QN);
        cm.libelle = this.libelle;
        cm.id = this.id;
        cm.idAffichage = this.idAffichage;
        try {
            if (this.path != null) {
                cm.addChild((XmlMarshallable)this.path.clone(), DocumentsMapping.PATH);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"clone().path", t);
        }
        for (String s : this.properties.keySet()) {
            try {
                cm.addChild((XmlMarshallable)this.properties.get(s).clone(), PropertyModel.QN);
            }
            catch (Throwable t) {
                logger.error((Object)"clone().properties", t);
            }
        }
        cm.displayOptional = this.displayOptional;
        for (XmlMarshallable xm : this.vInputs) {
            try {
                cm.addChild((XmlMarshallable)xm.clone(), xm instanceof InputModel ? InputModel.QN : SelectModel.QN);
            }
            catch (Throwable t) {
                logger.error((Object)"clone().vInputs", t);
            }
        }
        try {
            if (this.blank != null) {
                cm.addChild((XmlMarshallable)this.blank.clone(), BlankModel.QN);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"clone().blank", t);
        }
        cm.mode = this.mode;
        cm.affichable = this.affichable;
        cm._NMParent = this._NMParent;
        return cm;
    }

    public String getId() {
        return this.id;
    }

    public String getIdAffichage() {
        return this.idAffichage;
    }

    public Object getAdditionnalData() {
        return this.additionnalData;
    }

    public void setAdditionnalData(Object additionnalData) {
        this.additionnalData = additionnalData;
    }

    public String getProperty(String propName) {
        PropertyModel pm = this.properties.get(propName);
        if (pm != null) {
            return pm.getValue();
        }
        return null;
    }

    public void removeAllProperties() {
        this.properties.clear();
    }

    public boolean hasBlank() {
        return this.blank != null;
    }

    public boolean isDisplayOptional() {
        return this.displayOptional;
    }

    public void setDisplayOptional(boolean d) {
        this.displayOptional = d;
    }

    public int getMode() {
        return this.mode;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        if ("path".equals(tagName)) {
            return this.path;
        }
        if ("property".equals(tagName)) {
            return this.properties.get(id);
        }
        if ("blank".equals(tagName)) {
            return this.blank;
        }
        if ("input".equals(tagName)) {
            return this.hInputs.get(id);
        }
        return null;
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            logger.error((Object)("Erreur lors de la mise \u00ef\u00bf\u00bd jour des attributs : " + e));
        }
    }

    public String[] getChildIdAttrName(String childTagName) {
        if ("property".equals(childTagName)) {
            return new String[]{"name"};
        }
        if ("input".equals(childTagName)) {
            return new String[]{"id"};
        }
        return null;
    }

    public void resetCharData() {
    }

    public boolean isAffichable() {
        return this.affichable;
    }

    public void setAffichable(boolean affichable) {
        this.affichable = affichable;
    }

    public String getIdValue() {
        return this.getId();
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/critere[@id='" + this.getId() + "']";
        }
        return this.configXPath;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        QName qname = new QName(uri, localName);
        if (PropertyModel.QN.equals(qname)) {
            return (XmlMarshallable)this.properties.get(this.id);
        }
        if (BlankModel.QN.equals(qname)) {
            return this.blank;
        }
        if (InputModel.QN.equals(qname)) {
            return (XmlMarshallable)this.hInputs.get(this.id);
        }
        return null;
    }

    public QName getQName() {
        return this.qn;
    }

    public Collection<PropertyModel> getProperties() {
        return this.properties.values();
    }
}

