/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.auth;

import fr.gouv.finances.dgfip.xemelios.auth.Collectivite;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public interface XemeliosUser {
    public static final int ROLE_CONNECT_BIT = 1;
    public static final int ROLE_IMPORT_BIT = 2;
    public static final int ROLE_CLEAN_BIT = 4;
    public static final int ROLE_SEARCH_BIT = 16;
    public static final int ROLE_BROWSE_BIT = 32;
    public static final int ROLE_EXPORT_BIT = 64;
    public static final String ROLE_CONNECT = "CONNECT";
    public static final String ROLE_IMPORT = "IMPORT";
    public static final String ROLE_CLEAN = "CLEAN";
    public static final String ROLE_SEARCH = "SEARCH";
    public static final String ROLE_BROWSE = "BROWSE";
    public static final String ROLE_EXPORT = "EXPORT";

    public String getId();

    public String getDisplayName();

    public boolean hasRole(String var1);

    public boolean hasDocument(String var1);

    public boolean hasCollectivite(String var1, DocumentModel var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleXemeliosUserImpl
    implements XemeliosUser {
        private String id;
        private String displayName;
        private boolean hasAllRoles;
        private Set roles;
        private boolean hasAllDocuments;
        private Set documents;
        private boolean hasAllCollectivites;
        private Hashtable<String, HashSet<String>> collectivites;

        public SimpleXemeliosUserImpl(String id, String displayName, boolean hasAllRoles, Collection<String> roles, boolean hasAllDocuments, Collection<String> documents, boolean hasAllCollectivites, Collection<Collectivite> collectivites) {
            this.id = id;
            this.displayName = displayName;
            this.hasAllRoles = hasAllRoles;
            this.roles = new HashSet(roles != null ? roles : Collections.EMPTY_LIST);
            this.hasAllDocuments = hasAllDocuments;
            this.documents = new HashSet(documents != null ? documents : Collections.EMPTY_LIST);
            this.hasAllCollectivites = hasAllCollectivites;
            this.collectivites = new Hashtable();
            if (!hasAllCollectivites && collectivites != null) {
                for (Collectivite coll : collectivites) {
                    HashSet<String> colls = this.collectivites.get(coll.getNatureIdentifiant());
                    if (colls == null) {
                        colls = new HashSet();
                        this.collectivites.put(coll.getNatureIdentifiant(), colls);
                    }
                    colls.add(coll.getCollectivite());
                }
            }
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public boolean hasRole(String role) {
            return this.hasAllRoles || this.roles.contains(role);
        }

        @Override
        public boolean hasDocument(String document) {
            return this.hasAllDocuments || this.documents.contains(document);
        }

        @Override
        public boolean hasCollectivite(String collectivite, DocumentModel dm) {
            if (this.hasAllCollectivites) {
                return true;
            }
            HashSet<String> colls = this.collectivites.get(dm.getNatureIdentifiantCollectivite());
            if (colls == null) {
                return false;
            }
            if (colls.contains(collectivite)) {
                return true;
            }
            return colls.contains("*");
        }
    }
}

