/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.utils.xml;

import fr.gouv.finances.cp.utils.xml.marshal.MutableBoolean;
import fr.gouv.finances.dgfip.utils.xml.NamespaceContextImpl;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class SAXWriter
extends DefaultHandler2 {
    public static final transient String XML_1_0 = "1.0";
    public static final transient String DEFAULT_ENCODING = "ISO-8859-1";
    public static final transient int MAX_LINESIZE = 128;
    private static final boolean CLOSED = false;
    private static final boolean OPENNED = true;
    private static final Logger logger = Logger.getLogger(SAXWriter.class);
    private static final String DEF_INDENT_BUFFER;
    private OutputStream out;
    private String encoding;
    private String xmlVersion;
    private boolean prettyPrint = true;
    private Stack<MutableBoolean> tagStatus;
    private NamespaceContextImpl ns;
    private ArrayList<String> prefixesToDeclare;
    private int indentLevel = 0;

    public SAXWriter(OutputStream out, String encoding, String xmlVersion) {
        this.out = out;
        this.encoding = encoding;
        this.xmlVersion = xmlVersion;
        this.tagStatus = new Stack();
        this.ns = new NamespaceContextImpl();
        this.prefixesToDeclare = new ArrayList();
    }

    public SAXWriter(OutputStream out, String encoding) {
        this(out, encoding, XML_1_0);
    }

    public SAXWriter(OutputStream out) {
        this(out, DEFAULT_ENCODING, XML_1_0);
    }

    protected void output(String s) {
        try {
            this.out.write(s.getBytes(this.encoding));
        }
        catch (Exception ex) {
            logger.error((Object)"output(String)", (Throwable)ex);
        }
    }

    public void startDocument() throws SAXException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"").append(this.xmlVersion).append("\" encoding=\"").append(this.encoding).append("\"?>");
        if (this.prettyPrint) {
            sb.append("\n");
        }
        this.output(sb.toString());
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.ns.getPrefix(uri) == null) {
            this.prefixesToDeclare.add(prefix);
            this.ns.addMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.ns.getPrefix(prefix) != null) {
            this.ns.removeMapping(prefix);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String px;
        StringBuilder sb = new StringBuilder();
        if (this.tagStatus.size() > 0) {
            if (!this.tagStatus.peek().booleanValue()) {
                sb.append(">");
            }
            this.tagStatus.peek().setValue(true);
        }
        ++this.indentLevel;
        this.tagStatus.push(new MutableBoolean(false));
        if (this.prettyPrint) {
            sb.append("\n").append(DEF_INDENT_BUFFER.substring(0, this.indentLevel));
        }
        sb.append("<");
        String string = px = uri == null ? null : this.ns.getPrefix(uri);
        if (px != null && px.length() > 0) {
            sb.append(px).append(":");
        }
        String sTmp = localName == null ? qName : localName;
        String shortName = sTmp.indexOf(":") > 0 ? sTmp.substring(sTmp.lastIndexOf(":") + 1) : sTmp;
        sb.append(shortName);
        int attsCount = atts.getLength();
        for (int i = 0; i < attsCount; ++i) {
            if ("http://www.w3.org/2000/xmlns/".equals(atts.getURI(i))) continue;
            if (this.prettyPrint && sb.length() > 128) {
                sb.append("\n");
                this.output(sb.toString());
                sb = new StringBuilder();
                sb.append(DEF_INDENT_BUFFER.substring(0, this.indentLevel + 3));
            }
            sb.append(" ");
            String prx = this.ns.getPrefix(atts.getURI(i));
            if (prx != null && prx.length() > 0) {
                sb.append(prx).append(":");
            }
            sb.append(atts.getLocalName(i)).append("=\"").append(SAXWriter.escapeText(atts.getValue(i))).append("\"");
        }
        for (String prfx : this.prefixesToDeclare) {
            sb.append(" xmlns");
            if (prfx != null && prfx.length() > 0) {
                sb.append(":").append(prfx);
            }
            sb.append("=\"").append(this.ns.getNamespaceURI(prfx)).append("\" ");
        }
        this.prefixesToDeclare.clear();
        this.output(sb.toString());
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean tagStatut = this.tagStatus.pop().booleanValue();
        if (!tagStatut) {
            this.output("/>\n");
        } else {
            String px;
            StringBuilder sb = new StringBuilder();
            if (this.prettyPrint) {
                sb.append("\n").append(DEF_INDENT_BUFFER.substring(0, this.indentLevel));
            }
            sb.append("</");
            String string = px = uri == null ? null : this.ns.getPrefix(uri);
            if (px != null && px.length() > 0) {
                sb.append(px).append(":");
            }
            String sTmp = localName == null ? qName : localName;
            String shortName = sTmp.indexOf(":") > 0 ? sTmp.substring(sTmp.lastIndexOf(":") + 1) : sTmp;
            sb.append(shortName).append(">");
            this.output(sb.toString());
        }
        --this.indentLevel;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.tagStatus.peek().booleanValue()) {
            this.output(">");
        }
        this.tagStatus.peek().setValue(true);
        this.output(SAXWriter.escapeText(new String(ch, start, length)));
    }

    public void addCData(char[] ch, int start, int length) throws SAXException {
        this.addCData(new String(ch, start, length));
    }

    public void addCData(String s) throws SAXException {
        if (!this.tagStatus.peek().booleanValue()) {
            this.output(">");
        }
        this.tagStatus.peek().setValue(true);
        this.output("<![CDATA[");
        this.output(s);
        this.output("]]>");
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (!"javax.xml.transform.disable-output-escaping".equals(target)) {
            StringBuilder sb = new StringBuilder();
            if (this.prettyPrint) {
                sb.append("\n").append(DEF_INDENT_BUFFER.substring(0, this.indentLevel));
            }
            sb.append("<?").append(target);
            if (data != null && data.length() > 0) {
                sb.append(" ").append(data);
            }
            sb.append("?>");
            this.output(sb.toString());
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE ").append(name);
        if (publicId != null && publicId.length() > 0) {
            sb.append(" PUBLIC ").append(publicId);
            if (systemId != null) {
                sb.append(" ").append(systemId);
            }
        } else if (systemId != null) {
            sb.append(" SYSTEM ").append(systemId);
        }
        sb.append(">\n");
        logger.debug((Object)("notationDecl(" + name + "," + publicId + "," + systemId + ")"));
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE ").append(name);
        if (publicId != null && publicId.length() > 0) {
            sb.append(" PUBLIC ").append(publicId);
            if (systemId != null) {
                sb.append(" ").append(systemId);
            }
        } else if (systemId != null) {
            sb.append(" SYSTEM ").append(systemId);
        }
        if (notationName != null) {
            sb.append(" [").append(notationName).append("]");
        }
        sb.append(">\n");
    }

    public static String escapeText(String text) {
        StringBuilder sb = new StringBuilder();
        if (text != null) {
            char[] value = text.toCharArray();
            String outval = null;
            int start = 0;
            int len = 0;
            block8: for (int i = 0; i < value.length; ++i) {
                char c = value[i];
                switch (c) {
                    case '\"': {
                        outval = "&quot;";
                        break;
                    }
                    case '<': {
                        outval = "&lt;";
                        break;
                    }
                    case '>': {
                        outval = "&gt;";
                        break;
                    }
                    case '&': {
                        outval = "&amp;";
                        break;
                    }
                    case '\'': {
                        outval = "&apos;";
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        ++len;
                        continue block8;
                    }
                    default: {
                        ++len;
                        continue block8;
                    }
                }
                if (outval == null) continue;
                if (len > 0) {
                    String s = new String(value, start, len);
                    sb.append(new String(value, start, len));
                }
                sb.append(outval);
                start = i + 1;
                len = 0;
                outval = null;
            }
            if (len > 0) {
                sb.append(new String(value, start, len));
            }
        }
        return sb.toString();
    }

    public void writeEscapedText(String text) {
        this.output(SAXWriter.escapeText(text));
    }

    public OutputStream getOutput() {
        return this.out;
    }

    public NamespaceContextImpl getnsContext() {
        return this.ns;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public static String unescapeText(String s) {
        return s.replaceAll("&lt;", "<").replace("&gt;", ">").replaceAll("&amp;", "&");
    }

    static {
        StringBuffer sb = new StringBuffer(256);
        for (int i = 0; i < 256; ++i) {
            sb.append(' ');
        }
        DEF_INDENT_BUFFER = sb.toString();
    }
}

