/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.cg.refCollecPatcher;

import fr.gouv.finances.dgfip.xemelios.common.FileInfo;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.Loader;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.PoolManager;
import fr.gouv.finances.dgfip.xemelios.importers.AbstractImportPatcherImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class RefCollecPatcher
extends AbstractImportPatcherImpl {
    private static final Logger logger = Logger.getLogger(RefCollecPatcher.class);
    protected DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
    protected TransformerFactory transformerFactory;

    public RefCollecPatcher() {
        this.domFactory.setNamespaceAware(true);
        this.transformerFactory = TransformerFactoryImpl.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo run() {
        int rowPatched;
        Connection con2;
        FileInfo ret;
        block13: {
            Connection conPatch;
            Integer exercice;
            String collectiviteId;
            block11: {
                FileInfo fileInfo;
                block12: {
                    ret = new FileInfo();
                    this.getImportServiceProvider().startLongWait();
                    collectiviteId = (String)this.getParameter("collectivite-id");
                    exercice = (Integer)this.getParameter("exercice");
                    conPatch = null;
                    con2 = null;
                    Object con3 = null;
                    rowPatched = 0;
                    DocumentModel dm = Loader.getDocumentsInfos(null).getDocumentById("ref-collec-spl");
                    if (dm != null) break block11;
                    fileInfo = ret;
                    if (conPatch == null) break block12;
                    PoolManager.getInstance().releaseConnection(conPatch);
                }
                if (con2 != null) {
                    PoolManager.getInstance().releaseConnection(con2);
                }
                this.getImportServiceProvider().endLongWait();
                return fileInfo;
            }
            try {
                conPatch = PoolManager.getInstance().getConnection();
                con2 = PoolManager.getInstance().getConnection();
                PreparedStatement ps = conPatch.prepareStatement("SELECT COLLECTIVITE, BUDGET, DOC_ID FROM REF_COLL_SPL_COLLECTIVITESSPL_COLL_IX WHERE IDCOLL=? AND EXERCICE=?");
                ps.setString(1, collectiviteId);
                ps.setInt(2, exercice);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    if (!this.patchDocument(rs.getString(1), rs.getString(2), rs.getString(3), con2)) continue;
                    ++rowPatched;
                }
                if (conPatch == null) break block13;
            }
            catch (Exception ex) {
                block14: {
                    try {
                        logger.error((Object)("run() - collectivite-id=" + collectiviteId), (Throwable)ex);
                        if (conPatch == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (conPatch != null) {
                            PoolManager.getInstance().releaseConnection(conPatch);
                        }
                        if (con2 != null) {
                            PoolManager.getInstance().releaseConnection(con2);
                        }
                        this.getImportServiceProvider().endLongWait();
                        throw throwable;
                    }
                    PoolManager.getInstance().releaseConnection(conPatch);
                }
                if (con2 != null) {
                    PoolManager.getInstance().releaseConnection(con2);
                }
                this.getImportServiceProvider().endLongWait();
            }
            PoolManager.getInstance().releaseConnection(conPatch);
        }
        if (con2 != null) {
            PoolManager.getInstance().releaseConnection(con2);
        }
        this.getImportServiceProvider().endLongWait();
        ret.setMessage(rowPatched + " collectivit\u00e9s amend\u00e9es par cet import\n");
        return ret;
    }

    private boolean patchDocument(String collectivite, String budget, String docId, Connection con) throws Exception {
        boolean ret = true;
        PreparedStatement ps = con.prepareStatement("UPDATE REF_COLL_SPL_COLLECTIVITESSPL_COLL_IX SET ARCHIVE='Oui' WHERE COLLECTIVITE=? AND BUDGET=? AND DOC_ID=?");
        ps.setString(1, collectivite);
        ps.setString(2, budget);
        ps.setString(3, docId);
        ps.executeUpdate();
        ps = con.prepareStatement("SELECT DOC, ENCODING FROM REF_COLL_SPL_DOCUMENTS WHERE COLLECTIVITE=? AND BUDGET=? AND DOC_ID=?");
        ps.setString(1, collectivite);
        ps.setString(2, budget);
        ps.setString(3, docId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            String encoding = rs.getString(2);
            byte[] buff = new byte[512];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream is = rs.getAsciiStream(1);
            int length = is.read(buff);
            while (length > 0) {
                baos.write(buff, 0, length);
                length = is.read(buff);
            }
            DocumentBuilder builder = this.domFactory.newDocumentBuilder();
            byte[] byteArray = baos.toByteArray();
            ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
            Document doc = builder.parse(bis);
            Transformer trans = this.transformerFactory.newTransformer(new StreamSource(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("fr/gouv/finances/dgfip/xemelios/cg/refCollecPatcher/collec-patcher.xsl")));
            ByteArrayOutputStream newDoc = new ByteArrayOutputStream();
            DocumentBuilder domBuilder = this.domFactory.newDocumentBuilder();
            trans.setParameter("archive", "Oui");
            trans.setOutputProperty("encoding", encoding);
            trans.transform(new DOMSource(doc), new StreamResult(newDoc));
            ps.close();
            ps = con.prepareStatement("UPDATE REF_COLL_SPL_DOCUMENTS SET DOC=? WHERE COLLECTIVITE=? AND BUDGET=? AND DOC_ID=?");
            ps.setString(2, collectivite);
            ps.setString(3, budget);
            ps.setString(4, docId);
            byte[] newDocArray = newDoc.toByteArray();
            ByteArrayInputStream isNewDoc = new ByteArrayInputStream(newDocArray);
            ps.setBinaryStream(1, (InputStream)isNewDoc, newDocArray.length);
            if (ps.executeUpdate() > 0) {
                ret = true;
            }
            ps.close();
        }
        return ret;
    }
}

