/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.widgets.paye;

import fr.gouv.finances.cp.xemelios.common.config.ChampModel;
import fr.gouv.finances.cp.xemelios.common.config.CritereModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.WidgetModel;
import fr.gouv.finances.cp.xemelios.ui.CriteriaViewer;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.cp.xemelios.ui.SearchWindow;
import fr.gouv.finances.cp.xemelios.ui.resulttable.EtatResultTableModel;
import fr.gouv.finances.cp.xemelios.widgets.AbstractWidget;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JOptionPane;

public class AgentViewer
extends AbstractWidget {
    public AgentViewer(WidgetModel wm, ElementModel em) {
        super(wm, em);
    }

    public void run(EtatResultTableModel etrm, int row) {
        String matriculeResultatId = null;
        String matriculeCritereId = null;
        String matriculeInputId = null;
        String elementCibleId = null;
        try {
            matriculeResultatId = this.getWidgetModel().getParam("matricule-res-id").getValue();
            matriculeCritereId = this.getWidgetModel().getParam("matricule-crit-id").getValue();
            matriculeInputId = this.getWidgetModel().getParam("matricule-input-id").getValue();
            elementCibleId = this.getWidgetModel().getParam("elementId").getValue();
        }
        catch (NullPointerException npEx) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        if (matriculeResultatId == null) {
            sb.append("matricule-res-id param has null value or is missing\n");
        }
        if (matriculeCritereId == null) {
            sb.append("matricule-crit-id param has null value or is missing\n");
        }
        if (matriculeInputId == null) {
            sb.append("matricule-input-id param has null value or is missing\n");
        }
        if (elementCibleId == null) {
            sb.append("elementId param has null value or is missing\n");
        }
        if (sb.length() == 0) {
            Vector champs = etrm.getListeChamps();
            int pos = 0;
            for (int i = 0; i < champs.size(); ++i) {
                if (!((ChampModel)champs.get(i)).getId().equals(matriculeResultatId)) continue;
                pos = i;
                break;
            }
            if (pos == 0) {
                sb.append("champ " + matriculeResultatId + " was not found in lrm");
            } else {
                String matricule = (String)etrm.getValueAt(row, pos);
                ElementModel payeIndivElement = this.getElementModel().getParent().getElementById(elementCibleId);
                CritereModel cm = payeIndivElement.getCritere(matriculeCritereId);
                SearchWindow sw = MainWindow.instance.displaySearchWindow(payeIndivElement);
                sw.setCollectivite(etrm.getCollectivite());
                sw.setBudget(etrm.getBudget());
                sw.clearAll();
                CriteriaViewer cv = sw.addLine();
                cv.changeCritereModel(cm);
                String opName = matriculeInputId.replaceFirst("VALEUR", "OPERATEUR");
                cv.setInputValue(opName, "xem:StringEquals");
                cv.setInputValue(matriculeInputId, matricule);
                sw.setVisible(true);
                sw.search();
            }
        }
        if (sb.length() > 0) {
            JOptionPane.showMessageDialog((Component)MainWindow.instance, sb.toString(), "Erreur", 0);
        }
    }
}

