/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugins.paye;

import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.cp.xemelios.common.config.PropertyModel;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.data.DataResultSet;
import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.MySqlDataResultSet;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TEtat;
import fr.gouv.finances.cp.xemelios.plugins.SearchPlugin;
import fr.gouv.finances.cp.xemelios.ui.search.ResultDisplayerThread;
import java.awt.Frame;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class Variations
extends SearchPlugin {
    private static final Logger logger = Logger.getLogger(Variations.class);
    protected String year1;
    protected String year2;
    protected String month1;
    protected String month2;
    protected String delta;
    protected String typeVariation;
    protected String tag;
    protected String attribute;
    protected String valeurSql = null;
    protected int compareMethod = 0;
    protected static final int METHOD_PERCENT = 1;
    protected static final int METHOD_VALUE = 2;
    protected double limite = 0.0;
    private String mtNet;
    private String op_mtNet;
    private String mtBrut;
    private String op_mtBrut;
    private String agenStatut;
    private String op_agenStatut;
    private String emploi;
    private String op_emploi;
    private String service;
    private String op_service;
    private String grade;
    private String op_grade;
    private String indice;
    private String op_indice;

    public void computeParameters() throws Exception {
        this.tag = "MtNet";
        this.attribute = "V";
        Vector props = this.getPluginModel().getProperties();
        for (PropertyModel property : props) {
            if (property.getName().equals("attribute")) {
                this.attribute = property.getValue();
                continue;
            }
            if (!property.getName().equals("valeur-sql")) continue;
            this.valeurSql = property.getValue();
        }
        this.year1 = (String)this.getParameters().get("VALEUR:year1");
        this.month1 = (String)this.getParameters().get("VALEUR:month1");
        this.year2 = (String)this.getParameters().get("VALEUR:year2");
        this.month2 = (String)this.getParameters().get("VALEUR:month2");
        this.delta = (String)this.getParameters().get("VALEUR:delta");
        this.limite = Double.parseDouble(this.delta);
        this.typeVariation = (String)this.getParameters().get("VALEUR:typeVariation");
        if (this.typeVariation.equals("percent")) {
            this.compareMethod = 1;
        } else if (this.typeVariation.equals("euro")) {
            this.compareMethod = 2;
        }
        if (this.getParameters().get("VALEUR:tag") != null) {
            this.tag = (String)this.getParameters().get("VALEUR:tag");
        }
        this.mtNet = (String)this.getParameters().get("VALEUR:mtnet");
        this.op_mtNet = (String)this.getParameters().get("OPERATEUR:mtnet");
        this.mtBrut = (String)this.getParameters().get("VALEUR:mtbrut");
        this.op_mtBrut = (String)this.getParameters().get("OPERATEUR:mtbrut");
        this.agenStatut = (String)this.getParameters().get("VALEUR:agent_statut");
        this.op_agenStatut = "xem:StringEquals";
        this.emploi = (String)this.getParameters().get("VALEUR:emploi");
        this.op_emploi = (String)this.getParameters().get("OPERATEUR:emploi");
        this.service = (String)this.getParameters().get("VALEUR:service");
        this.op_service = (String)this.getParameters().get("OPERATEUR:service");
        this.grade = (String)this.getParameters().get("VALEUR:grade");
        this.op_grade = (String)this.getParameters().get("OPERATEUR:grade");
        this.indice = (String)this.getParameters().get("VALEUR:indice");
        this.op_indice = (String)this.getParameters().get("OPERATEUR:indice");
        StringBuffer error = new StringBuffer();
        boolean hasError = false;
        try {
            if (this.mtNet != null && !"".equals(this.mtNet)) {
                new BigDecimal(this.mtNet);
            }
        }
        catch (NumberFormatException nfe) {
            error.append("Le champ montant net ne contient pas un montant valide\n");
            hasError = true;
        }
        try {
            if (this.mtBrut != null && !"".equals(this.mtBrut)) {
                new BigDecimal(this.mtBrut);
            }
        }
        catch (NumberFormatException nfe) {
            error.append("Le champ montant brut ne contient pas un montant valide\n");
            hasError = true;
        }
        try {
            if (this.indice != null && !"".equals(this.indice)) {
                new BigDecimal(this.indice);
            }
        }
        catch (NumberFormatException nfe) {
            error.append("Le champ montant indice ne contient pas un nombre valide\n");
            hasError = true;
        }
        if (hasError) {
            logger.error((Object)error.toString());
            throw new Exception(error.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataResultSet doInBackground() throws Exception {
        String column;
        this.computeParameters();
        MySqlDataLayer dl = (MySqlDataLayer)DataLayerManager.getImplementation();
        TDocument pc = dl.getPersistenceConfig(this.getEtatModel().getParent()).getLayer("mysql").getDocument(this.getEtatModel().getParent().getId());
        TEtat sec = pc.getEtat(this.getEtatModel().getId());
        StringBuilder request = new StringBuilder();
        String tableName = sec.getIndexTable("T1").getBaseName();
        request.append("SELECT i1.AGENT_MATRICULE from ").append(tableName).append(" i1, ").append(tableName).append(" i2 ");
        request.append(" WHERE i1.COLLECTIVITE='").append(this.getCollectivite().key).append("' AND i1.BUDGET='").append(this.getBudget().key).append("' AND i2.COLLECTIVITE=i1.COLLECTIVITE AND i2.BUDGET=i1.BUDGET ");
        request.append("AND i1.ANNEE=").append(this.year1).append(" AND i1.MOIS='").append(this.month1).append("' ");
        request.append("AND i2.ANNEE=").append(this.year2).append(" AND i2.MOIS='").append(this.month2).append("' ");
        request.append("AND i1.AGENT_MATRICULE=i2.AGENT_MATRICULE ");
        if (this.mtNet != null && !"".equals(this.mtNet)) {
            request.append(" AND i1.MT_NET ").append(this.op_mtNet).append(this.mtNet).append(" ");
        }
        if (this.mtBrut != null && !"".equals(this.mtBrut)) {
            request.append(" AND i1.MT_BRUT ").append(this.op_mtBrut).append(this.mtBrut).append(" ");
        }
        if (this.grade != null && !"".equals(this.grade)) {
            request.append(" AND i1.AGENT_GRADE ").append(this.convertOpString(this.op_grade, this.grade)).append(" ");
        }
        if (this.agenStatut != null && !"".equals(this.agenStatut)) {
            request.append(" AND i1.AGENT_STATUT ").append(this.convertOpString(this.op_agenStatut, this.agenStatut)).append(" ");
        }
        if (this.emploi != null && !"".equals(this.emploi)) {
            request.append(" AND i1.AGENT_METIER ").append(this.convertOpString(this.op_emploi, this.emploi)).append(" ");
        }
        if (this.service != null && !"".equals(this.service)) {
            request.append(" AND i1.SERVICE ").append(this.convertOpString(this.op_service, this.service)).append(" ");
        }
        if (this.indice != null && !"".equals(this.indice)) {
            request.append(" AND i1.AGENT_INDICE ").append(this.op_indice).append(this.indice).append(" ");
        }
        String string = column = "MtNet".equals(this.tag) ? "MT_NET" : "MT_BRUT";
        if (this.valeurSql != null) {
            column = this.valeurSql;
        }
        if ("percent".equals(this.typeVariation)) {
            request.append("AND ABS((i2.").append(column).append("-i1.").append(column).append(")/i1.").append(column).append("*100)>").append(this.limite);
        } else {
            request.append("AND ABS(i2.").append(column).append("-i1.").append(column).append(")>").append(this.limite);
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = dl.getConnection();
            logger.debug((Object)request.toString());
            ps = con.prepareStatement(request.toString());
            ResultSet rs = ps.executeQuery();
            ArrayList<String> matricules = new ArrayList<String>();
            while (rs.next()) {
                String matr = rs.getString(1);
                matricules.add(matr);
            }
            if (matricules.size() > 0) {
                request = new StringBuilder();
                request.append("SELECT SQL_CALC_FOUND_ROWS DOC_ID, AGENT_MATRICULE FROM ").append(tableName);
                request.append(" WHERE (( ANNEE=").append(this.year1).append(" AND MOIS='").append(this.month1).append("') OR (ANNEE=").append(this.year2).append(" AND MOIS='").append(this.month2).append("')) AND AGENT_MATRICULE IN (");
                for (String s : matricules) {
                    request.append("'").append(s).append("',");
                }
                request.deleteCharAt(request.length() - 1);
                request.append(") AND COLLECTIVITE='").append(this.getCollectivite().key).append("' AND BUDGET='").append(this.getBudget().key).append("' ");
                ListeResultatModel lrm = this.getListeResultat();
                MySqlDataResultSet mySqlDataResultSet = new MySqlDataResultSet(this.getElementModel(), this.getCollectivite(), this.getBudget(), "/n:DocumentPaye/n:DonneesIndiv/n:PayeIndivMensuel", request.toString(), lrm, dl);
                return mySqlDataResultSet;
            }
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
        }
        finally {
            if (con != null) {
                dl.releaseConnection(con);
            }
        }
        return DataLayerManager.getImplementation().getEmptyDataResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        try {
            DataResultSet rs = (DataResultSet)this.get();
            ResultDisplayerThread code = new ResultDisplayerThread(rs, this.getListeResultat(), this.getStart(), this.getElementModel(), this.getSearchWindow());
            if (SwingUtilities.isEventDispatchThread()) {
                code.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait((Runnable)code);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.firePropertyChange("COMPLETED", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Throwable t) {
            DisplayExceptionDlg.displayException((Frame)this.getOwner(), (Throwable)t);
        }
        finally {
            this.setProgressVisible(false);
            super.done();
        }
    }
}

