/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugins.paye;

import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.data.DataResultSet;
import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.MySqlDataResultSet;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TEtat;
import fr.gouv.finances.cp.xemelios.plugins.SearchPlugin;
import fr.gouv.finances.cp.xemelios.ui.search.ResultDisplayerThread;
import java.awt.Frame;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SommeHeuresSup
extends SearchPlugin {
    private static final Logger logger = Logger.getLogger(SommeHeuresSup.class);
    private String opNbHeures;
    private String start;
    private String end;
    private String nbHeures;
    private String mtNet;
    private String op_mtNet;
    private String mtBrut;
    private String op_mtBrut;
    private String agenStatut;
    private String op_agenStatut;
    private String emploi;
    private String op_emploi;
    private String service;
    private String op_service;
    private String grade;
    private String op_grade;
    private String indice;
    private String op_indice;

    public void computeParameters() throws Exception {
        this.nbHeures = (String)this.getParameters().get("VALEUR:nbHeures");
        this.opNbHeures = (String)this.getParameters().get("OPERATEUR:nbHeures");
        String yearStart = (String)this.getParameters().get("VALEUR:yearStart");
        String monthStart = (String)this.getParameters().get("VALEUR:monthStart");
        String yearEnd = (String)this.getParameters().get("VALEUR:yearEnd");
        String monthEnd = (String)this.getParameters().get("VALEUR:monthEnd");
        this.start = yearStart + monthStart;
        this.end = yearEnd + monthEnd;
        this.mtNet = (String)this.getParameters().get("VALEUR:mtnet");
        this.op_mtNet = (String)this.getParameters().get("OPERATEUR:mtnet");
        this.mtBrut = (String)this.getParameters().get("VALEUR:mtbrut");
        this.op_mtBrut = (String)this.getParameters().get("OPERATEUR:mtbrut");
        this.agenStatut = (String)this.getParameters().get("VALEUR:agent_statut");
        this.op_agenStatut = "xem:StringEquals";
        this.emploi = (String)this.getParameters().get("VALEUR:emploi");
        this.op_emploi = (String)this.getParameters().get("OPERATEUR:emploi");
        this.service = (String)this.getParameters().get("VALEUR:service");
        this.op_service = (String)this.getParameters().get("OPERATEUR:service");
        this.grade = (String)this.getParameters().get("VALEUR:grade");
        this.op_grade = (String)this.getParameters().get("OPERATEUR:grade");
        this.indice = (String)this.getParameters().get("VALEUR:indice");
        this.op_indice = (String)this.getParameters().get("OPERATEUR:indice");
        StringBuffer error = new StringBuffer();
        boolean hasError = false;
        try {
            if (this.mtNet != null && !"".equals(this.mtNet)) {
                new BigDecimal(this.mtNet);
            }
        }
        catch (NumberFormatException nfe) {
            error.append("Le champ montant net ne contient pas un montant valide\n");
            hasError = true;
        }
        try {
            if (this.mtBrut != null && !"".equals(this.mtBrut)) {
                new BigDecimal(this.mtBrut);
            }
        }
        catch (NumberFormatException nfe) {
            error.append("Le champ montant brut ne contient pas un montant valide\n");
            hasError = true;
        }
        try {
            if (this.indice != null && !"".equals(this.indice)) {
                new BigDecimal(this.indice);
            }
        }
        catch (NumberFormatException nfe) {
            error.append("Le champ montant indice ne contient pas un nombre valide\n");
            hasError = true;
        }
        if (hasError) {
            logger.error((Object)error.toString());
            throw new Exception(error.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataResultSet doInBackground() throws Exception {
        StringBuilder request = new StringBuilder();
        request.append("SELECT AGENT_MATRICULE, SUM(HEURES_SUPP) ");
        request.append("FROM PAYE_ETATPAYE_INDEX_PAYE ");
        request.append("WHERE ANNEE_MOIS>=? AND ANNEE_MOIS<=? ");
        if (this.mtNet != null && !"".equals(this.mtNet)) {
            request.append(" AND MT_NET ").append(this.op_mtNet).append(this.mtNet).append(" ");
        }
        if (this.mtBrut != null && !"".equals(this.mtBrut)) {
            request.append(" AND MT_BRUT ").append(this.op_mtBrut).append(this.mtBrut).append(" ");
        }
        if (this.grade != null && !"".equals(this.grade)) {
            request.append(" AND AGENT_GRADE ").append(this.convertOpString(this.op_grade, this.grade)).append(" ");
        }
        if (this.agenStatut != null && !"".equals(this.agenStatut)) {
            request.append(" AND AGENT_STATUT ").append(this.convertOpString(this.op_agenStatut, this.agenStatut)).append(" ");
        }
        if (this.emploi != null && !"".equals(this.emploi)) {
            request.append(" AND AGENT_METIER ").append(this.convertOpString(this.op_emploi, this.emploi)).append(" ");
        }
        if (this.service != null && !"".equals(this.service)) {
            request.append(" AND SERVICE ").append(this.convertOpString(this.op_service, this.service)).append(" ");
        }
        if (this.indice != null && !"".equals(this.indice)) {
            request.append(" AND AGENT_INDICE ").append(this.op_indice).append(this.indice).append(" ");
        }
        request.append("GROUP BY AGENT_MATRICULE HAVING SUM(HEURES_SUPP)").append(this.opNbHeures).append(this.nbHeures);
        Connection con = null;
        PreparedStatement ps = null;
        MySqlDataLayer dl = (MySqlDataLayer)DataLayerManager.getImplementation();
        TDocument pc = dl.getPersistenceConfig(this.getEtatModel().getParent()).getLayer("mysql").getDocument(this.getEtatModel().getParent().getId());
        TEtat sec = pc.getEtat(this.getEtatModel().getId());
        String tableName = sec.getIndexTable("T1").getBaseName();
        try {
            con = dl.getConnection();
            logger.debug((Object)request.toString());
            ps = con.prepareStatement(request.toString());
            ps.setString(1, this.start);
            ps.setString(2, this.end);
            ResultSet rs = ps.executeQuery();
            ArrayList<String> matricules = new ArrayList<String>();
            while (rs.next()) {
                String matr = rs.getString(1);
                matricules.add(matr);
            }
            if (matricules.size() > 0) {
                request = new StringBuilder();
                request.append("SELECT SQL_CALC_FOUND_ROWS DOC_ID, AGENT_MATRICULE FROM ").append(tableName);
                request.append(" WHERE ANNEE_MOIS>=").append(this.start).append(" AND ANNEE_MOIS<=").append(this.end).append(" AND AGENT_MATRICULE IN (");
                for (String s : matricules) {
                    request.append("'").append(s).append("',");
                }
                request.deleteCharAt(request.length() - 1);
                request.append(") AND COLLECTIVITE='").append(this.getCollectivite().key).append("' AND BUDGET='").append(this.getBudget().key).append("' ");
                ListeResultatModel lrm = this.getListeResultat();
                MySqlDataResultSet mySqlDataResultSet = new MySqlDataResultSet(this.getElementModel(), this.getCollectivite(), this.getBudget(), "/n:DocumentPaye/n:DonneesIndiv/n:PayeIndivMensuel", request.toString(), lrm, dl);
                return mySqlDataResultSet;
            }
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
        }
        finally {
            if (con != null) {
                dl.releaseConnection(con);
            }
        }
        return DataLayerManager.getImplementation().getEmptyDataResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        try {
            DataResultSet rs = (DataResultSet)this.get();
            ResultDisplayerThread code = new ResultDisplayerThread(rs, this.getListeResultat(), this.getStart(), this.getElementModel(), this.getSearchWindow());
            if (SwingUtilities.isEventDispatchThread()) {
                code.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait((Runnable)code);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.firePropertyChange("COMPLETED", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Throwable t) {
            DisplayExceptionDlg.displayException((Frame)this.getOwner(), (Throwable)t);
        }
        finally {
            this.setProgressVisible(false);
            super.done();
        }
    }
}

