/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.paye;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAY10
extends AbstractUnitControl {
    private static final Logger logger = Logger.getLogger(PAY10.class);
    public static final transient String CTRL_ID = PAY10.class.getSimpleName();
    private Vector<Anomalie> anos = new Vector();
    private String docId = null;
    private static final String ON_RETURN_ANOMALIES = "DocumentPaye/DonneesIndiv/PayeIndivMensuel/";
    private static final String CHEMIN_PK_ANNEE = "DocumentPaye/Annee/";
    private static final String CHEMIN_PK_MOIS = "DocumentPaye/Mois/";
    private static final String CHEMIN_PAYE = "DocumentPaye/DonneesIndiv/PayeIndivMensuel/";
    private static final String CHEMIN_PK_MATRICULE = "DocumentPaye/DonneesIndiv/PayeIndivMensuel/Agent/Matricule/";
    private String pk_annee = "";
    private String pk_mois = "";
    private String pk_matricule = "";
    private String payeNodeId = "";
    private static final String CHEMIN_GRADE = "DocumentPaye/DonneesIndiv/PayeIndivMensuel/[^/]*/Grade/";
    private static final String REPLACE_PAYE = "##PAYE##";
    private boolean grade_exists = false;

    public void startDocument() throws SAXException {
        logger.info((Object)("In " + CTRL_ID));
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) throws SAXException {
        if (xpath.endsWith("DocumentPaye/DonneesIndiv/PayeIndivMensuel/")) {
            this.anos = new Vector();
            this.payeNodeId = atts.getValue("ano:node-id");
            this.pk_matricule = "";
            this.grade_exists = false;
        } else if (xpath.endsWith(CHEMIN_PK_ANNEE)) {
            this.pk_annee = atts.getValue("V");
        } else if (xpath.endsWith(CHEMIN_PK_MOIS)) {
            this.pk_mois = atts.getValue("V");
        } else if (xpath.endsWith(CHEMIN_PK_MATRICULE)) {
            this.pk_matricule = atts.getValue("V");
        } else if (xpath.matches(CHEMIN_GRADE) && !"".equals(atts.getValue("V"))) {
            this.grade_exists = true;
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.endsWith("DocumentPaye/DonneesIndiv/PayeIndivMensuel/")) {
            if (!this.grade_exists) {
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(REPLACE_PAYE, this.pk_annee + " / " + this.pk_mois + " / " + this.pk_matricule);
                String path = "@added:primary-key='" + this.pk_annee + "-" + this.pk_mois + "-" + this.pk_matricule + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "";
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "Paye");
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), "etatPaye", "payeIndivMensuel", this.payeNodeId, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                ano.addNode(new Node(this.payeNodeId));
                this.anos.add(ano);
            }
            return this.anos;
        }
        return null;
    }

    public void characters(char[] ch, int start, int length, String xpath) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endPrefixMapping(String prefix, String xpath) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) throws SAXException {
    }

    public void processingInstruction(String target, String data, String xpath) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setParameters(Hashtable<String, Object> params) {
    }

    public void skippedEntity(String name, String xpath) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) throws SAXException {
    }
}

