/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugins.paye;

import fr.gouv.finances.cp.utils.StartUrl;
import fr.gouv.finances.cp.utils.xml.dompath.DomPath;
import fr.gouv.finances.cp.utils.xml.xpath.FunctionResolver;
import fr.gouv.finances.cp.xemelios.common.ToolException;
import fr.gouv.finances.cp.xemelios.common.config.PropertyModel;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TEtat;
import fr.gouv.finances.cp.xemelios.plugins.ExportPlugin;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.filechooser.FileFilter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Totalisations
extends ExportPlugin {
    private static final Logger logger = Logger.getLogger(Totalisations.class);
    private MySqlDataLayer layer = null;
    private TDocument pc = null;
    private TEtat ec = null;
    private XPathFactory xpf = null;
    private XPath xpath = null;
    private final String CRLF = System.getProperty("line.separator");
    private String groupBy = null;
    private String request = null;
    private String output = null;
    private Document repository;
    private DomPath dpLibelle = null;
    private DomPath dpCodeNatureEmpl = null;
    private DomPath dpCodeNatureSal = null;

    public Totalisations() {
        try {
            this.xpf = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        }
        catch (Throwable t) {
            this.xpf = XPathFactory.newInstance();
        }
        this.xpf.setXPathFunctionResolver((XPathFunctionResolver)new FunctionResolver());
        this.xpath = this.xpf.newXPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Long doExport() throws Exception {
        this.xpath.setNamespaceContext((NamespaceContext)this.getDocumentModel().getNamespaces());
        this.output = (String)this.getParameters().get("VALEUR:output");
        this.dpLibelle = new DomPath("n:Libelle/@V", (NamespaceContext)this.getDocumentModel().getNamespaces());
        this.dpCodeNatureEmpl = new DomPath("n:CodeNatureEmp/@V", (NamespaceContext)this.getDocumentModel().getNamespaces());
        this.dpCodeNatureSal = new DomPath("n:CodeNatureSal/@V", (NamespaceContext)this.getDocumentModel().getNamespaces());
        rq = null;
        this.repository = this.layer.getRepositoryAsDom(this.getDocumentModel(), this.getCollectivite(), this.getRefenrenceNomenclature() == null ? null : this.getRefenrenceNomenclature().key);
        rq = this.getParameterizedRequest(this.request);
        Totalisations.logger.debug((Object)rq);
        this.writeHeader();
        count = 0L;
        con = null;
        try {
            rs = this.layer.execute(rq);
            try {
                con = rs.getStatement().getConnection();
            }
            catch (Throwable t) {
                // empty catch block
            }
            while (rs.next()) {
                this.writeLine(rs);
                ++count;
            }
            ** if (con == null) goto lbl-1000
        }
        catch (SQLException sqlEx) {
            try {
                Totalisations.logger.error((Object)"", (Throwable)sqlEx);
                ** if (con == null) goto lbl-1000
            }
            catch (Throwable var7_7) {
                if (con != null) {
                    this.layer.releaseConnection(con);
                }
                throw var7_7;
            }
lbl-1000:
            // 1 sources

            {
                this.layer.releaseConnection(con);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            this.layer.releaseConnection(con);
        }
lbl-1000:
        // 2 sources

        {
        }
        this.writeFooter();
        return count;
    }

    protected void writeHeader() throws IOException {
        StringBuffer buff = new StringBuffer();
        if ("HTML".equals(this.output)) {
            buff.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>").append(this.CRLF).append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">").append(this.CRLF);
            buff.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">").append(this.CRLF);
            buff.append("\t<head>").append(this.CRLF).append("\t\t<title>Totalisation des lignes de paye par ").append("RUBRIQUE".equals(this.groupBy) ? "rubriques" : "caisses").append("</title>").append(this.CRLF);
            buff.append("\t\t<style type=\"text/css\" media=\"all\">").append(this.CRLF);
            buff.append("\t\t\tth { background-color: #BBBBBB; border-style: solid none solid solid; border-width: 1px}").append(this.CRLF);
            buff.append("\t\t\tth.right { border-right-style: solid; }").append(this.CRLF);
            buff.append("\t\t\ttd { border-style: none none solid solid; border-width: 1px}").append(this.CRLF);
            buff.append("\t\t\ttd.mt { text-align: right; }").append(this.CRLF);
            buff.append("\t\t\ttd.right { border-right-style: solid; }").append(this.CRLF);
            buff.append("\t\t\ttable,tr { padding: 0 0 0 0; }").append(this.CRLF);
            buff.append("\t\t</style>").append(this.CRLF).append("\t</head>").append(this.CRLF);
            buff.append("\t<body>").append(this.CRLF);
            buff.append("\t\t<table cellspacing=\"0\">").append(this.CRLF).append("\t\t\t<thead>").append(this.CRLF);
            if ("RUBRIQUE".equals(this.groupBy)) {
                buff.append("\t\t\t\t<tr><th>Code Rubrique</th><th>Libell\u00e9</th><th>Montant</th><th>Code Nature (part employeur)</th><th class=\"right\">Code Nature (part salariale)</th></tr>").append(this.CRLF);
            } else {
                buff.append("\t\t\t\t<tr><th>Code Caisse</th><th>Libell\u00e9</th><th class=\"right\">Montant</th></tr>").append(this.CRLF);
            }
            buff.append("\t\t\t</thead>").append(this.CRLF);
            buff.append("\t\t\t<tbody>").append(this.CRLF);
        } else if ("RUBRIQUE".equals(this.groupBy)) {
            buff.append("Code Rubrique;Libell\u00e9;Montant;Code Nature(part employeur);Code Nateur (part salariale)").append(this.CRLF);
        } else {
            buff.append("Code Caisse;Libell\u00e9;Montant").append(this.CRLF);
        }
        this.getWriter().write(buff.toString(), 0, buff.length());
    }

    protected void writeFooter() throws IOException {
        StringBuffer buff = new StringBuffer();
        if ("HTML".equals(this.output)) {
            buff.append("\t\t\t</tbody>").append(this.CRLF).append("\t\t</table>").append(this.CRLF).append("\t</body>").append(this.CRLF).append("</html>");
        }
        this.getWriter().write(buff.toString(), 0, buff.length());
    }

    protected void writeLine(ResultSet rs) throws SQLException, IOException {
        StringBuffer buff = new StringBuffer();
        if ("RUBRIQUE".equals(this.groupBy)) {
            String code = rs.getString(1);
            String libelle = rs.getString(2);
            BigDecimal bd = rs.getBigDecimal(3);
            TripleString ts = this.getInfosFromRepository(code);
            String codeNatureE = ts.getS2();
            String codeNatureS = ts.getS3();
            if (libelle == null) {
                libelle = ts.getS1();
            }
            if ("HTML".equals(this.output)) {
                buff.append("\t\t\t\t<tr><td>").append(code != null ? code : "").append("</td><td>").append(libelle != null ? libelle : "").append("</td><td class=\"mt\">").append(bd).append("</td><td>").append(codeNatureE != null ? codeNatureE : "").append("</td><td class=\"right\">").append(codeNatureS != null ? codeNatureS : "").append("</td></tr>").append(this.CRLF);
            } else {
                buff.append("\"").append(code != null ? code : "").append("\";\"").append(libelle != null ? libelle : "").append("\";").append(bd).append(";\"").append(codeNatureE != null ? codeNatureE : "").append("\";\"").append(codeNatureS != null ? codeNatureS : "").append(this.CRLF);
            }
        } else {
            String codeCaisse = rs.getString(1);
            BigDecimal mt = rs.getBigDecimal(2);
            String libelle = this.getLibelleCaisseFromRepository(codeCaisse);
            if ("HTML".equals(this.output)) {
                buff.append("\t\t\t\t<tr><td>").append(codeCaisse != null ? codeCaisse : "").append("</td><td>").append(libelle != null ? libelle : "").append("</td><td class=\"mt right\">").append(mt).append("</td></tr>").append(this.CRLF);
            } else {
                buff.append(codeCaisse != null ? codeCaisse : "").append(";\"").append(libelle != null ? libelle : "").append("\";").append(mt).append(this.CRLF);
            }
        }
        this.getWriter().write(buff.toString(), 0, buff.length());
        this.pushProgress();
    }

    private TripleString getInfosFromRepository(String codeRubrique) {
        if (this.repository == null) {
            return new TripleString();
        }
        try {
            Node node = (Node)this.xpath.evaluate("/n:DocumentPaye/n:Nomenclatures/n:NomenclatureRubriquePaye/n:Correspondance[n:Code/@V='" + codeRubrique + "']", this.repository, XPathConstants.NODE);
            return new TripleString((String)this.dpLibelle.getValue(node, true), (String)this.dpCodeNatureEmpl.getValue(node, true), (String)this.dpCodeNatureSal.getValue(node, true));
        }
        catch (Exception ex) {
            logger.error((Object)"while xpathing:", (Throwable)ex);
            return new TripleString();
        }
    }

    private String getLibelleCaisseFromRepository(String codeCaisse) {
        if (this.repository == null) {
            return "";
        }
        try {
            String s = this.xpath.evaluate("/n:DocumentPaye/n:Nomenclatures/n:NomenclatureCaisse/n:Correspondance[n:Code/@V='" + codeCaisse + "']/n:Libelle/@V", this.repository);
            return s;
        }
        catch (Exception ex) {
            logger.error((Object)"while xpathing:", (Throwable)ex);
            return "";
        }
    }

    public void computeParameters() throws Exception {
        for (PropertyModel pm : this.getPluginModel().getProperties()) {
            if ("group-by".equals(pm.getName())) {
                this.groupBy = pm.getValue();
                continue;
            }
            if (!"request-rubrique".equals(pm.getName())) continue;
            this.request = pm.getValue();
        }
        this.layer = (MySqlDataLayer)DataLayerManager.getImplementation();
        this.pc = this.layer.getPersistenceConfig(this.getDocumentModel()).getLayer("mysql").getDocument(this.getDocumentModel().getId());
        this.ec = this.pc.getEtat(this.getEtatModel().getId());
    }

    public String getDefaultFileExtension() {
        return (String)this.getParameters().get("VALEUR:output");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getParameterizedRequest(String rq) throws DataConfigurationException {
        String data = rq;
        int posParam = data.indexOf("${");
        while (posParam >= 0) {
            int posEnd = data.indexOf(125, posParam);
            if (posEnd < 0) {
                throw new DataConfigurationException("Invalid request: " + rq);
            }
            String paramName = data.substring(posParam + 2, posEnd);
            String paramValue = null;
            if (paramName.startsWith("table-")) {
                String typeTable = paramName.substring(6);
                if (!typeTable.startsWith("index-")) throw new DataConfigurationException("can only deal with index tables: ${" + paramName + "}");
                String indexId = typeTable.substring(6);
                paramValue = this.ec.getIndexTable(indexId).getBaseName();
            } else if (paramName.equals("collectivite")) {
                paramValue = this.getCollectivite().key;
            } else {
                if (!paramName.equals("budget")) throw new DataConfigurationException("can only deal with tables parameters: ${" + paramName + "}");
                paramValue = this.getBudget().key;
            }
            if (paramValue == null) {
                throw new DataConfigurationException("no value found for param ${" + paramName + "}");
            }
            data = data.replaceAll("\\$\\{" + paramName + "\\}", paramValue);
            posParam = data.indexOf("${");
        }
        int pos = data.indexOf("##");
        while (pos >= 0) {
            int endPos = data.indexOf("##", pos + 2);
            if (endPos < 0) {
                throw new DataConfigurationException("invalid expression near " + data.substring(pos));
            }
            String pattern = data.substring(pos, endPos + 2);
            String paramName = pattern.substring(2, pattern.length() - 2);
            String paramValue = (String)this.getParameters().get(paramName);
            data = paramValue != null ? ("VALEUR:mois".equals(paramName) ? data.replace(pattern, this.getMois(paramValue)) : data.replace(pattern, paramValue)) : data.replace(pattern, "\"\"");
            pos = data.indexOf("##");
        }
        if ("RUBRIQUE".equals(this.groupBy)) {
            String rub = (String)this.getParameters().get("VALEUR:Rub");
            if (rub == null) return data + " GROUP BY 1,2";
            if ("TOUS".equals(rub)) return data + " GROUP BY 1,2";
            data = data + " AND " + this.ec.getIndexTable("T2").getBaseName() + ".CODE='" + rub + "'";
            return data + " GROUP BY 1,2";
        }
        String caisse = (String)this.getParameters().get("VALEUR:caisse");
        if (caisse == null) return data + " GROUP BY 1";
        if ("TOUS".equals(caisse)) return data + " GROUP BY 1";
        data = data + " AND " + this.ec.getIndexTable("T2").getBaseName() + ".CODE_CAISSE='" + caisse + "'";
        return data + " GROUP BY 1";
    }

    private String getMois(String mois) {
        logger.debug((Object)("mois=" + mois));
        if ("TOUS".equals(mois)) {
            return "'01','02','03','04','05','06','07','08','09','10','11','12'";
        }
        return "'" + mois + "'";
    }

    public FileFilter getFileFilter() {
        String fileExt = this.getDefaultFileExtension();
        FileFilter retValue = "HTML".equals(fileExt) ? new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith("html");
            }

            public String getDescription() {
                return "Fichiers HTML";
            }
        } : new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith("csv");
            }

            public String getDescription() {
                return "Fichiers CSV";
            }
        };
        return retValue;
    }

    public void done() {
        super.done();
        if ("HTML".equals(this.output)) {
            try {
                StartUrl.startUrl((String)this.getFileName());
            }
            catch (ToolException tEx) {
                logger.error((Object)("while displaying " + this.getFileName()), (Throwable)tEx);
            }
        }
    }

    private static class TripleString {
        String s1 = null;
        String s2 = null;
        String s3 = null;

        public TripleString() {
        }

        public TripleString(String s1, String s2, String s3) {
            this();
            this.s1 = s1;
            this.s2 = s2;
            this.s3 = s3;
        }

        public String getS1() {
            return this.s1;
        }

        public String getS2() {
            return this.s2;
        }

        public String getS3() {
            return this.s3;
        }

        public void setS1(String s1) {
            this.s1 = s1;
        }

        public void setS2(String s2) {
            this.s2 = s2;
        }

        public void setS3(String s3) {
            this.s3 = s3;
        }
    }
}

