/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugins.paye;

import fr.gouv.finances.cp.utils.xml.InvalidPathExpressionException;
import fr.gouv.finances.cp.utils.xml.PathNotFoundException;
import fr.gouv.finances.cp.utils.xml.xpath.FunctionResolver;
import fr.gouv.finances.cp.xemelios.common.config.ChampModel;
import fr.gouv.finances.cp.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.cp.xemelios.common.config.PropertyModel;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TEtat;
import fr.gouv.finances.cp.xemelios.plugins.ExportPlugin;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExportLignes
extends ExportPlugin {
    private static Logger logger = Logger.getLogger(ExportLignes.class);
    public static final transient String PROPERTY_REQUEST = "request";
    public static final transient String PROPERTY_EXPORT_XPATH = "export.xpath";
    public static final transient String PROPERTY_HEADER1 = "header.field.1";
    public static final transient String PROPERTY_HEADER2 = "header.field.2";
    public static final transient String PROPERTY_FILE_EXTENSION = "default.file.extension";
    private String request;
    private String exportXPath;
    private String value1;
    private String value2;
    private String fileExtension;
    private String separator;
    private MySqlDataLayer layer = null;
    private TDocument pc = null;
    private TEtat ec = null;
    private XPathFactory xpf = null;
    DecimalFormat dfAmount = new DecimalFormat("#0.00");
    DecimalFormat dfFloat = new DecimalFormat("#0.000");

    public ExportLignes() {
        try {
            this.xpf = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        }
        catch (Throwable t) {
            this.xpf = XPathFactory.newInstance();
        }
        this.xpf.setXPathFunctionResolver((XPathFunctionResolver)new FunctionResolver());
    }

    public void computeParameters() throws Exception {
        for (PropertyModel pm : this.getPluginModel().getProperties()) {
            if (PROPERTY_REQUEST.equals(pm.getName())) {
                this.request = pm.getValue();
                continue;
            }
            if (PROPERTY_EXPORT_XPATH.equals(pm.getName())) {
                this.exportXPath = pm.getValue().replace('{', '[').replace('}', ']');
                continue;
            }
            if (PROPERTY_HEADER1.equals(pm.getName())) {
                this.value1 = pm.getValue();
                continue;
            }
            if (PROPERTY_HEADER2.equals(pm.getName())) {
                this.value2 = pm.getValue();
                continue;
            }
            if (!PROPERTY_FILE_EXTENSION.equals(pm.getName())) continue;
            this.fileExtension = pm.getValue();
        }
        this.separator = this.getPluginModel().getSeparator();
        Hashtable p = this.getParameters();
        Enumeration enumer = p.keys();
        while (enumer.hasMoreElements()) {
            String key = (String)enumer.nextElement();
            logger.debug((Object)(key + "/" + p.get(key)));
        }
        logger.debug((Object)("separator=" + this.separator));
        try {
            this.layer = (MySqlDataLayer)DataLayerManager.getImplementation();
            this.pc = this.layer.getPersistenceConfig(this.getDocumentModel()).getLayer("mysql").getDocument(this.getDocumentModel().getId());
            this.ec = this.pc.getEtat(this.getEtatModel().getId());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getParameterizedRequest(String rq) throws DataConfigurationException {
        String data = rq;
        int posParam = data.indexOf("${");
        while (posParam >= 0) {
            int posEnd = data.indexOf(125, posParam);
            if (posEnd < 0) {
                throw new DataConfigurationException("Invalid request: " + rq);
            }
            String paramName = data.substring(posParam + 2, posEnd);
            String paramValue = null;
            if (paramName.startsWith("table-")) {
                String typeTable = paramName.substring(6);
                if (!typeTable.startsWith("index-")) throw new DataConfigurationException("can only deal with index tables: ${" + paramName + "}");
                String indexId = typeTable.substring(6);
                paramValue = this.ec.getIndexTable(indexId).getBaseName();
            } else if (paramName.equals("collectivite")) {
                paramValue = StringEscapeUtils.escapeSql((String)this.getCollectivite().key);
            } else {
                if (!paramName.equals("budget")) throw new DataConfigurationException("can only deal with tables parameters: ${" + paramName + "}");
                paramValue = StringEscapeUtils.escapeSql((String)this.getBudget().key);
            }
            if (paramValue == null) {
                throw new DataConfigurationException("no value found for param ${" + paramName + "}");
            }
            data = data.replaceAll("\\$\\{" + paramName + "\\}", paramValue);
            posParam = data.indexOf("${");
        }
        logger.debug((Object)data);
        int pos = data.indexOf("##");
        while (pos >= 0) {
            int endPos = data.indexOf("##", pos + 2);
            if (endPos < 0) {
                throw new DataConfigurationException("invalid expression near " + data.substring(pos));
            }
            String pattern = data.substring(pos, endPos + 2);
            String paramName = pattern.substring(2, pattern.length() - 2);
            String paramValue = (String)this.getParameters().get(paramName);
            data = paramValue != null ? data.replace(pattern, paramValue) : data.replace(pattern, "\"\"");
            pos = data.indexOf("##");
        }
        return data;
    }

    protected String getParameterizedXPath(String rq, String element) {
        String data = rq;
        int pos = data.indexOf("##");
        while (pos >= 0) {
            int endPos = data.indexOf("##", pos + 2);
            String pattern = data.substring(pos, endPos + 2);
            String paramName = pattern.substring(2, pattern.length() - 2);
            String paramValue = null;
            paramValue = "ELEMENT".equals(paramName) ? element : (String)this.getParameters().get(paramName);
            data = paramValue != null ? data.replace(pattern, paramValue) : data.replace(pattern, "\"\"");
            pos = data.indexOf("##");
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long doExport() throws Exception {
        Long l;
        block7: {
            logger.debug((Object)"entering doExport");
            Vector<String> docs = new Vector<String>();
            Vector<String> matricules = new Vector<String>();
            String sql = this.getParameterizedRequest(this.request);
            logger.debug((Object)("SQL: " + sql));
            ResultSet rs = null;
            Connection con = null;
            try {
                rs = this.layer.execute(sql);
                con = rs.getStatement().getConnection();
                while (rs.next()) {
                    String docId = rs.getString(1);
                    logger.debug((Object)("found element " + docId));
                    docs.add(docId);
                    matricules.add(rs.getString(2));
                }
                if (this.getPluginModel().getEntete() != null) {
                    this.getWriter().write(this.getPluginModel().getEntete().getLibelle());
                    this.getWriter().newLine();
                }
                this.setProgressInfos(docs.size() + 1, this.getPluginModel().getPluginTitle());
                this.setProgressVisible(true);
                long count = 0L;
                for (int i = 0; i < docs.size(); ++i) {
                    String docId = (String)docs.elementAt(i);
                    String matricule = (String)matricules.elementAt(i);
                    logger.debug((Object)("exporting data for element " + docId));
                    this.pushProgress();
                    String xPath = this.getParameterizedXPath(this.exportXPath, docId);
                    logger.debug((Object)("Export: " + xPath));
                    Document doc = this.layer.getDocumentAsDom(this.getEtatModel(), this.getCollectivite(), this.getBudget(), docId);
                    XPath pather = this.xpf.newXPath();
                    pather.setNamespaceContext((NamespaceContext)this.getDocumentModel().getNamespaces());
                    NodeList list = (NodeList)pather.evaluate(xPath, doc, XPathConstants.NODESET);
                    for (int line = 0; line < list.getLength(); ++line) {
                        Element el = (Element)list.item(line);
                        this.getWriter().write(this.writeLine(el, matricule));
                        ++count;
                    }
                    rs.close();
                    logger.debug((Object)("element " + docId + " has " + count + " lines"));
                }
                l = new Long(count);
                if (con == null) break block7;
            }
            catch (Throwable throwable) {
                if (con != null) {
                    this.layer.releaseConnection(con);
                }
                throw throwable;
            }
            this.layer.releaseConnection(con);
        }
        return l;
    }

    protected String getLineHeader(String element) {
        StringBuffer sb = new StringBuffer();
        if (this.value1 != null) {
            sb.append((String)this.getParameters().get(this.value1));
        }
        sb.append(this.getSeparator());
        if (this.value2 != null) {
            sb.append((String)this.getParameters().get(this.value2));
        }
        sb.append(this.getSeparator());
        sb.append(element).append(this.getSeparator());
        return sb.toString();
    }

    private String getSeparator() {
        return this.separator;
    }

    public String getDefaultFileExtension() {
        return this.fileExtension;
    }

    protected String writeLine(Element el, String matricule) throws DataConfigurationException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLineHeader(matricule));
        ListeResultatModel lrm = this.getPluginModel().getListeExport();
        Enumeration enumer = lrm.getListeChamps().elements();
        while (enumer.hasMoreElements()) {
            ChampModel cm = (ChampModel)enumer.nextElement();
            try {
                Object sValue = cm.getPath().getDomPath((NamespaceContext)this.getDocumentModel().getNamespaces()).getValue((Node)el, false);
                sb.append(this.formatValue(sValue, cm.getDatatype()));
            }
            catch (PathNotFoundException pnfEx) {
            }
            catch (InvalidPathExpressionException ipeEx) {
                throw new DataConfigurationException((Throwable)ipeEx);
            }
            sb.append(this.getSeparator());
        }
        sb.append(System.getProperty("line.separator"));
        return sb.toString();
    }

    protected String formatValue(Object value, String datatype) {
        if (value instanceof String) {
            String ret = (String)value;
            if ("amount".equals(datatype)) {
                Float f = Float.valueOf(ret);
                String s = this.dfAmount.format(f);
                ret = s.replaceAll("\\.", ",");
            } else if ("decimal".equals(datatype)) {
                Float f = Float.valueOf(ret);
                String s = this.dfFloat.format(f);
                ret = s.replaceAll("\\.", ",");
            }
            return ret;
        }
        if (value != null) {
            return value.toString();
        }
        return "";
    }
}

