/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugins.paye;

import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.cp.xemelios.common.config.PropertyModel;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.data.DataResultSet;
import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.MySqlDataResultSet;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TEtat;
import fr.gouv.finances.cp.xemelios.plugins.SearchPlugin;
import fr.gouv.finances.cp.xemelios.ui.search.ResultDisplayerThread;
import java.awt.Frame;
import java.math.BigDecimal;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class EntrantsSortants
extends SearchPlugin {
    private static final Logger logger = Logger.getLogger(EntrantsSortants.class);
    private String year1;
    private String year2;
    private String month1;
    private String month2;
    private String mtNet;
    private String op_mtNet;
    private String mtBrut;
    private String op_mtBrut;
    private String agenStatut;
    private String op_agenStatut;
    private String emploi;
    private String op_emploi;
    private String service;
    private String op_service;
    private String grade;
    private String op_grade;
    private String indice;
    private String op_indice;
    private boolean bothJob = false;

    public void computeParameters() throws Exception {
        this.year1 = (String)this.getParameters().get("VALEUR:year1");
        this.month1 = (String)this.getParameters().get("VALEUR:month1");
        this.year2 = (String)this.getParameters().get("VALEUR:year2");
        this.month2 = (String)this.getParameters().get("VALEUR:month2");
        this.mtNet = (String)this.getParameters().get("VALEUR:mtnet");
        this.op_mtNet = (String)this.getParameters().get("OPERATEUR:mtnet");
        this.mtBrut = (String)this.getParameters().get("VALEUR:mtbrut");
        this.op_mtBrut = (String)this.getParameters().get("OPERATEUR:mtbrut");
        this.agenStatut = (String)this.getParameters().get("VALEUR:agent_statut");
        this.op_agenStatut = "xem:StringEquals";
        this.emploi = (String)this.getParameters().get("VALEUR:emploi");
        this.op_emploi = (String)this.getParameters().get("OPERATEUR:emploi");
        this.service = (String)this.getParameters().get("VALEUR:service");
        this.op_service = (String)this.getParameters().get("OPERATEUR:service");
        this.grade = (String)this.getParameters().get("VALEUR:grade");
        this.op_grade = (String)this.getParameters().get("OPERATEUR:grade");
        this.indice = (String)this.getParameters().get("VALEUR:indice");
        this.op_indice = (String)this.getParameters().get("OPERATEUR:indice");
        StringBuffer error = new StringBuffer();
        boolean hasError = false;
        if (this.year1 == null || this.year1.length() == 0) {
            error.append("Le champ ann\u00e9e 1 doit \u00eatre rempli\n");
            hasError = true;
        }
        if (this.year2 == null || this.year2.length() == 0) {
            error.append("Le champ ann\u00e9e 2 doit \u00eatre rempli\n");
            hasError = true;
        }
        if (this.month1 == null || this.month1.length() == 0) {
            error.append("Le champ mois 1 doit \u00eatre rempli\n");
            hasError = true;
        }
        if (this.month2 == null || this.month2.length() == 0) {
            error.append("Le champ mois 2 doit \u00eatre rempli\n");
            hasError = true;
        }
        try {
            Integer.parseInt(this.year1);
        }
        catch (NumberFormatException nfEx) {
            error.append("Le champ ann\u00e9e 1 ne contient pas une ann\u00e9e valide\n");
            hasError = true;
        }
        try {
            Integer.parseInt(this.year2);
        }
        catch (NumberFormatException nfEx) {
            error.append("Le champ ann\u00e9e 2 ne contient pas une ann\u00e9e valide\n");
            hasError = true;
        }
        try {
            if (this.mtNet != null && !"".equals(this.mtNet)) {
                new BigDecimal(this.mtNet);
            }
        }
        catch (NumberFormatException nfe) {
            error.append("Le champ montant net ne contient pas un montant valide\n");
            hasError = true;
        }
        try {
            if (this.mtBrut != null && !"".equals(this.mtBrut)) {
                new BigDecimal(this.mtBrut);
            }
        }
        catch (NumberFormatException nfe) {
            error.append("Le champ montant brut ne contient pas un montant valide\n");
            hasError = true;
        }
        try {
            if (this.indice != null && !"".equals(this.indice)) {
                new BigDecimal(this.indice);
            }
        }
        catch (NumberFormatException nfe) {
            error.append("Le champ montant indice ne contient pas un nombre valide\n");
            hasError = true;
        }
        if (hasError) {
            logger.error((Object)error.toString());
            throw new Exception(error.toString());
        }
    }

    public DataResultSet doInBackground() throws Exception {
        this.computeParameters();
        MySqlDataLayer dl = (MySqlDataLayer)DataLayerManager.getImplementation();
        TDocument pc = dl.getPersistenceConfig(this.getEtatModel().getParent()).getLayer("mysql").getDocument(this.getEtatModel().getParent().getId());
        TEtat sec = pc.getEtat(this.getEtatModel().getId());
        Vector props = this.getPluginModel().getProperties();
        for (PropertyModel property : props) {
            if (!property.getName().equals("entrants.sortants")) continue;
            this.bothJob = Boolean.parseBoolean(property.getValue());
        }
        StringBuilder request = new StringBuilder();
        request.append("SELECT SQL_CALC_FOUND_ROWS DOC_ID, ANNEE, MOIS ");
        request.append("FROM ").append(sec.getIndexTable("T1"));
        request.append(" WHERE COLLECTIVITE='").append(this.getCollectivite().key).append("' AND BUDGET='").append(this.getBudget().key);
        request.append("' AND ((ANNEE=").append(this.year1).append(" AND MOIS='").append(this.month1).append("') || (ANNEE=").append(this.year2).append(" AND MOIS='").append(this.month2).append("')) ");
        if (this.mtNet != null && !"".equals(this.mtNet)) {
            request.append(" AND MT_NET ").append(this.op_mtNet).append(this.mtNet).append(" ");
        }
        if (this.mtBrut != null && !"".equals(this.mtBrut)) {
            request.append(" AND MT_BRUT ").append(this.op_mtBrut).append(this.mtBrut).append(" ");
        }
        if (this.grade != null && !"".equals(this.grade)) {
            request.append(" AND AGENT_GRADE ").append(this.convertOpString(this.op_grade, this.grade)).append(" ");
        }
        if (this.agenStatut != null && !"".equals(this.agenStatut)) {
            request.append(" AND AGENT_STATUT ").append(this.convertOpString(this.op_agenStatut, this.agenStatut)).append(" ");
        }
        if (this.emploi != null && !"".equals(this.emploi)) {
            request.append(" AND AGENT_METIER ").append(this.convertOpString(this.op_emploi, this.emploi)).append(" ");
        }
        if (this.service != null && !"".equals(this.service)) {
            request.append(" AND SERVICE ").append(this.convertOpString(this.op_service, this.service)).append(" ");
        }
        if (this.indice != null && !"".equals(this.indice)) {
            request.append(" AND AGENT_INDICE ").append(this.op_indice).append(this.indice).append(" ");
        }
        request.append("GROUP BY AGENT_MATRICULE HAVING COUNT(AGENT_MATRICULE)=1 ");
        if (!this.bothJob) {
            request.append("AND ANNEE=").append(this.year1).append(" AND MOIS='").append(this.month1).append("'");
        }
        ListeResultatModel lrm = this.getListeResultat();
        return new MySqlDataResultSet(this.getElementModel(), this.getCollectivite(), this.getBudget(), "/n:DocumentPaye/n:DonneesIndiv/n:PayeIndivMensuel", request.toString(), lrm, dl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        try {
            DataResultSet rs = (DataResultSet)this.get();
            ResultDisplayerThread code = new ResultDisplayerThread(rs, this.getListeResultat(), this.getStart(), this.getElementModel(), this.getSearchWindow());
            if (SwingUtilities.isEventDispatchThread()) {
                code.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait((Runnable)code);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.firePropertyChange("COMPLETED", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Throwable t) {
            DisplayExceptionDlg.displayException((Frame)this.getOwner(), (Throwable)t);
        }
        finally {
            this.setProgressVisible(false);
            super.done();
        }
    }
}

