/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.paye;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAY19
extends AbstractUnitControl {
    private static final Logger logger = Logger.getLogger(PAY19.class);
    public static final transient String CTRL_ID = PAY19.class.getSimpleName();
    private Vector<Anomalie> anos = new Vector();
    private String docId = null;
    private static final String ON_RETURN_ANOMALIES = "DocumentPaye/DonneesIndiv/PayeIndivMensuel/";
    private static final String CHEMIN_PK_ANNEE = "DocumentPaye/Annee/";
    private static final String CHEMIN_PK_MOIS = "DocumentPaye/Mois/";
    private static final String CHEMIN_PAYE = "DocumentPaye/DonneesIndiv/PayeIndivMensuel/";
    private static final String CHEMIN_PK_MATRICULE = "DocumentPaye/DonneesIndiv/PayeIndivMensuel/Agent/Matricule/";
    private String pk_annee = "";
    private String pk_mois = "";
    private String pk_matricule = "";
    private String payeNodeId = "";
    private static final String CHEMIN_ADRESSE_1_AGENT = "DocumentPaye/DonneesIndiv/PayeIndivMensuel/Agent/Adresse/Adr1/";
    private static final String CHEMIN_ADRESSE_2_AGENT = "DocumentPaye/DonneesIndiv/PayeIndivMensuel/Agent/Adresse/Adr2/";
    private static final String CHEMIN_ADRESSE_3_AGENT = "DocumentPaye/DonneesIndiv/PayeIndivMensuel/Agent/Adresse/Adr3/";
    private static final String CHEMIN_ADRESSE_CODE_POSTAL_AGENT = "DocumentPaye/DonneesIndiv/PayeIndivMensuel/Agent/Adresse/CP/";
    private static final String CHEMIN_ADRESSE_VILLE_AGENT = "DocumentPaye/DonneesIndiv/PayeIndivMensuel/Agent/Adresse/Ville/";
    private static final String REPLACE_PAYE = "##PAYE##";
    private static final String REPLACE_LISTE = "##LISTE##";
    private String adr1 = "";
    private String adr2 = "";
    private String adr3 = "";
    private String cp = "";
    private String ville = "";
    private String adr1NodeId = "";
    private String adr2NodeId = "";
    private String adr3NodeId = "";
    private String cpNodeId = "";
    private String villeNodeId = "";

    public void startDocument() throws SAXException {
        logger.info((Object)("In " + CTRL_ID));
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) throws SAXException {
        if (xpath.endsWith("DocumentPaye/DonneesIndiv/PayeIndivMensuel/")) {
            this.anos = new Vector();
            this.payeNodeId = atts.getValue("ano:node-id");
            this.pk_matricule = "";
            this.adr1 = "";
            this.adr2 = "";
            this.adr3 = "";
            this.cp = "";
            this.ville = "";
        } else if (xpath.endsWith(CHEMIN_PK_ANNEE)) {
            this.pk_annee = atts.getValue("V");
        } else if (xpath.endsWith(CHEMIN_PK_MOIS)) {
            this.pk_mois = atts.getValue("V");
        } else if (xpath.endsWith(CHEMIN_PK_MATRICULE)) {
            this.pk_matricule = atts.getValue("V");
        } else if (xpath.endsWith(CHEMIN_ADRESSE_1_AGENT)) {
            this.adr1 = atts.getValue("V");
            this.adr1NodeId = atts.getValue("ano:node-id");
        } else if (xpath.endsWith(CHEMIN_ADRESSE_2_AGENT)) {
            this.adr2 = atts.getValue("V");
            this.adr2NodeId = atts.getValue("ano:node-id");
        } else if (xpath.endsWith(CHEMIN_ADRESSE_3_AGENT)) {
            this.adr3 = atts.getValue("V");
            this.adr3NodeId = atts.getValue("ano:node-id");
        } else if (xpath.endsWith(CHEMIN_ADRESSE_CODE_POSTAL_AGENT)) {
            this.cp = atts.getValue("V");
            this.cpNodeId = atts.getValue("ano:node-id");
        } else if (xpath.endsWith(CHEMIN_ADRESSE_VILLE_AGENT)) {
            this.ville = atts.getValue("V");
            this.villeNodeId = atts.getValue("ano:node-id");
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.endsWith("DocumentPaye/DonneesIndiv/PayeIndivMensuel/")) {
            Vector<Node> nodes = new Vector<Node>();
            if (!"".equals(this.adr1) && this.adr1.length() < 2) {
                nodes.add(new Node(this.adr1NodeId));
            }
            if (!"".equals(this.adr2) && this.adr2.length() < 2) {
                nodes.add(new Node(this.adr2NodeId));
            }
            if (!"".equals(this.adr3) && this.adr3.length() < 2) {
                nodes.add(new Node(this.adr3NodeId));
            }
            if (!"".equals(this.cp) && this.cp.length() < 5) {
                nodes.add(new Node(this.cpNodeId));
            }
            if (!"".equals(this.ville) && this.ville.length() < 2) {
                nodes.add(new Node(this.villeNodeId));
            }
            if (nodes.size() > 0) {
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(REPLACE_PAYE, this.pk_annee + " / " + this.pk_mois + " / " + this.pk_matricule);
                String path = "@added:primary-key='" + this.pk_annee + "-" + this.pk_mois + "-" + this.pk_matricule + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "";
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "Paye");
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), "etatPaye", "payeIndivMensuel", this.payeNodeId, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                ano.addAll(nodes);
                this.anos.add(ano);
            }
            return this.anos;
        }
        return null;
    }

    public void characters(char[] ch, int start, int length, String xpath) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endPrefixMapping(String prefix, String xpath) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) throws SAXException {
    }

    public void processingInstruction(String target, String data, String xpath) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setParameters(Hashtable<String, Object> params) {
    }

    public void skippedEntity(String name, String xpath) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) throws SAXException {
    }
}

