/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.paye;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAY16
extends AbstractUnitControl {
    private static final Logger logger = Logger.getLogger(PAY16.class);
    public static final transient String CTRL_ID = PAY16.class.getSimpleName();
    private Vector<Anomalie> anos = new Vector();
    private String docId = null;
    private static final String ON_RETURN_ANOMALIES = "DocumentPaye/DonneesIndiv/";
    private static final String CHEMIN_PAYE = "DocumentPaye/DonneesIndiv/PayeIndivMensuel/";
    private static final String[] typesLigneDevantEtrePresent = new String[]{"TraitBrut", "IndemResid", "SupFam", "AvantageNature", "Indemnite", "RemDivers", "Deduction", "Acompte", "Rappel", "Retenue", "Cotisation"};
    private static final String CHEMIN_TYPES_LIGNES = "DocumentPaye/DonneesIndiv/PayeIndivMensuel/Remuneration/[a-zA-Z]*/";
    private static final String REPLACE_PAYE = "##PAYE##";
    private static final String REPLACE_LISTE = "##LISTE##";
    private TreeSet<String> lignes = new TreeSet();

    public void startDocument() throws SAXException {
        logger.info((Object)("In " + CTRL_ID));
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) throws SAXException {
        if (xpath.endsWith(CHEMIN_PAYE)) {
            this.anos = new Vector();
            this.lignes = new TreeSet();
        } else if (xpath.matches(CHEMIN_TYPES_LIGNES)) {
            this.lignes.add(localName);
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.endsWith(ON_RETURN_ANOMALIES)) {
            ArrayList<String> liste = new ArrayList<String>();
            for (String s : typesLigneDevantEtrePresent) {
                if (this.lignes.contains(s)) continue;
                liste.add(s);
            }
            if (liste.size() > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("<ul>");
                for (String s : liste) {
                    sb.append("<li>").append(s).append("</li>");
                }
                sb.append("</ul>");
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(REPLACE_LISTE, sb.toString());
                String anoId = IdGenerator.nextId();
                String libelleLien = "";
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "Paye");
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), "etatPaye", "payeIndivMensuel", "", localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), null, xslParams);
                this.anos.add(ano);
            }
            return this.anos;
        }
        return null;
    }

    public void characters(char[] ch, int start, int length, String xpath) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endPrefixMapping(String prefix, String xpath) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) throws SAXException {
    }

    public void processingInstruction(String target, String data, String xpath) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setParameters(Hashtable<String, Object> params) {
    }

    public void skippedEntity(String name, String xpath) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) throws SAXException {
    }
}

