/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.searchParams;

import fr.gouv.finances.cp.xemelios.ui.searchParams.CommonDataUpdater;
import fr.gouv.finances.dgfip.xemelios.common.config.ChampModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ListeResultatModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXTable;

public class PnlSortBy
extends JPanel
implements CommonDataUpdater {
    private ListeResultatModel lrm;
    private Vector<ChampModel> sortableChamps;
    private Vector<ChampTriable> champsTriables;
    private AbstractTableModel tm;
    private JComboBox cbxSortBy;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JList lstChamps;
    private JButton pbAddAll;
    private JButton pbAddOne;
    private JButton pbDown;
    private JButton pbRemoveAll;
    private JButton pbRemoveOne;
    private JButton pbUp;
    private JXTable tblChampTries;

    public PnlSortBy(ListeResultatModel lrm) {
        this.lrm = lrm;
        this.initComponents();
        this.initData();
        this.initListeners();
    }

    protected void initListeners() {
        this.pbUp.setEnabled(false);
        this.pbDown.setEnabled(false);
        this.pbRemoveOne.setEnabled(false);
        this.pbAddOne.setEnabled(false);
        this.lstChamps.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (PnlSortBy.this.lstChamps.getSelectedIndices().length == 0) {
                    PnlSortBy.this.pbAddOne.setEnabled(false);
                } else {
                    PnlSortBy.this.pbAddAll.setEnabled(true);
                    PnlSortBy.this.pbAddOne.setEnabled(true);
                }
            }
        });
    }

    public void initData() {
        this.cbxSortBy = new JComboBox<String>(new String[]{"ASC", "DESC"});
        this.sortableChamps = new Vector();
        Vector champs = this.lrm.getListeChamps();
        for (ChampModel cm : champs) {
            if (!cm.isTriable()) continue;
            this.sortableChamps.add(cm);
        }
        this.champsTriables = new Vector();
        String triDefaut = this.lrm.getTriDefaut();
        String ordreDefaut = this.lrm.getOrdre();
        String[] champsTri = triDefaut.split(",");
        StringTokenizer to = new StringTokenizer(ordreDefaut, ",");
        for (String ch : champsTri) {
            String or = to.nextToken();
            if (or == null) {
                or = "ASC";
            }
            this.champsTriables.add(new ChampTriable(ch, ((ChampModel)this.lrm.getChamps().get(ch)).getLibelle(), or));
            this.sortableChamps.remove(this.lrm.getChamps().get(ch));
        }
        this.tm = new TriableTableModel(this.champsTriables);
        this.tblChampTries.setModel((TableModel)this.tm);
        this.lstChamps.setListData(this.sortableChamps);
    }

    public void tableListSelectionChanged(ListSelectionEvent e) {
        if (this.tblChampTries.getSelectedRows().length == 0) {
            this.pbUp.setEnabled(false);
            this.pbDown.setEnabled(false);
            this.pbRemoveOne.setEnabled(false);
        } else {
            this.pbUp.setEnabled(true);
            this.pbDown.setEnabled(true);
            this.pbRemoveAll.setEnabled(true);
            this.pbRemoveOne.setEnabled(true);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.lstChamps = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.tblChampTries = new JXTable(){

            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                PnlSortBy.this.tableListSelectionChanged(e);
            }

            public TableCellEditor getCellEditor(int row, int column) {
                if (column == 0) {
                    return super.getCellEditor(row, column);
                }
                DefaultCellEditor dce = new DefaultCellEditor(PnlSortBy.this.cbxSortBy);
                PnlSortBy.this.cbxSortBy.setSelectedItem(this.getValueAt(row, column));
                return dce;
            }
        };
        this.pbAddAll = new JButton();
        this.pbAddOne = new JButton();
        this.pbRemoveOne = new JButton();
        this.pbRemoveAll = new JButton();
        this.pbUp = new JButton();
        this.pbDown = new JButton();
        this.lstChamps.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.lstChamps);
        this.tblChampTries.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView((Component)this.tblChampTries);
        this.pbAddAll.setText(">>");
        this.pbAddAll.setToolTipText("Tout ajouter");
        this.pbAddAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PnlSortBy.this.pbAddAllActionPerformed(evt);
            }
        });
        this.pbAddOne.setText(">");
        this.pbAddOne.setToolTipText("Ajouter");
        this.pbAddOne.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PnlSortBy.this.pbAddOneActionPerformed(evt);
            }
        });
        this.pbRemoveOne.setText("<");
        this.pbRemoveOne.setToolTipText("Retirer");
        this.pbRemoveOne.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PnlSortBy.this.pbRemoveOneActionPerformed(evt);
            }
        });
        this.pbRemoveAll.setText("<<");
        this.pbRemoveAll.setToolTipText("Tout retirer");
        this.pbRemoveAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PnlSortBy.this.pbRemoveAllActionPerformed(evt);
            }
        });
        this.pbUp.setText("^");
        this.pbUp.setToolTipText("Monter");
        this.pbUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PnlSortBy.this.pbUpActionPerformed(evt);
            }
        });
        this.pbDown.setText("V");
        this.pbDown.setToolTipText("Descendre");
        this.pbDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PnlSortBy.this.pbDownActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -2, 267, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.pbAddOne, -1, -1, Short.MAX_VALUE).add(2, (Component)this.pbAddAll, -1, -1, Short.MAX_VALUE).add(2, (Component)this.pbRemoveAll, 0, 0, Short.MAX_VALUE).add(2, (Component)this.pbRemoveOne, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.pbDown, -1, -1, Short.MAX_VALUE).add(2, (Component)this.pbUp))).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 187, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 286, Short.MAX_VALUE).add((Component)this.jScrollPane2, -1, 286, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pbAddAll).addPreferredGap(0).add((Component)this.pbAddOne).addPreferredGap(0).add((Component)this.pbRemoveOne).addPreferredGap(0).add((Component)this.pbRemoveAll).addPreferredGap(0, 118, Short.MAX_VALUE).add((Component)this.pbUp).addPreferredGap(0).add((Component)this.pbDown))).addContainerGap()));
    }

    private void pbUpActionPerformed(ActionEvent evt) {
        int row;
        int i;
        boolean moved = false;
        int[] selectedRows = this.tblChampTries.getSelectedRows();
        for (i = 0; i < selectedRows.length; ++i) {
            row = selectedRows[i];
            if (row <= i) continue;
            ChampTriable ch = this.champsTriables.remove(row);
            this.champsTriables.insertElementAt(ch, row - 1);
            moved = true;
        }
        if (moved) {
            this.tm.fireTableDataChanged();
            for (i = 0; i < selectedRows.length; ++i) {
                row = selectedRows[i];
                if (row <= i) continue;
                this.tblChampTries.getSelectionModel().addSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private void pbDownActionPerformed(ActionEvent evt) {
        int row;
        int i;
        int[] selectedRows = this.tblChampTries.getSelectedRows();
        boolean moved = false;
        for (i = selectedRows.length - 1; i >= 0; --i) {
            row = selectedRows[i];
            if (row >= this.champsTriables.size() - i - 1) continue;
            ChampTriable ch = this.champsTriables.remove(row);
            if (row + 1 < this.champsTriables.size()) {
                this.champsTriables.insertElementAt(ch, row + 1);
            } else {
                this.champsTriables.add(ch);
            }
            moved = true;
        }
        if (moved) {
            this.tm.fireTableDataChanged();
            for (i = selectedRows.length - 1; i >= 0; --i) {
                row = selectedRows[i];
                if (row >= this.champsTriables.size() - i) continue;
                this.tblChampTries.getSelectionModel().addSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private void pbAddAllActionPerformed(ActionEvent evt) {
        for (ChampModel cm : this.sortableChamps) {
            ChampTriable ct = new ChampTriable(cm.getId(), cm.getLibelle(), "ASC");
            this.champsTriables.add(ct);
        }
        this.sortableChamps.clear();
        this.lstChamps.setListData(this.sortableChamps);
        this.tm.fireTableDataChanged();
    }

    private void pbAddOneActionPerformed(ActionEvent evt) {
        int[] indexes;
        for (int i : indexes = this.lstChamps.getSelectedIndices()) {
            ChampModel cm = this.sortableChamps.get(i);
            this.champsTriables.add(new ChampTriable(cm.getId(), cm.getLibelle(), "ASC"));
        }
        for (int i = indexes.length - 1; i >= 0; --i) {
            this.sortableChamps.remove(indexes[i]);
        }
        this.lstChamps.setListData(this.sortableChamps);
        this.tm.fireTableDataChanged();
    }

    private void pbRemoveOneActionPerformed(ActionEvent evt) {
        int[] indexes;
        for (int i : indexes = this.tblChampTries.getSelectedRows()) {
            ChampTriable ct = this.champsTriables.get(i);
            ChampModel cm = (ChampModel)this.lrm.getChamps().get(ct.id);
            this.sortableChamps.add(cm);
        }
        for (int i = indexes.length - 1; i >= 0; --i) {
            this.champsTriables.remove(indexes[i]);
        }
        this.lstChamps.setListData(this.sortableChamps);
        this.tm.fireTableDataChanged();
    }

    private void pbRemoveAllActionPerformed(ActionEvent evt) {
        for (ChampTriable ct : this.champsTriables) {
            ChampModel cm = (ChampModel)this.lrm.getChamps().get(ct.id);
            this.sortableChamps.add(cm);
        }
        this.champsTriables.clear();
        this.lstChamps.setListData(this.sortableChamps);
        this.tm.fireTableDataChanged();
    }

    public void doUpdate() {
        StringBuffer fields = new StringBuffer();
        StringBuffer sorts = new StringBuffer();
        for (ChampTriable ct : this.champsTriables) {
            fields.append(ct.id).append(",");
            sorts.append(ct.sens).append(",");
        }
        if (fields.length() > 0) {
            fields.deleteCharAt(fields.length() - 1);
            sorts.deleteCharAt(sorts.length() - 1);
        }
        this.lrm.setTriDefaut(fields.toString());
        this.lrm.setOrdre(sorts.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TriableTableModel
    extends AbstractTableModel {
        private Vector<ChampTriable> champs;

        public TriableTableModel(Vector<ChampTriable> champs) {
            this.champs = champs;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Champ";
                }
                case 1: {
                    return "Sens";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            ChampTriable ct = this.champs.get(row);
            switch (column) {
                case 0: {
                    return ct.toString();
                }
                case 1: {
                    return ct.sens;
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.champs.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ChampTriable ct = this.champs.get(rowIndex);
            ct.sens = aValue.toString();
        }
    }

    public static class ChampTriable {
        private String id;
        private String sens;
        private String desc;

        public ChampTriable(String id, String desc, String sens) {
            this.id = id;
            this.desc = desc;
            this.sens = sens;
        }

        public String toString() {
            return this.desc;
        }
    }
}

