/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.resulttable;

import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.xemelios.ui.SearchWindow;
import fr.gouv.finances.cp.xemelios.ui.resulttable.EtatResultTableModel;
import fr.gouv.finances.cp.xemelios.ui.search.ResultDisplayerThread;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.dgfip.xemelios.data.DataAccessException;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import fr.gouv.finances.dgfip.xemelios.data.DataResultSet;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PageSeeker
extends JPanel {
    private static Logger logger = Logger.getLogger(PageSeeker.class);
    private static final long serialVersionUID = 3256725086923863603L;
    private JButton pbFirstPage = null;
    private JButton pbPreviousPage = null;
    private JButton pbNextPage = null;
    private JButton pbLastPage = null;
    private JComboBox cbxPages = null;
    private JLabel label = null;
    private static Dimension buttonDim = new Dimension(20, 20);
    private int currentPage = 0;
    private int pageCount = 0;
    private SearchWindow searchWindow = null;

    public PageSeeker(SearchWindow parent) {
        this.searchWindow = parent;
        this.initComponents();
    }

    protected void initComponents() {
        IhmFactory iF = IhmFactory.newInstance();
        FlowLayout fl = new FlowLayout(0);
        fl.setHgap(0);
        fl.setVgap(0);
        this.setLayout(fl);
        this.pbFirstPage = new JButton(IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/page-first.png"));
        this.pbFirstPage.setPreferredSize(buttonDim);
        this.pbFirstPage.setToolTipText("premi\u00e8re page");
        this.add(this.pbFirstPage);
        this.pbPreviousPage = new JButton(IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/page-previous.png"));
        this.pbPreviousPage.setPreferredSize(buttonDim);
        this.add(this.pbPreviousPage);
        this.pbPreviousPage.setToolTipText("page pr\u00e9c\u00e9dente");
        this.cbxPages = new JComboBox();
        this.cbxPages.setEditable(false);
        this.cbxPages.setPreferredSize(new Dimension(50, (int)buttonDim.getHeight()));
        this.cbxPages.setPrototypeDisplayValue("0000");
        this.cbxPages.addItem("");
        this.add(this.cbxPages);
        this.label = new JLabel("/     ");
        this.add(this.label);
        this.pbNextPage = new JButton(IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/page-next.png"));
        this.pbNextPage.setPreferredSize(buttonDim);
        this.pbNextPage.setToolTipText("page suivante");
        this.add(this.pbNextPage);
        this.pbLastPage = new JButton(IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/page-last.png"));
        this.pbLastPage.setPreferredSize(buttonDim);
        this.pbLastPage.setToolTipText("derni\u00e8re page");
        this.add(this.pbLastPage);
        this.reset();
    }

    public void updateData(DataResultSet rs) {
        this.reset();
        this.pageCount = rs.getEstimatedPageCount();
        this.cbxPages.removeAllItems();
        for (int i = 1; i <= this.pageCount; ++i) {
            this.cbxPages.addItem(new Integer(i));
        }
        this.currentPage = rs.getCurrentPage();
        this.cbxPages.setSelectedItem(new Integer(this.currentPage + 1));
        StringBuilder sb = new StringBuilder();
        sb.append("/ ").append(this.pageCount);
        while (sb.length() < 6) {
            sb.append(" ");
        }
        this.label.setText(sb.toString());
        if (rs.hasPreviousPage()) {
            this.pbPreviousPage.setEnabled(true);
            this.pbPreviousPage.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PageSeeker.this.searchWindow.setCursor(new Cursor(3));
                    PageSeeker.this.searchWindow.setSearchEnabled(false);
                    PageSeeker.this.searchWindow.getParentFrame().startWaiter();
                    EtatResultTableModel etrm = (EtatResultTableModel)PageSeeker.this.searchWindow.getTable().getModel();
                    DataResultSet rs = etrm.getResultSet();
                    OtherPageSeeker ops = new OtherPageSeeker(rs, rs.getListeResultatModel(), PageSeeker.this.searchWindow.getELementModel(), PageSeeker.this.searchWindow, -1);
                    if (SwingUtilities.isEventDispatchThread()) {
                        ops.run();
                    } else {
                        SwingUtilities.invokeLater(ops);
                    }
                }
            });
            this.pbFirstPage.setEnabled(true);
            this.pbFirstPage.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PageSeeker.this.searchWindow.setCursor(new Cursor(3));
                    PageSeeker.this.searchWindow.setSearchEnabled(false);
                    PageSeeker.this.searchWindow.getParentFrame().startWaiter();
                    EtatResultTableModel etrm = (EtatResultTableModel)PageSeeker.this.searchWindow.getTable().getModel();
                    DataResultSet rs = etrm.getResultSet();
                    OtherPageSeeker ops = new OtherPageSeeker(rs, rs.getListeResultatModel(), PageSeeker.this.searchWindow.getELementModel(), PageSeeker.this.searchWindow, -2);
                    if (SwingUtilities.isEventDispatchThread()) {
                        ops.run();
                    } else {
                        SwingUtilities.invokeLater(ops);
                    }
                }
            });
        } else {
            this.pbPreviousPage.setEnabled(false);
            this.pbFirstPage.setEnabled(false);
        }
        if (rs.hasNextPage()) {
            this.pbNextPage.setEnabled(true);
            this.pbNextPage.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PageSeeker.this.searchWindow.setCursor(new Cursor(3));
                    PageSeeker.this.searchWindow.setSearchEnabled(false);
                    PageSeeker.this.searchWindow.getParentFrame().startWaiter();
                    EtatResultTableModel etrm = (EtatResultTableModel)PageSeeker.this.searchWindow.getTable().getModel();
                    DataResultSet rs = etrm.getResultSet();
                    OtherPageSeeker ops = new OtherPageSeeker(rs, rs.getListeResultatModel(), PageSeeker.this.searchWindow.getELementModel(), PageSeeker.this.searchWindow, 1);
                    if (SwingUtilities.isEventDispatchThread()) {
                        ops.run();
                    } else {
                        SwingUtilities.invokeLater(ops);
                    }
                }
            });
            this.pbLastPage.setEnabled(true);
            this.pbLastPage.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PageSeeker.this.searchWindow.setCursor(new Cursor(3));
                    PageSeeker.this.searchWindow.setSearchEnabled(false);
                    PageSeeker.this.searchWindow.getParentFrame().startWaiter();
                    EtatResultTableModel etrm = (EtatResultTableModel)PageSeeker.this.searchWindow.getTable().getModel();
                    DataResultSet rs = etrm.getResultSet();
                    OtherPageSeeker ops = new OtherPageSeeker(rs, rs.getListeResultatModel(), PageSeeker.this.searchWindow.getELementModel(), PageSeeker.this.searchWindow, 2);
                    if (SwingUtilities.isEventDispatchThread()) {
                        ops.run();
                    } else {
                        SwingUtilities.invokeLater(ops);
                    }
                }
            });
        } else {
            this.pbNextPage.setEnabled(false);
            this.pbLastPage.setEnabled(false);
        }
        if (this.pageCount > 0) {
            this.cbxPages.setEnabled(true);
            this.cbxPages.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        logger.debug((Object)"ITEM SELECTED");
                        Integer i = (Integer)e.getItem();
                        PageSeeker.this.searchWindow.setCursor(new Cursor(3));
                        PageSeeker.this.searchWindow.setSearchEnabled(false);
                        PageSeeker.this.searchWindow.getParentFrame().startWaiter();
                        EtatResultTableModel etrm = (EtatResultTableModel)PageSeeker.this.searchWindow.getTable().getModel();
                        DataResultSet rs = etrm.getResultSet();
                        OtherPageSeeker ops = new OtherPageSeeker(rs, rs.getListeResultatModel(), PageSeeker.this.searchWindow.getELementModel(), PageSeeker.this.searchWindow, 0, i - 1);
                        if (SwingUtilities.isEventDispatchThread()) {
                            ops.run();
                        } else {
                            SwingUtilities.invokeLater(ops);
                        }
                    }
                }
            });
        } else {
            this.cbxPages.setEnabled(false);
        }
    }

    public void reset() {
        this.pbFirstPage.setEnabled(false);
        this.pbPreviousPage.setEnabled(false);
        this.pbLastPage.setEnabled(false);
        this.pbNextPage.setEnabled(false);
        this.cbxPages.setEnabled(false);
        this.cbxPages.removeAllItems();
        for (ActionListener actionListener : this.pbFirstPage.getActionListeners()) {
            this.pbFirstPage.removeActionListener(actionListener);
        }
        for (ActionListener actionListener : this.pbPreviousPage.getActionListeners()) {
            this.pbPreviousPage.removeActionListener(actionListener);
        }
        for (ActionListener actionListener : this.pbNextPage.getActionListeners()) {
            this.pbNextPage.removeActionListener(actionListener);
        }
        for (ActionListener actionListener : this.pbLastPage.getActionListeners()) {
            this.pbLastPage.removeActionListener(actionListener);
        }
        for (EventListener eventListener : this.cbxPages.getItemListeners()) {
            this.cbxPages.removeItemListener((ItemListener)eventListener);
        }
    }

    private static class OtherPageSeeker
    implements Runnable {
        public static final int FIRST_PAGE = -2;
        public static final int PREVIOUS_PAGE = -1;
        public static final int SET_PAGE = 0;
        public static final int NEXT_PAGE = 1;
        public static final int LAST_PAGE = 2;
        private DataResultSet rs = null;
        private ListeResultatModel lrm = null;
        private ElementModel em = null;
        private SearchWindow sw = null;
        int way = 0;
        int page = -1;

        public OtherPageSeeker(DataResultSet rs, ListeResultatModel lrm, ElementModel em, SearchWindow sw, int way) {
            this.rs = rs;
            this.lrm = lrm;
            this.em = em;
            this.sw = sw;
            this.way = way;
        }

        public OtherPageSeeker(DataResultSet rs, ListeResultatModel lrm, ElementModel em, SearchWindow sw, int way, int page) {
            this.rs = rs;
            this.lrm = lrm;
            this.em = em;
            this.sw = sw;
            this.way = way;
            this.page = page;
        }

        public void run() {
            long start = System.currentTimeMillis();
            this.sw.getPageSeeker().reset();
            try {
                switch (this.way) {
                    case -2: {
                        this.rs.firstPage();
                        break;
                    }
                    case -1: {
                        this.rs.previousPage();
                        break;
                    }
                    case 1: {
                        this.rs.nextPage();
                        break;
                    }
                    case 2: {
                        this.rs.lastPage();
                        break;
                    }
                    case 0: {
                        this.rs.setPage(this.page);
                    }
                }
                ResultDisplayerThread rdt = new ResultDisplayerThread(this.rs, this.lrm, start, this.em, this.sw);
                SwingUtilities.invokeLater(rdt);
            }
            catch (DataAccessException daEx) {
                new DisplayExceptionDlg((Frame)this.sw.getParentFrame(), (Throwable)daEx);
            }
            catch (DataConfigurationException dcEx) {
                new DisplayExceptionDlg((Frame)this.sw.getParentFrame(), (Throwable)dcEx);
            }
        }
    }
}

