/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.export;

import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.cp.xemelios.ui.export.DlgSearchConfig;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.ChampModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EtatModel;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import fr.gouv.finances.dgfip.xemelios.export.ConfigModel;
import fr.gouv.finances.dgfip.xemelios.export.ConfigParser;
import fr.gouv.finances.dgfip.xemelios.export.ExportChampModel;
import fr.gouv.finances.dgfip.xemelios.export.ExportElementModel;
import fr.gouv.finances.dgfip.xemelios.export.ExportModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditConfig
extends JDialog {
    private static final long serialVersionUID = 5669669876743219771L;
    private static Logger logger = Logger.getLogger(EditConfig.class);
    private DocumentModel dm;
    private ConfigModel cm;
    private String docID;
    private String etatID;
    private ExportModel data = new ExportModel(ExportModel.QN);
    private ExportModel dataToBeModified = null;
    private AbstractAction escapeAction;
    private XemeliosUser user;
    private JButton bAnnuler;
    private JButton bEnregistrer;
    private JButton bSelectAll;
    private JButton bSelectNone;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane liste;
    private JTextField tCode;
    private JTextField tLibelle;
    private JXTreeTable treeTable;

    public EditConfig(JDialog parent, DocumentModel d, ConfigModel c, XemeliosUser user) {
        super(parent);
        this.dm = d;
        this.docID = this.dm.getId();
        this.cm = c;
        this.etatID = this.cm.getEtatID();
        this.user = user;
        try {
            ConfigParser cp = new ConfigParser();
            cp.parse((InputStream)new ByteArrayInputStream(c.getConfigLines()));
            this.dataToBeModified = (ExportModel)cp.getMarshallable();
        }
        catch (Exception e) {
            logger.error((Object)"Erreur lors de la lecture de la configuration \u00e0 modifier", (Throwable)e);
        }
        this.initComponents();
        this.tCode.setText(c.getCode());
        this.tLibelle.setText(c.getLibelle());
        this.setLocationRelativeTo(this.getParent());
        this.treeTable.setTreeTableModel((TreeTableModel)this.createModel(this.dm, this.cm.getEtatID()));
        this.updateModel();
        this.treeTable.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                EditConfig.this.treeTable.packAll();
            }
        });
        this.treeTable.getColumnModel().getColumn(1).setMaxWidth(25);
        this.treeTable.expandAll();
    }

    public EditConfig(JDialog parent, DocumentModel d, String etatID, XemeliosUser user) {
        super(parent);
        this.dm = d;
        this.docID = this.dm.getId();
        this.etatID = etatID;
        this.user = user;
        this.initComponents();
        this.setLocationRelativeTo(this.getParent());
        this.treeTable.setTreeTableModel((TreeTableModel)this.createModel(this.dm, etatID));
        this.treeTable.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                EditConfig.this.treeTable.packAll();
            }
        });
        this.treeTable.getColumnModel().getColumn(1).setMaxWidth(25);
        this.treeTable.expandAll();
    }

    private void updateModel() {
        if (this.dataToBeModified != null) {
            for (ExportElementModel eemDest : this.data.getEnfants()) {
                String eID = eemDest.getId();
                for (ExportElementModel eemRef : this.dataToBeModified.getEnfants()) {
                    if (!eemRef.getId().equals(eID)) continue;
                    this.updateEEM(eemRef, eemDest);
                }
            }
        }
    }

    private void updateEEM(ExportElementModel reference, ExportElementModel destination) {
        for (ExportChampModel ecmDest : destination.getChamps()) {
            String cID = ecmDest.getId();
            for (ExportChampModel ecmRef : reference.getChamps()) {
                if (!ecmRef.getId().equals(cID)) continue;
                ecmDest.setSelectionne(ecmRef.isSelectionne());
            }
        }
        for (ExportElementModel eemDest : destination.getEnfants()) {
            String eID = eemDest.getId();
            for (ExportElementModel eemRef : reference.getEnfants()) {
                if (!eemRef.getId().equals(eID)) continue;
                this.updateEEM(eemRef, eemDest);
            }
        }
    }

    private ConfigTreeTableModel createModel(DocumentModel dm, String etatID) {
        ConfigTreeTableModel ret = new ConfigTreeTableModel(this.data);
        EtatModel em = dm.getEtatById(etatID);
        ElementModel emROOT = null;
        for (String k : em.getElements().keySet()) {
            ElementModel tmp = (ElementModel)em.getElements().get(k);
            if (tmp.getSimpleParent() != null) continue;
            emROOT = tmp;
            break;
        }
        if (emROOT != null) {
            try {
                ExportModel exm = new ExportModel(ExportModel.QN);
                exm.setId(this.cm != null ? this.cm.getId() : "");
                exm.setCode(this.cm != null ? this.cm.getCode() : "");
                exm.setLibelle(this.cm != null ? this.cm.getLibelle() : "");
                ExportElementModel eem = this.buildEEM(emROOT, null);
                if (emROOT.getEnfant() != null) {
                    eem.setEnfants(this.readChildren(emROOT, em, eem));
                }
                exm.addEnfant(eem);
                this.data = exm;
                ret.setData(exm);
            }
            catch (Exception e) {
                logger.error((Object)"Erreur lors de la lecture de la d\u00e9finition de la configuration", (Throwable)e);
            }
        } else {
            logger.error((Object)"Impossible de trouver l'\u00e9l\u00e9ment ROOT");
        }
        return ret;
    }

    private Vector<ExportElementModel> readChildren(ElementModel p, EtatModel em, ExportElementModel parent) throws Exception {
        Vector<ExportElementModel> ret = new Vector<ExportElementModel>();
        for (String k : p.getEnfant().getEnfants().keySet()) {
            ElementModel child = em.getElementById(k);
            ExportElementModel eem = this.buildEEM(child, parent);
            if (child.getEnfant() != null && child.getEnfant().getEnfants().size() > 0) {
                eem.setEnfants(this.readChildren(child, em, eem));
            }
            ret.add(eem);
        }
        return ret;
    }

    private ExportElementModel buildEEM(ElementModel em, ExportElementModel parent) throws Exception {
        ExportElementModel ret = new ExportElementModel(ExportElementModel.QN);
        ret.setId(em.getId());
        ret.setLibelle(em.getTitre());
        ret.setParent(parent);
        ExportElementModel eemRef = null;
        if (this.dataToBeModified != null) {
            eemRef = this.findCorrespondingEEM(ret, this.dataToBeModified.getEnfants());
        }
        for (ChampModel tmpC : em.getListeResultat().getListeChamps()) {
            if (!tmpC.isExportable()) continue;
            ExportChampModel ecm = new ExportChampModel(ExportChampModel.QN);
            ecm.setId(tmpC.getId());
            ecm.setLibelle(tmpC.getLibelle());
            ecm.setEditable(!tmpC.isIdentifiant());
            ecm.setIdentifiant(tmpC.isIdentifiant());
            if (eemRef != null) {
                ExportChampModel ecmRef = this.findCorrespondingECM(ecm, eemRef);
                if (ecmRef != null) {
                    ecm.setSelectionne(ecmRef.isSelectionne());
                } else {
                    ecm.setSelectionne(false);
                }
            } else {
                ecm.setSelectionne(false);
            }
            ret.addChamp(ecm);
        }
        return ret;
    }

    private ExportChampModel findCorrespondingECM(ExportChampModel ecm, ExportElementModel eem) {
        for (ExportChampModel e : eem.getChamps()) {
            if (!e.getId().equals(ecm.getId())) continue;
            return ecm;
        }
        return null;
    }

    private ExportElementModel findCorrespondingEEM(ExportElementModel eem, Vector<ExportElementModel> liste) {
        ExportElementModel ret = null;
        for (ExportElementModel e : liste) {
            if (e.getId().equals(eem.getId())) {
                ret = e;
                break;
            }
            if (e.getEnfants().size() <= 0 || (ret = this.findCorrespondingEEM(eem, e.getEnfants())) == null) continue;
            break;
        }
        return ret;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.tCode = new JTextField();
        this.tLibelle = new JTextField();
        this.jPanel2 = new JPanel();
        this.bSelectNone = new JButton();
        this.bSelectAll = new JButton();
        this.liste = new JScrollPane();
        this.treeTable = new JXTreeTablePropertyEditor();
        this.bEnregistrer = new JButton();
        this.bAnnuler = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Configuration d'export");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Identification"));
        this.jLabel1.setText("Code");
        this.jLabel2.setText("Libell\u00e9");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).add(26, 26, 26).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.tLibelle, -1, 581, Short.MAX_VALUE).add((Component)this.tCode, -1, 581, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.tCode, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.tLibelle, -2, -1, -2).add((Component)this.jLabel2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Configuration"));
        this.bSelectNone.setText("Tout d\u00e9s\u00e9lectionner");
        this.bSelectNone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditConfig.this.bSelectNoneActionPerformed(evt);
            }
        });
        this.bSelectAll.setText("Tout s\u00e9lectionner");
        this.bSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditConfig.this.bSelectAllActionPerformed(evt);
            }
        });
        this.treeTable.setAutoResizeMode(3);
        this.liste.setViewportView((Component)this.treeTable);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap(390, Short.MAX_VALUE).add((Component)this.bSelectAll).addPreferredGap(0).add((Component)this.bSelectNone)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.liste, -1, 653, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.bSelectNone).add((Component)this.bSelectAll)).addPreferredGap(0, 12, Short.MAX_VALUE).add((Component)this.liste, -2, -1, -2).addContainerGap()));
        this.bEnregistrer.setText("Enregistrer");
        this.bEnregistrer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditConfig.this.bEnregistrerActionPerformed(evt);
            }
        });
        this.bAnnuler.setText("Annuler");
        this.bAnnuler.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditConfig.this.bAnnulerActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bAnnuler).addPreferredGap(0).add((Component)this.bEnregistrer))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.bEnregistrer).add((Component)this.bAnnuler)).addContainerGap()));
        this.pack();
    }

    private void bEnregistrerActionPerformed(ActionEvent evt) {
        boolean needInsert = false;
        if (this.cm == null) {
            this.cm = new ConfigModel(ConfigModel.QN);
            needInsert = true;
        }
        try {
            this.cm.setCode(this.tCode.getText());
            this.cm.setLibelle(this.tLibelle.getText());
            this.data.setId(this.cm.getCode());
            this.data.setLibelle(this.cm.getLibelle());
            this.cm.setDocID(this.docID);
            this.cm.setEtatID(this.etatID);
            this.cm.setOwner(MainWindow.getInstance().getConnectedUser().getId());
            this.ensureKeysSelected();
            ByteArrayOutputStream sos = new ByteArrayOutputStream();
            OutputStreamWriter os = new OutputStreamWriter((OutputStream)sos, "ISO-8859-1");
            XmlOutputter xo = new XmlOutputter(os, "ISO-8859-1");
            this.data.marshall(xo);
            os.flush();
            this.cm.setConfigLines(sos.toByteArray());
            if (needInsert) {
                DataLayerManager.getImplementation().insertConfigExport(this.cm, this.user);
            } else {
                DataLayerManager.getImplementation().updateConfigExport(this.cm, this.user);
            }
            ((DlgSearchConfig)this.getParent()).bRechercherActionPerformed(null);
        }
        catch (Exception e) {
            logger.error((Object)"Erreur lors de la sauvegarde de la configuration", (Throwable)e);
        }
        this.dispose();
    }

    private void ensureKeysSelected() {
        Vector<ExportElementModel> toSelect = new Vector<ExportElementModel>();
        for (ExportElementModel ecm : this.data.getEnfants()) {
            this.browseChildrenToSelect(ecm, toSelect);
        }
        for (ExportElementModel e : toSelect) {
            e.selectChampsKey();
            e.selectParentChampsKey();
        }
    }

    private void browseChildrenToSelect(ExportElementModel parent, Vector<ExportElementModel> toSelect) {
        if (parent.hasChampSelected()) {
            toSelect.add(parent);
        }
        for (ExportElementModel ecm : parent.getEnfants()) {
            this.browseChildrenToSelect(ecm, toSelect);
        }
    }

    private void bAnnulerActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void bSelectNoneActionPerformed(ActionEvent evt) {
        this.toggleAll(false);
        this.treeTable.repaint();
    }

    private void bSelectAllActionPerformed(ActionEvent evt) {
        this.toggleAll(true);
        this.treeTable.repaint();
    }

    private void toggleAll(boolean select) {
        for (ExportElementModel eem : this.data.getEnfants()) {
            this.toggle(eem, select);
        }
    }

    private void toggle(ExportElementModel e, boolean select) {
        for (ExportChampModel ecm : e.getChamps()) {
            ecm.setSelectionne(select);
        }
        for (ExportElementModel eem : e.getEnfants()) {
            this.toggle(eem, select);
        }
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JRootPane rp = new JRootPane();
        this.escapeAction = new AbstractAction("Fermer"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                EditConfig.this.setVisible(false);
            }
        };
        rp.registerKeyboardAction(this.escapeAction, "TOTOTOTO", ks, 2);
        return rp;
    }

    private static class ConfigTreeTableModel
    extends DefaultTreeTableModel {
        private String[] columnNames = new String[]{"", ""};
        private ExportModel _data;

        public ConfigTreeTableModel(ExportModel data) {
            this._data = data;
        }

        public boolean isLeaf(Object node) {
            if (node instanceof ExportElementModel) {
                return ((ExportElementModel)node).getEnfants().size() == 0 && ((ExportElementModel)node).getChamps().size() == 0;
            }
            if (node instanceof ExportChampModel) {
                return true;
            }
            return true;
        }

        public Class getColumnClass(int i) {
            if (i == 0) {
                return super.getColumnClass(i);
            }
            if (i == 1) {
                return Boolean.class;
            }
            return super.getColumnClass(i);
        }

        public Object getValueAt(Object object, int i) {
            if (object instanceof ExportElementModel) {
                if (i == 0) {
                    return ((ExportElementModel)object).getLibelle();
                }
                if (i == 1) {
                    return new Boolean(Boolean.FALSE);
                }
                return "";
            }
            if (i == 0) {
                return ((ExportChampModel)object).getLibelle();
            }
            if (i == 1) {
                return new Boolean(((ExportChampModel)object).isSelectionne());
            }
            return "";
        }

        public void setValueAt(Object value, Object node, int column) {
            ExportChampModel ecm = (ExportChampModel)node;
            if (column == 1) {
                ecm.setSelectionne(((Boolean)value).booleanValue());
            }
        }

        public int getChildCount(Object parent) {
            if (parent instanceof ExportElementModel) {
                ExportElementModel eem = (ExportElementModel)parent;
                return eem.getEnfants().size() + eem.getChamps().size();
            }
            if (parent instanceof ExportChampModel) {
                return 0;
            }
            return 0;
        }

        public Object getChild(Object parent, int index) {
            if (parent instanceof ExportElementModel) {
                ExportElementModel eem = (ExportElementModel)parent;
                if (index < eem.getChamps().size()) {
                    return eem.getChamps().get(index);
                }
                return eem.getEnfants().get(index - eem.getChamps().size());
            }
            return null;
        }

        public boolean isCellEditable(Object object, int i) {
            return object instanceof ExportChampModel;
        }

        public int getIndexOfChild(Object parent, Object child) {
            block4: {
                if (!(parent instanceof ExportElementModel)) break block4;
                ExportElementModel p = (ExportElementModel)parent;
                if (child instanceof ExportChampModel) {
                    ExportChampModel c = (ExportChampModel)child;
                    for (int i = 0; i < p.getChamps().size(); ++i) {
                        ExportChampModel t = (ExportChampModel)p.getChamps().get(i);
                        if (!t.getId().equals(c.getId())) continue;
                        return i;
                    }
                } else {
                    ExportElementModel c = (ExportElementModel)child;
                    for (int i = 0; i < p.getEnfants().size(); ++i) {
                        ExportElementModel t = (ExportElementModel)p.getEnfants().get(i);
                        if (!t.getId().equals(c.getId())) continue;
                        return i + p.getChamps().size();
                    }
                }
            }
            return -1;
        }

        public Object getRoot() {
            return this._data.getEnfants().get(0);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount2() {
            int ret = this.getChampsCount(this._data);
            if (this._data.getEnfants().size() > 0) {
                ret += this.getChildsCount(this._data);
            }
            return ret;
        }

        public int getChampsCount(Object parent) {
            return ((ExportElementModel)parent).getChamps().size();
        }

        public int getChildsCount(Object parent) {
            int ret = this.getChampsCount(parent);
            for (ExportElementModel eem : ((ExportElementModel)parent).getEnfants()) {
                ret += this.getChildsCount(eem);
            }
            return ret;
        }

        public String getColumnName(int arg0) {
            return this.columnNames[arg0];
        }

        public ExportModel getData() {
            return this._data;
        }

        public void setData(ExportModel data) {
            this._data = data;
        }
    }

    private static class JXTreeTablePropertyEditor
    extends JXTreeTable {
        private static final long serialVersionUID = -5756581514191559300L;
        private TableCellRenderer booleanRenderer = new DefaultTableCellRenderer(){
            private JCheckBox chk = new JCheckBox();

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.chk.setSelected((Boolean)value);
                this.chk.setBackground(lbl.getBackground());
                this.chk.setBorder(lbl.getBorder());
                return this.chk;
            }
        };
        private TableCellRenderer booleanDisabledRenderer = new DefaultTableCellRenderer(){
            private JCheckBox chk = new JCheckBox();

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.chk.setSelected((Boolean)value);
                this.chk.setBackground(lbl.getBackground());
                this.chk.setBorder(lbl.getBorder());
                this.chk.setEnabled(false);
                return this.chk;
            }
        };
        private TableCellRenderer blankRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                lbl.setText("");
                return lbl;
            }
        };

        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 1 && this.getTreeTableModel() instanceof ConfigTreeTableModel) {
                ConfigTreeTableModel model = (ConfigTreeTableModel)this.getTreeTableModel();
                Object node = this.getPathForRow(row).getLastPathComponent();
                if (node instanceof ExportChampModel) {
                    return this.booleanRenderer;
                }
                if (node instanceof ExportElementModel) {
                    return this.blankRenderer;
                }
                return super.getCellRenderer(row, column);
            }
            return super.getCellRenderer(row, column);
        }
    }
}

