/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import java.awt.Color;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Element;

public class CodeViewer
extends JFrame {
    private static JTextArea jta;
    private static JTextArea lines;
    private JScrollPane jsp;
    private URL input;

    public CodeViewer(URL input) {
        super(input.getFile());
        this.input = input;
        this.setDefaultCloseOperation(2);
        this.jsp = new JScrollPane();
        jta = new JTextArea();
        lines = new JTextArea("1");
        lines.setBackground(Color.LIGHT_GRAY);
        lines.setEditable(false);
        jta.getDocument().addDocumentListener(new DocumentListener(){

            public String getText() {
                int caretPosition = jta.getDocument().getLength();
                Element root = jta.getDocument().getDefaultRootElement();
                String text = "1" + System.getProperty("line.separator");
                for (int i = 2; i < root.getElementIndex(caretPosition) + 2; ++i) {
                    text = text + i + System.getProperty("line.separator");
                }
                return text;
            }

            public void changedUpdate(DocumentEvent de) {
                lines.setText(this.getText());
            }

            public void insertUpdate(DocumentEvent de) {
                lines.setText(this.getText());
            }

            public void removeUpdate(DocumentEvent de) {
                lines.setText(this.getText());
            }
        });
        this.jsp.getViewport().add(jta);
        this.jsp.setRowHeaderView(lines);
        this.jsp.setVerticalScrollBarPolicy(22);
        this.add(this.jsp);
        this.pack();
        this.setSize(800, 600);
        this.setVisible(true);
        this.doLoadFile();
    }

    protected void doLoadFile() {
        try {
            InputStream is = this.input.openStream();
            StringBuilder sb = new StringBuilder();
            byte[] buffer = new byte[1024];
            int read = is.read(buffer);
            while (read > 0) {
                sb.append(new String(buffer, 0, read));
                read = is.read(buffer);
            }
            jta.setText(sb.toString());
            jta.setCaretPosition(0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Erreur", 0);
        }
    }
}

