/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugins;

import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.xemelios.plugins.XemeliosPlugin;
import fr.gouv.finances.cp.xemelios.ui.search.ResultDisplayerThread;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.dgfip.xemelios.data.DataResultSet;
import fr.gouv.finances.dgfip.xemelios.plugins.SearchPlugin;
import javax.swing.SwingUtilities;

public class SearchPluginRunner
extends XemeliosPlugin {
    private ListeResultatModel lrm;
    private XemeliosUser user;
    private SearchPlugin plugin;

    public SearchPluginRunner(XemeliosUser user) {
        this.user = user;
    }

    public void setPlugin(SearchPlugin plugin) {
        this.plugin = plugin;
    }

    public DataResultSet doInBackground() throws Exception {
        this.plugin.setParameters(this.getParameters());
        this.plugin.setElementModel(this.getElementModel());
        this.plugin.setListeResultatModel(this.lrm);
        return this.plugin.getResultSet();
    }

    public void startSearch() throws Exception {
        this.execute();
    }

    public int getPluginType() {
        return 1;
    }

    public DataResultSet getResultSet() throws Exception {
        return (DataResultSet)this.get();
    }

    public void setListeResultat(ListeResultatModel lrm) {
        this.lrm = lrm;
    }

    public ListeResultatModel getListeResultat() {
        return this.lrm;
    }

    public XemeliosUser getUser() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        try {
            DataResultSet rs = (DataResultSet)this.get();
            ResultDisplayerThread code = new ResultDisplayerThread(rs, this.getListeResultat(), this.getStart(), this.getElementModel(), this.getSearchWindow());
            if (SwingUtilities.isEventDispatchThread()) {
                code.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(code);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.firePropertyChange("COMPLETED", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Throwable t) {
            DisplayExceptionDlg.displayException(this.getOwner(), t);
        }
        finally {
            this.setProgressVisible(false);
            super.done();
        }
    }
}

