/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugins;

import fr.gouv.finances.cp.utils.StartUrl;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.xemelios.plugins.XemeliosPlugin;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.plugins.ExportPlugin;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ExportPluginRunner
extends XemeliosPlugin {
    private static Logger logger = Logger.getLogger(ExportPluginRunner.class);
    private Throwable exceptionDuringProcess = null;
    private String fileName = null;
    private XemeliosUser user;
    private ExportPlugin plugin;

    public ExportPluginRunner(XemeliosUser user) {
        this.user = user;
    }

    public Long doInBackground() throws Exception {
        Long nbExport = new Long(0L);
        try {
            nbExport = this.plugin.doExport();
        }
        catch (Throwable t) {
            logger.error((Object)"in doExport:", t);
            this.exceptionDuringProcess = t;
        }
        return nbExport;
    }

    public int getPluginType() {
        return 2;
    }

    public ExportPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(ExportPlugin plugin) {
        this.plugin = plugin;
    }

    public StringBuffer getBuffer() throws Exception {
        return (StringBuffer)this.get();
    }

    public void done() {
        super.done();
        this.terminate();
    }

    public void terminate() {
        try {
            if (this.plugin.getOutputStream() != null) {
                this.plugin.getOutputStream().flush();
                this.plugin.getOutputStream().close();
            }
        }
        catch (IOException ioEx) {
            logger.error((Object)"closing outputstream", (Throwable)ioEx);
        }
        this.setProgressVisible(false);
        if (this.exceptionDuringProcess != null) {
            new DisplayExceptionDlg((Frame)this.getSearchWindow().getParentFrame(), this.exceptionDuringProcess);
        } else {
            try {
                StartUrl.startUrl(this.fileName);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.getSearchWindow().setSearchEnabled(true);
        try {
            logger.debug((Object)("finished: " + this.get().toString()));
        }
        catch (Throwable t) {
            logger.fatal((Object)"interrupted");
        }
    }

    public void startExport() throws Exception {
        this.plugin.setProgressListener((ExportPlugin.ProgressListener)this);
        this.plugin.computeParameters();
        File f = this.getFileToExportTo(this.plugin.getDefaultFileExtension());
        if (f != null) {
            this.fileName = f.toURL().toExternalForm();
            if (f.getName().indexOf(".") < 0) {
                f = new File(f.getParent(), f.getName() + "." + this.plugin.getDefaultFileExtension());
                this.fileName = f.toURL().toExternalForm();
            }
            this.plugin.setOutputStream((OutputStream)new FileOutputStream(f));
            this.execute();
        } else {
            this.setProgressVisible(false);
            this.getSearchWindow().setSearchEnabled(true);
            this.getSearchWindow().setCursor(Cursor.getDefaultCursor());
            this.getSearchWindow().getParentFrame().stopWaiter();
        }
    }

    protected File getFileToExportTo(String defaultExtension) throws IOException {
        File ret = null;
        MyFileFilter ff = null;
        if (ff == null) {
            ff = new MyFileFilter(defaultExtension);
        }
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(ff);
        if (fc.showSaveDialog(this.getOwner()) == 0 && (ret = fc.getSelectedFile()).exists()) {
            int response = JOptionPane.showConfirmDialog(this.getOwner(), "Ce fichier existe d\u00e9j\u00e0. Voulez-vous l'\u00e9craser ?", "Confirmation", 1);
            switch (response) {
                case 2: {
                    ret = null;
                    break;
                }
                case 1: {
                    ret = this.getFileToExportTo(defaultExtension);
                    break;
                }
                case 0: {
                    ret.delete();
                }
            }
        }
        return ret;
    }

    protected String getFileName() {
        return this.fileName;
    }

    public XemeliosUser getUser() {
        return this.user;
    }

    public static class MyFileFilter
    extends FileFilter {
        private String ext;

        public MyFileFilter(String extension) {
            this.ext = extension != null ? (extension.startsWith(".") ? extension : "." + extension) : "  ";
        }

        public boolean accept(File f) {
            return f.getName().endsWith(this.ext);
        }

        public String getDescription() {
            return "Fichiers " + this.ext.substring(1);
        }
    }
}

