/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.patches;

import fr.gouv.finances.cp.xemelios.patches.Core3316;
import fr.gouv.finances.cp.xemelios.updater.AbstractConfigurator;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.data.DataImpl;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import fr.gouv.finances.dgfip.xemelios.export.ConfigModel;
import fr.gouv.finances.dgfip.xemelios.export.ConfigParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;

public class Core33114
extends AbstractConfigurator {
    private static final String CFG_PAYE_BULLETIN = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"documentPaye\" etatID=\"etatPaye\" owner=\"Xemelios\" code=\"Bulletin - Tous champs\" libelle=\"Bulletin (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJC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\n</ConfigModel>";
    public static final String CFG_PAYE_REPART_NAT = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"documentPaye\" etatID=\"RepartitionNature\" owner=\"Xemelios\" code=\"R\u00e9part. Nat - Tous champs\" libelle=\"R\u00e9part. Nature (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJS\n6XBhcnQuIE5hdHVyZSAtIFRvdXMgY2hhbXBzIiBsaWJlbGxlPSJS6XBhcnQuIE5hdHVyZSAoY29u\nZmlnLiBwYXIgZOlmYXV0KSIgY29kZT0iIj4KIDxlbGVtZW50IGlkPSJEZXRhaWxSZXBhcnRpdGlv\nbk5hdHVyZSIgbGliZWxsZT0iUulwYXJ0aXRpb24gcGFyIG5hdHVyZSI+CiAgPGNoYW1wIGlkPSJl\nNWxyMSIgbGliZWxsZT0iQW5u6WUiIGVkaXRhYmxlPSJmYWxzZSIgc2VsZWN0aW9ubmU9InRydWUi\nIGlkZW50aWZpYW50PSJ0cnVlIi8+CiAgPGNoYW1wIGlkPSJlNWxyMiIgbGliZWxsZT0iTW9pcyIg\nZWRpdGFibGU9ImZhbHNlIiBzZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9InRydWUiLz4K\nICA8Y2hhbXAgaWQ9ImU1bHIzIiBsaWJlbGxlPSJMaWJlbGzpIiBlZGl0YWJsZT0idHJ1ZSIgc2Vs\nZWN0aW9ubmU9InRydWUiIGlkZW50aWZpYW50PSJmYWxzZSIvPgogIDxjaGFtcCBpZD0iZTVscjQi\nIGxpYmVsbGU9IkNvZGUiIGVkaXRhYmxlPSJmYWxzZSIgc2VsZWN0aW9ubmU9InRydWUiIGlkZW50\naWZpYW50PSJ0cnVlIi8+CiAgPGNoYW1wIGlkPSJlNWxyNSIgbGliZWxsZT0iTW9udGFudCIgZWRp\ndGFibGU9InRydWUiIHNlbGVjdGlvbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0iZmFsc2UiLz4KICA8\nY2hhbXAgaWQ9ImU1bHI2IiBsaWJlbGxlPSJDb2RlIEJ1ZGdldCIgZWRpdGFibGU9ImZhbHNlIiBz\nZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9InRydWUiLz4KICA8Y2hhbXAgaWQ9ImU1bHI3\nIiBsaWJlbGxlPSJDb2RlIEZvbmN0aW9uIiBlZGl0YWJsZT0iZmFsc2UiIHNlbGVjdGlvbm5lPSJ0\ncnVlIiBpZGVudGlmaWFudD0idHJ1ZSIvPjwvZWxlbWVudD4KPC9leHBvcnQ+Cg==\n</ConfigModel>";
    private static final String CFG_VERSEMENT_VERS = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"etatVersement\" etatID=\"etatVersement\" owner=\"Xemelios\" code=\"Versement - Tous champs\" libelle=\"Versement (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJW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\nZSIvPjwvZWxlbWVudD4KPC9leHBvcnQ+Cg==\n</ConfigModel>";
    private static final String CFG_VERSEMENT_REPART = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"etatVersement\" etatID=\"RepartitionNature\" owner=\"Xemelios\" code=\"R\u00e9part. Nat - Tous champs\" libelle=\"R\u00e9part. Nature (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJS\n6XBhcnQuIE5hdHVyZSAtIFRvdXMgY2hhbXBzIiBsaWJlbGxlPSJS6XBhcnQuIE5hdHVyZSAoY29u\nZmlnLiBwYXIgZOlmYXV0KSIgY29kZT0iIj4KIDxlbGVtZW50IGlkPSJEZXRhaWxSZXBhcnRpdGlv\nbk5hdHVyZSIgbGliZWxsZT0iUulwYXJ0aXRpb25zIHBhciBuYXR1cmUiPgogIDxjaGFtcCBpZD0i\nbHJ4MSIgbGliZWxsZT0iQW5u6WUiIGVkaXRhYmxlPSJ0cnVlIiBzZWxlY3Rpb25uZT0idHJ1ZSIg\naWRlbnRpZmlhbnQ9ImZhbHNlIi8+CiAgPGNoYW1wIGlkPSJscngyIiBsaWJlbGxlPSJMaWJlbGzp\nIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0aW9ubmU9InRydWUiIGlkZW50aWZpYW50PSJmYWxzZSIv\nPgogIDxjaGFtcCBpZD0ibHJ4MyIgbGliZWxsZT0iQ29kZSIgZWRpdGFibGU9InRydWUiIHNlbGVj\ndGlvbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0iZmFsc2UiLz4KICA8Y2hhbXAgaWQ9ImxyeDQiIGxp\nYmVsbGU9Ik1vbnRhbnQiIGVkaXRhYmxlPSJ0cnVlIiBzZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRp\nZmlhbnQ9ImZhbHNlIi8+CiAgPGNoYW1wIGlkPSJscng1IiBsaWJlbGxlPSJDb2RlIEJ1ZGdldCIg\nZWRpdGFibGU9InRydWUiIHNlbGVjdGlvbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0iZmFsc2UiLz4K\nICA8Y2hhbXAgaWQ9ImxyeDYiIGxpYmVsbGU9IkNvZGUgRm9uY3Rpb24iIGVkaXRhYmxlPSJ0cnVl\nIiBzZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9ImZhbHNlIi8+PC9lbGVtZW50Pgo8L2V4\ncG9ydD4K\n</ConfigModel>";
    private static final String CFG_FACTURE_DEP = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"DOC_FactureDepense\" etatID=\"PESFacture\" owner=\"Xemelios\" code=\"Facture D\u00e9p. Tous champs\" libelle=\"Facture D\u00e9p. (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJG\nYWN0dXJlIETpcC4gVG91cyBjaGFtcHMiIGxpYmVsbGU9IkZhY3R1cmUgROlwLiAoY29uZmlnLiBw\nYXIgZOlmYXV0KSIgY29kZT0iIj4KIDxlbGVtZW50IGlkPSJGYWN0dXJlSW5kaXYiIGxpYmVsbGU9\nIkZhY3R1cmUgZGUgZOlwZW5zZSI+CiAgPGNoYW1wIGlkPSJscjEiIGxpYmVsbGU9IkRhdGUgZCfp\nbWlzc2lvbiIgZWRpdGFibGU9InRydWUiIHNlbGVjdGlvbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0i\nZmFsc2UiLz4KICA8Y2hhbXAgaWQ9ImxyMTEiIGxpYmVsbGU9IklEIEVtZXR0ZXVyIiBlZGl0YWJs\nZT0idHJ1ZSIgc2VsZWN0aW9ubmU9InRydWUiIGlkZW50aWZpYW50PSJmYWxzZSIvPgogIDxjaGFt\ncCBpZD0ibHIxMiIgbGliZWxsZT0iTm9tIEVtZXR0ZXVyIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0\naW9ubmU9InRydWUiIGlkZW50aWZpYW50PSJmYWxzZSIvPgogIDxjaGFtcCBpZD0ibHIxMyIgbGli\nZWxsZT0iUHLpbm9tIEVtZXR0ZXVyIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0aW9ubmU9InRydWUi\nIGlkZW50aWZpYW50PSJmYWxzZSIvPgogIDxjaGFtcCBpZD0ibHIxNCIgbGliZWxsZT0iQWRyZXNz\nZSBFbWV0dGV1ciAtIGxvY2FsaXNhdGlvbiIgZWRpdGFibGU9InRydWUiIHNlbGVjdGlvbm5lPSJ0\ncnVlIiBpZGVudGlmaWFudD0iZmFsc2UiLz4KICA8Y2hhbXAgaWQ9ImxyMTUiIGxpYmVsbGU9IkFk\ncmVzc2UgRW1ldHRldXIgLSBwcmluY2lwYWxlIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0aW9ubmU9\nInRydWUiIGlkZW50aWZpYW50PSJmYWxzZSIvPgogIDxjaGFtcCBpZD0ibHIxNiIgbGliZWxsZT0i\nQWRyZXNzZSBFbWV0dGV1ciAtIGNvbXBs6W1lbnQiIGVkaXRhYmxlPSJ0cnVlIiBzZWxlY3Rpb25u\nZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9ImZhbHNlIi8+CiAgPGNoYW1wIGlkPSJscjE3IiBsaWJlbGxl\nPSJDb2RlIHBvc3RhbCBFbWV0dGV1ciIgZWRpdGFibGU9InRydWUiIHNlbGVjdGlvbm5lPSJ0cnVl\nIiBpZGVudGlmaWFudD0iZmFsc2UiLz4KICA8Y2hhbXAgaWQ9ImxyMTgiIGxpYmVsbGU9IlZpbGxl\nIEVtZXR0ZXVyIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0aW9ubmU9InRydWUiIGlkZW50aWZpYW50\nPSJmYWxzZSIvPgogIDxjaGFtcCBpZD0ibHI2IiBsaWJlbGxlPSJNb250YW50IEhUIiBlZGl0YWJs\nZT0idHJ1ZSIgc2VsZWN0aW9ubmU9InRydWUiIGlkZW50aWZpYW50PSJmYWxzZSIvPgogIDxjaGFt\ncCBpZD0ibHI3IiBsaWJlbGxlPSJNb250YW50IFRWQSIgZWRpdGFibGU9InRydWUiIHNlbGVjdGlv\nbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0iZmFsc2UiLz4KICA8Y2hhbXAgaWQ9ImxyOCIgbGliZWxs\nZT0iTW9udGFudCBUVEMiIGVkaXRhYmxlPSJ0cnVlIiBzZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRp\nZmlhbnQ9ImZhbHNlIi8+PC9lbGVtZW50Pgo8L2V4cG9ydD4K\n</ConfigModel>";
    private static final String CFG_CARTE_ACHAT = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"PES_ReleveCarteAchat\" etatID=\"PES_CarteAchat\" owner=\"Xemelios\" code=\"Carte achat - Tous champs\" libelle=\"Carte achat (cofnig. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJD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\nPC9lbGVtZW50Pgo8L2V4cG9ydD4K\n</ConfigModel>";
    private static final String CFG_FACTURE_REC = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"DOC_FactureRecette\" etatID=\"PESFacture\" owner=\"Xemelios\" code=\"Facture Rec. - Tous champ\" libelle=\"Facture Rec. (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJG\nYWN0dXJlIFJlYy4gLSBUb3VzIGNoYW1wcyIgbGliZWxsZT0iRmFjdHVyZSBSZWMuIChjb25maWcu\nIHBhciBk6WZhdXQpIiBjb2RlPSIiPgogPGVsZW1lbnQgaWQ9IkZhY3R1cmVJbmRpdiIgbGliZWxs\nZT0iRmFjdHVyZSBkZSByZWNldHRlIj4KICA8Y2hhbXAgaWQ9ImxyMSIgbGliZWxsZT0iRGF0ZSBk\nJ+ltaXNzaW9uIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0aW9ubmU9InRydWUiIGlkZW50aWZpYW50\nPSJmYWxzZSIvPgogIDxjaGFtcCBpZD0ibHIxMSIgbGliZWxsZT0iSUQgROliaXRldXIiIGVkaXRh\nYmxlPSJ0cnVlIiBzZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9ImZhbHNlIi8+CiAgPGNo\nYW1wIGlkPSJscjEyIiBsaWJlbGxlPSJOb20gROliaXRldXIiIGVkaXRhYmxlPSJ0cnVlIiBzZWxl\nY3Rpb25uZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9ImZhbHNlIi8+CiAgPGNoYW1wIGlkPSJscjEzIiBs\naWJlbGxlPSJQculub20gROliaXRldXIiIGVkaXRhYmxlPSJ0cnVlIiBzZWxlY3Rpb25uZT0idHJ1\nZSIgaWRlbnRpZmlhbnQ9ImZhbHNlIi8+CiAgPGNoYW1wIGlkPSJscjE0IiBsaWJlbGxlPSJBZHJl\nc3NlIETpYml0ZXVyIC0gbG9jYWxpc2F0aW9uIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0aW9ubmU9\nInRydWUiIGlkZW50aWZpYW50PSJmYWxzZSIvPgogIDxjaGFtcCBpZD0ibHIxNSIgbGliZWxsZT0i\nQWRyZXNzZSBE6WJpdGV1ciAtIHByaW5jaXBhbGUiIGVkaXRhYmxlPSJ0cnVlIiBzZWxlY3Rpb25u\nZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9ImZhbHNlIi8+CiAgPGNoYW1wIGlkPSJscjE2IiBsaWJlbGxl\nPSJBZHJlc3NlIETpYml0ZXVyIC0gY29tcGzpbWVudCIgZWRpdGFibGU9InRydWUiIHNlbGVjdGlv\nbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0iZmFsc2UiLz4KICA8Y2hhbXAgaWQ9ImxyMTciIGxpYmVs\nbGU9IkNQIETpYml0ZXVyIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0aW9ubmU9InRydWUiIGlkZW50\naWZpYW50PSJmYWxzZSIvPgogIDxjaGFtcCBpZD0ibHIxOCIgbGliZWxsZT0iVmlsbGUgROliaXRl\ndXIiIGVkaXRhYmxlPSJ0cnVlIiBzZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9ImZhbHNl\nIi8+CiAgPGNoYW1wIGlkPSJscjYiIGxpYmVsbGU9Ik1vbnRhbnQgSFQiIGVkaXRhYmxlPSJ0cnVl\nIiBzZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9ImZhbHNlIi8+CiAgPGNoYW1wIGlkPSJs\ncjciIGxpYmVsbGU9Ik1vbnRhbnQgVFZBIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0aW9ubmU9InRy\ndWUiIGlkZW50aWZpYW50PSJmYWxzZSIvPgogIDxjaGFtcCBpZD0ibHI4IiBsaWJlbGxlPSJNb250\nYW50IFRUQyIgZWRpdGFibGU9InRydWUiIHNlbGVjdGlvbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0i\nZmFsc2UiLz48L2VsZW1lbnQ+CjwvZXhwb3J0Pgo=\n</ConfigModel>";
    private static final String CFG_QUITTANCEMENT = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"DOC_Quittancement\" etatID=\"PESFacture\" owner=\"Xemelios\" code=\"Quittance - Tous champs\" libelle=\"Quittance (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJR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\nPC9lbGVtZW50Pgo8L2V4cG9ydD4K\n</ConfigModel>";
    private static final String CFG_PES_DEP = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"PES_Aller\" etatID=\"PES_DepenseAller\" owner=\"Xemelios\" code=\"PES D\u00e9pense - Tous champs\" libelle=\"PES D\u00e9pense (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJQ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\nZW50PgogPC9lbGVtZW50Pgo8L2V4cG9ydD4K\n</ConfigModel>";
    private static final String CFG_PES_REC = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"PES_Aller\" etatID=\"PES_RecetteAller\" owner=\"Xemelios\" code=\"PES Recette - Tous champs\" libelle=\"PES Recette (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJQ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\nL2V4cG9ydD4K\n</ConfigModel>";
    private static final String CFG_PES_PJ = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"PES_Aller\" etatID=\"PES_PJ\" owner=\"Xemelios\" code=\"PES PJ - Tous champs\" libelle=\"PES PJ (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJQ\nRVMgUEogLSBUb3VzIGNoYW1wcyIgbGliZWxsZT0iUEVTIFBKIChjb25maWcuIHBhciBk6WZhdXQp\nIiBjb2RlPSIiPgogPGVsZW1lbnQgaWQ9IlBKIiBsaWJlbGxlPSJQaehjZXMgSnVzdGlmaWNhdGl2\nZXMiPgogIDxjaGFtcCBpZD0iZTdscjEiIGxpYmVsbGU9IlR5cGVQSiIgZWRpdGFibGU9InRydWUi\nIHNlbGVjdGlvbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0iZmFsc2UiLz4KICA8Y2hhbXAgaWQ9ImU3\nbHIyIiBsaWJlbGxlPSJOb21QSiIgZWRpdGFibGU9InRydWUiIHNlbGVjdGlvbm5lPSJ0cnVlIiBp\nZGVudGlmaWFudD0iZmFsc2UiLz4KICA8Y2hhbXAgaWQ9ImU3bHIzIiBsaWJlbGxlPSJEZXNjcmlw\ndGlvbiIgZWRpdGFibGU9InRydWUiIHNlbGVjdGlvbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0iZmFs\nc2UiLz4KICA8Y2hhbXAgaWQ9ImU3bHI0IiBsaWJlbGxlPSJJZFVuaXF1ZSIgZWRpdGFibGU9ImZh\nbHNlIiBzZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9InRydWUiLz4KICA8Y2hhbXAgaWQ9\nImU3bHI1IiBsaWJlbGxlPSJTZXJ2ZXVySWQiIGVkaXRhYmxlPSJ0cnVlIiBzZWxlY3Rpb25uZT0i\ndHJ1ZSIgaWRlbnRpZmlhbnQ9ImZhbHNlIi8+PC9lbGVtZW50Pgo8L2V4cG9ydD4K\n</ConfigModel>";
    private static final String CFG_ERAR = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"erar\" etatID=\"LigneERAR\" owner=\"Xemelios\" code=\"ERAR - Tous champs\" libelle=\"ERAR (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJF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\nZGVudGlmaWFudD0iZmFsc2UiLz48L2VsZW1lbnQ+CjwvZXhwb3J0Pgo=\n</ConfigModel>";
    private static final String[] EXPORT_CONFIGS = new String[]{"<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"documentPaye\" etatID=\"etatPaye\" owner=\"Xemelios\" code=\"Bulletin - Tous champs\" libelle=\"Bulletin (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJC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\n</ConfigModel>", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"documentPaye\" etatID=\"RepartitionNature\" owner=\"Xemelios\" code=\"R\u00e9part. Nat - Tous champs\" libelle=\"R\u00e9part. Nature (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJS\n6XBhcnQuIE5hdHVyZSAtIFRvdXMgY2hhbXBzIiBsaWJlbGxlPSJS6XBhcnQuIE5hdHVyZSAoY29u\nZmlnLiBwYXIgZOlmYXV0KSIgY29kZT0iIj4KIDxlbGVtZW50IGlkPSJEZXRhaWxSZXBhcnRpdGlv\nbk5hdHVyZSIgbGliZWxsZT0iUulwYXJ0aXRpb24gcGFyIG5hdHVyZSI+CiAgPGNoYW1wIGlkPSJl\nNWxyMSIgbGliZWxsZT0iQW5u6WUiIGVkaXRhYmxlPSJmYWxzZSIgc2VsZWN0aW9ubmU9InRydWUi\nIGlkZW50aWZpYW50PSJ0cnVlIi8+CiAgPGNoYW1wIGlkPSJlNWxyMiIgbGliZWxsZT0iTW9pcyIg\nZWRpdGFibGU9ImZhbHNlIiBzZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9InRydWUiLz4K\nICA8Y2hhbXAgaWQ9ImU1bHIzIiBsaWJlbGxlPSJMaWJlbGzpIiBlZGl0YWJsZT0idHJ1ZSIgc2Vs\nZWN0aW9ubmU9InRydWUiIGlkZW50aWZpYW50PSJmYWxzZSIvPgogIDxjaGFtcCBpZD0iZTVscjQi\nIGxpYmVsbGU9IkNvZGUiIGVkaXRhYmxlPSJmYWxzZSIgc2VsZWN0aW9ubmU9InRydWUiIGlkZW50\naWZpYW50PSJ0cnVlIi8+CiAgPGNoYW1wIGlkPSJlNWxyNSIgbGliZWxsZT0iTW9udGFudCIgZWRp\ndGFibGU9InRydWUiIHNlbGVjdGlvbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0iZmFsc2UiLz4KICA8\nY2hhbXAgaWQ9ImU1bHI2IiBsaWJlbGxlPSJDb2RlIEJ1ZGdldCIgZWRpdGFibGU9ImZhbHNlIiBz\nZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9InRydWUiLz4KICA8Y2hhbXAgaWQ9ImU1bHI3\nIiBsaWJlbGxlPSJDb2RlIEZvbmN0aW9uIiBlZGl0YWJsZT0iZmFsc2UiIHNlbGVjdGlvbm5lPSJ0\ncnVlIiBpZGVudGlmaWFudD0idHJ1ZSIvPjwvZWxlbWVudD4KPC9leHBvcnQ+Cg==\n</ConfigModel>", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"etatVersement\" etatID=\"etatVersement\" owner=\"Xemelios\" code=\"Versement - Tous champs\" libelle=\"Versement (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJW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\nZSIvPjwvZWxlbWVudD4KPC9leHBvcnQ+Cg==\n</ConfigModel>", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"etatVersement\" etatID=\"RepartitionNature\" owner=\"Xemelios\" code=\"R\u00e9part. Nat - Tous champs\" libelle=\"R\u00e9part. Nature (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJS\n6XBhcnQuIE5hdHVyZSAtIFRvdXMgY2hhbXBzIiBsaWJlbGxlPSJS6XBhcnQuIE5hdHVyZSAoY29u\nZmlnLiBwYXIgZOlmYXV0KSIgY29kZT0iIj4KIDxlbGVtZW50IGlkPSJEZXRhaWxSZXBhcnRpdGlv\nbk5hdHVyZSIgbGliZWxsZT0iUulwYXJ0aXRpb25zIHBhciBuYXR1cmUiPgogIDxjaGFtcCBpZD0i\nbHJ4MSIgbGliZWxsZT0iQW5u6WUiIGVkaXRhYmxlPSJ0cnVlIiBzZWxlY3Rpb25uZT0idHJ1ZSIg\naWRlbnRpZmlhbnQ9ImZhbHNlIi8+CiAgPGNoYW1wIGlkPSJscngyIiBsaWJlbGxlPSJMaWJlbGzp\nIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0aW9ubmU9InRydWUiIGlkZW50aWZpYW50PSJmYWxzZSIv\nPgogIDxjaGFtcCBpZD0ibHJ4MyIgbGliZWxsZT0iQ29kZSIgZWRpdGFibGU9InRydWUiIHNlbGVj\ndGlvbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0iZmFsc2UiLz4KICA8Y2hhbXAgaWQ9ImxyeDQiIGxp\nYmVsbGU9Ik1vbnRhbnQiIGVkaXRhYmxlPSJ0cnVlIiBzZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRp\nZmlhbnQ9ImZhbHNlIi8+CiAgPGNoYW1wIGlkPSJscng1IiBsaWJlbGxlPSJDb2RlIEJ1ZGdldCIg\nZWRpdGFibGU9InRydWUiIHNlbGVjdGlvbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0iZmFsc2UiLz4K\nICA8Y2hhbXAgaWQ9ImxyeDYiIGxpYmVsbGU9IkNvZGUgRm9uY3Rpb24iIGVkaXRhYmxlPSJ0cnVl\nIiBzZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9ImZhbHNlIi8+PC9lbGVtZW50Pgo8L2V4\ncG9ydD4K\n</ConfigModel>", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"DOC_FactureDepense\" etatID=\"PESFacture\" owner=\"Xemelios\" code=\"Facture D\u00e9p. Tous champs\" libelle=\"Facture D\u00e9p. (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJG\nYWN0dXJlIETpcC4gVG91cyBjaGFtcHMiIGxpYmVsbGU9IkZhY3R1cmUgROlwLiAoY29uZmlnLiBw\nYXIgZOlmYXV0KSIgY29kZT0iIj4KIDxlbGVtZW50IGlkPSJGYWN0dXJlSW5kaXYiIGxpYmVsbGU9\nIkZhY3R1cmUgZGUgZOlwZW5zZSI+CiAgPGNoYW1wIGlkPSJscjEiIGxpYmVsbGU9IkRhdGUgZCfp\nbWlzc2lvbiIgZWRpdGFibGU9InRydWUiIHNlbGVjdGlvbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0i\nZmFsc2UiLz4KICA8Y2hhbXAgaWQ9ImxyMTEiIGxpYmVsbGU9IklEIEVtZXR0ZXVyIiBlZGl0YWJs\nZT0idHJ1ZSIgc2VsZWN0aW9ubmU9InRydWUiIGlkZW50aWZpYW50PSJmYWxzZSIvPgogIDxjaGFt\ncCBpZD0ibHIxMiIgbGliZWxsZT0iTm9tIEVtZXR0ZXVyIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0\naW9ubmU9InRydWUiIGlkZW50aWZpYW50PSJmYWxzZSIvPgogIDxjaGFtcCBpZD0ibHIxMyIgbGli\nZWxsZT0iUHLpbm9tIEVtZXR0ZXVyIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0aW9ubmU9InRydWUi\nIGlkZW50aWZpYW50PSJmYWxzZSIvPgogIDxjaGFtcCBpZD0ibHIxNCIgbGliZWxsZT0iQWRyZXNz\nZSBFbWV0dGV1ciAtIGxvY2FsaXNhdGlvbiIgZWRpdGFibGU9InRydWUiIHNlbGVjdGlvbm5lPSJ0\ncnVlIiBpZGVudGlmaWFudD0iZmFsc2UiLz4KICA8Y2hhbXAgaWQ9ImxyMTUiIGxpYmVsbGU9IkFk\ncmVzc2UgRW1ldHRldXIgLSBwcmluY2lwYWxlIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0aW9ubmU9\nInRydWUiIGlkZW50aWZpYW50PSJmYWxzZSIvPgogIDxjaGFtcCBpZD0ibHIxNiIgbGliZWxsZT0i\nQWRyZXNzZSBFbWV0dGV1ciAtIGNvbXBs6W1lbnQiIGVkaXRhYmxlPSJ0cnVlIiBzZWxlY3Rpb25u\nZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9ImZhbHNlIi8+CiAgPGNoYW1wIGlkPSJscjE3IiBsaWJlbGxl\nPSJDb2RlIHBvc3RhbCBFbWV0dGV1ciIgZWRpdGFibGU9InRydWUiIHNlbGVjdGlvbm5lPSJ0cnVl\nIiBpZGVudGlmaWFudD0iZmFsc2UiLz4KICA8Y2hhbXAgaWQ9ImxyMTgiIGxpYmVsbGU9IlZpbGxl\nIEVtZXR0ZXVyIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0aW9ubmU9InRydWUiIGlkZW50aWZpYW50\nPSJmYWxzZSIvPgogIDxjaGFtcCBpZD0ibHI2IiBsaWJlbGxlPSJNb250YW50IEhUIiBlZGl0YWJs\nZT0idHJ1ZSIgc2VsZWN0aW9ubmU9InRydWUiIGlkZW50aWZpYW50PSJmYWxzZSIvPgogIDxjaGFt\ncCBpZD0ibHI3IiBsaWJlbGxlPSJNb250YW50IFRWQSIgZWRpdGFibGU9InRydWUiIHNlbGVjdGlv\nbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0iZmFsc2UiLz4KICA8Y2hhbXAgaWQ9ImxyOCIgbGliZWxs\nZT0iTW9udGFudCBUVEMiIGVkaXRhYmxlPSJ0cnVlIiBzZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRp\nZmlhbnQ9ImZhbHNlIi8+PC9lbGVtZW50Pgo8L2V4cG9ydD4K\n</ConfigModel>", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"PES_ReleveCarteAchat\" etatID=\"PES_CarteAchat\" owner=\"Xemelios\" code=\"Carte achat - Tous champs\" libelle=\"Carte achat (cofnig. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJD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\nPC9lbGVtZW50Pgo8L2V4cG9ydD4K\n</ConfigModel>", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"DOC_FactureRecette\" etatID=\"PESFacture\" owner=\"Xemelios\" code=\"Facture Rec. - Tous champ\" libelle=\"Facture Rec. (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJG\nYWN0dXJlIFJlYy4gLSBUb3VzIGNoYW1wcyIgbGliZWxsZT0iRmFjdHVyZSBSZWMuIChjb25maWcu\nIHBhciBk6WZhdXQpIiBjb2RlPSIiPgogPGVsZW1lbnQgaWQ9IkZhY3R1cmVJbmRpdiIgbGliZWxs\nZT0iRmFjdHVyZSBkZSByZWNldHRlIj4KICA8Y2hhbXAgaWQ9ImxyMSIgbGliZWxsZT0iRGF0ZSBk\nJ+ltaXNzaW9uIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0aW9ubmU9InRydWUiIGlkZW50aWZpYW50\nPSJmYWxzZSIvPgogIDxjaGFtcCBpZD0ibHIxMSIgbGliZWxsZT0iSUQgROliaXRldXIiIGVkaXRh\nYmxlPSJ0cnVlIiBzZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9ImZhbHNlIi8+CiAgPGNo\nYW1wIGlkPSJscjEyIiBsaWJlbGxlPSJOb20gROliaXRldXIiIGVkaXRhYmxlPSJ0cnVlIiBzZWxl\nY3Rpb25uZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9ImZhbHNlIi8+CiAgPGNoYW1wIGlkPSJscjEzIiBs\naWJlbGxlPSJQculub20gROliaXRldXIiIGVkaXRhYmxlPSJ0cnVlIiBzZWxlY3Rpb25uZT0idHJ1\nZSIgaWRlbnRpZmlhbnQ9ImZhbHNlIi8+CiAgPGNoYW1wIGlkPSJscjE0IiBsaWJlbGxlPSJBZHJl\nc3NlIETpYml0ZXVyIC0gbG9jYWxpc2F0aW9uIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0aW9ubmU9\nInRydWUiIGlkZW50aWZpYW50PSJmYWxzZSIvPgogIDxjaGFtcCBpZD0ibHIxNSIgbGliZWxsZT0i\nQWRyZXNzZSBE6WJpdGV1ciAtIHByaW5jaXBhbGUiIGVkaXRhYmxlPSJ0cnVlIiBzZWxlY3Rpb25u\nZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9ImZhbHNlIi8+CiAgPGNoYW1wIGlkPSJscjE2IiBsaWJlbGxl\nPSJBZHJlc3NlIETpYml0ZXVyIC0gY29tcGzpbWVudCIgZWRpdGFibGU9InRydWUiIHNlbGVjdGlv\nbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0iZmFsc2UiLz4KICA8Y2hhbXAgaWQ9ImxyMTciIGxpYmVs\nbGU9IkNQIETpYml0ZXVyIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0aW9ubmU9InRydWUiIGlkZW50\naWZpYW50PSJmYWxzZSIvPgogIDxjaGFtcCBpZD0ibHIxOCIgbGliZWxsZT0iVmlsbGUgROliaXRl\ndXIiIGVkaXRhYmxlPSJ0cnVlIiBzZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9ImZhbHNl\nIi8+CiAgPGNoYW1wIGlkPSJscjYiIGxpYmVsbGU9Ik1vbnRhbnQgSFQiIGVkaXRhYmxlPSJ0cnVl\nIiBzZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9ImZhbHNlIi8+CiAgPGNoYW1wIGlkPSJs\ncjciIGxpYmVsbGU9Ik1vbnRhbnQgVFZBIiBlZGl0YWJsZT0idHJ1ZSIgc2VsZWN0aW9ubmU9InRy\ndWUiIGlkZW50aWZpYW50PSJmYWxzZSIvPgogIDxjaGFtcCBpZD0ibHI4IiBsaWJlbGxlPSJNb250\nYW50IFRUQyIgZWRpdGFibGU9InRydWUiIHNlbGVjdGlvbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0i\nZmFsc2UiLz48L2VsZW1lbnQ+CjwvZXhwb3J0Pgo=\n</ConfigModel>", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"DOC_Quittancement\" etatID=\"PESFacture\" owner=\"Xemelios\" code=\"Quittance - Tous champs\" libelle=\"Quittance (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJR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\nPC9lbGVtZW50Pgo8L2V4cG9ydD4K\n</ConfigModel>", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"PES_Aller\" etatID=\"PES_DepenseAller\" owner=\"Xemelios\" code=\"PES D\u00e9pense - Tous champs\" libelle=\"PES D\u00e9pense (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJQ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\nZW50PgogPC9lbGVtZW50Pgo8L2V4cG9ydD4K\n</ConfigModel>", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"PES_Aller\" etatID=\"PES_RecetteAller\" owner=\"Xemelios\" code=\"PES Recette - Tous champs\" libelle=\"PES Recette (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJQ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\nL2V4cG9ydD4K\n</ConfigModel>", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"PES_Aller\" etatID=\"PES_PJ\" owner=\"Xemelios\" code=\"PES PJ - Tous champs\" libelle=\"PES PJ (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJQ\nRVMgUEogLSBUb3VzIGNoYW1wcyIgbGliZWxsZT0iUEVTIFBKIChjb25maWcuIHBhciBk6WZhdXQp\nIiBjb2RlPSIiPgogPGVsZW1lbnQgaWQ9IlBKIiBsaWJlbGxlPSJQaehjZXMgSnVzdGlmaWNhdGl2\nZXMiPgogIDxjaGFtcCBpZD0iZTdscjEiIGxpYmVsbGU9IlR5cGVQSiIgZWRpdGFibGU9InRydWUi\nIHNlbGVjdGlvbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0iZmFsc2UiLz4KICA8Y2hhbXAgaWQ9ImU3\nbHIyIiBsaWJlbGxlPSJOb21QSiIgZWRpdGFibGU9InRydWUiIHNlbGVjdGlvbm5lPSJ0cnVlIiBp\nZGVudGlmaWFudD0iZmFsc2UiLz4KICA8Y2hhbXAgaWQ9ImU3bHIzIiBsaWJlbGxlPSJEZXNjcmlw\ndGlvbiIgZWRpdGFibGU9InRydWUiIHNlbGVjdGlvbm5lPSJ0cnVlIiBpZGVudGlmaWFudD0iZmFs\nc2UiLz4KICA8Y2hhbXAgaWQ9ImU3bHI0IiBsaWJlbGxlPSJJZFVuaXF1ZSIgZWRpdGFibGU9ImZh\nbHNlIiBzZWxlY3Rpb25uZT0idHJ1ZSIgaWRlbnRpZmlhbnQ9InRydWUiLz4KICA8Y2hhbXAgaWQ9\nImU3bHI1IiBsaWJlbGxlPSJTZXJ2ZXVySWQiIGVkaXRhYmxlPSJ0cnVlIiBzZWxlY3Rpb25uZT0i\ndHJ1ZSIgaWRlbnRpZmlhbnQ9ImZhbHNlIi8+PC9lbGVtZW50Pgo8L2V4cG9ydD4K\n</ConfigModel>", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ConfigModel docID=\"erar\" etatID=\"LigneERAR\" owner=\"Xemelios\" code=\"ERAR - Tous champs\" libelle=\"ERAR (config. par d\u00e9faut)\">PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pgo8ZXhwb3J0IGlkPSJF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\nZGVudGlmaWFudD0iZmFsc2UiLz48L2VsZW1lbnQ+CjwvZXhwb3J0Pgo=\n</ConfigModel>"};

    public void run() throws Exception {
        LocalUser user = new LocalUser();
        try {
            ConfigParser parser = new ConfigParser();
            DataImpl impl = DataLayerManager.getImplementation();
            for (String s : EXPORT_CONFIGS) {
                parser.parse((InputStream)new ByteArrayInputStream(s.getBytes("ISO-8859-1")));
                ConfigModel cm = (ConfigModel)parser.getMarshallable();
                Vector existing = impl.getListeConfigsExport(cm.getDocID(), cm.getEtatID(), (XemeliosUser)user);
                boolean exists = false;
                for (ConfigModel ecm : existing) {
                    if (!ecm.getCode().equals(cm.getCode())) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                impl.insertConfigExport(cm, (XemeliosUser)user);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.setPreviousConfigurator(new Core3316());
    }

    public static class LocalUser
    implements XemeliosUser {
        public String getId() {
            return "local";
        }

        public String getDisplayName() {
            return this.getId();
        }

        public boolean hasRole(String arg0) {
            return true;
        }

        public boolean hasDocument(String arg0) {
            return true;
        }

        public boolean hasCollectivite(String arg0, DocumentModel dm) {
            return true;
        }
    }
}

