/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.tech;

import fr.gouv.finances.cp.xemelios.controls.models.ControlModelTech;
import fr.gouv.finances.cp.xemelios.controls.models.ParamModelTech;
import fr.gouv.finances.dgfip.xemelios.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class TECH02 {
    public static final transient String ENCODING_PARAM_NAME = "encoding";
    private String inputFileEncoding = "";
    private static final Logger logger = Logger.getLogger(TECH02.class);
    private ArrayList<String> acceptableEncodings = new ArrayList();
    private String validEncodings;

    public boolean encodingValid(ControlModelTech cmt, File fichierAController) {
        StringBuilder sb = new StringBuilder();
        for (ParamModelTech pmt : cmt.getParams()) {
            if (!ENCODING_PARAM_NAME.equals(pmt.getName())) continue;
            try {
                Charset cs = Charset.forName(pmt.getValue());
                String encodingName = cs.name();
                this.acceptableEncodings.add(encodingName);
                sb.append(encodingName).append(',');
            }
            catch (Exception ex) {
                logger.error((Object)("while initializing charset: " + pmt.getValue()), (Throwable)ex);
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.validEncodings = sb.toString().replaceAll(",", ", ");
        boolean encodingValid = false;
        try {
            this.inputFileEncoding = FileUtils.getFileEncoding((File)fichierAController);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            Charset cs = Charset.forName(this.inputFileEncoding);
            this.inputFileEncoding = cs.name();
            encodingValid = this.acceptableEncodings.contains(this.inputFileEncoding);
        }
        catch (Exception ex) {
            encodingValid = false;
        }
        return encodingValid;
    }

    public String getInputEncoding() {
        return this.inputFileEncoding;
    }

    public String getValidEncodings() {
        return this.validEncodings;
    }
}

