/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.processors;

import fr.gouv.finances.cp.xemelios.controls.models.ParamModel;
import fr.gouv.finances.cp.xemelios.controls.processors.AbstractProcessor;
import fr.gouv.finances.cp.xemelios.controls.processors.Processor;
import fr.gouv.finances.cp.xemelios.controls.processors.impl.IdGenerator;
import fr.gouv.finances.dgfip.utils.xml.XmlAttributesImpl;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdGeneratorProcessor
extends AbstractProcessor {
    private static final Logger logger = Logger.getLogger(IdGeneratorProcessor.class);
    private IdGenerator idGenerator = null;

    @Override
    public void setParameters(List<ParamModel> params) {
        super.setParameters(params);
        try {
            Class<?> clazz = Class.forName((String)this.getParamByName("generator").getValue());
            this.idGenerator = (IdGenerator)clazz.newInstance();
        }
        catch (Throwable t) {
            logger.fatal((Object)"instanciating IdGenerator", t);
        }
    }

    @Override
    public void process(Processor.EVENT evt, String uri, String localName, String qName, XmlAttributesImpl atts) {
        String attributeName = this.getParamByName("generated.attribute").getValue().toString();
        String targetUri = null;
        String targetLocalName = null;
        String targetQName = null;
        int pos = -1;
        pos = attributeName.indexOf(":");
        if (pos >= 0) {
            String prefix = attributeName.substring(0, pos);
            targetLocalName = attributeName.substring(pos + 1);
            targetUri = this.getNamespaceContext().getNamespaceURI(prefix);
            targetQName = this.getNamespaceContext().getPrefix(targetUri) + ":" + targetLocalName;
        } else {
            targetLocalName = attributeName;
        }
        atts.addAttribute(targetUri, targetLocalName, targetQName, "CDATA", this.idGenerator.generateId());
    }
}

