/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.editors;

import fr.gouv.finances.cp.xemelios.controls.editors.Controller;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.Hashtable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.TransformerFactoryImpl;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerTester {
    protected static Hashtable<String, Object> getControlParametersPES() {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        ret.put("nomencl", "M14");
        ret.put("typnomencl", "Nature");
        ret.put("votop", Boolean.FALSE);
        ret.put("suivdgp", Boolean.TRUE);
        ret.put("dureedgp", new Integer(45));
        ret.put("coltva", Boolean.TRUE);
        ret.put("servTVA", new String[0]);
        ret.put("compteTVA", new String[0]);
        ret.put("tauxTVA", new String[]{"2.1", "5.5", "19.6"});
        ret.put("seuilMax", new BigDecimal(90000));
        ret.put("seuilEmission", new BigDecimal(10));
        ret.put("codProd", new String[]{"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "100", "101", "102", "103", "104", "105", "106", "107", "248", "300", "302", "305", "306", "307", "308"});
        return ret;
    }

    protected static Hashtable<String, Object> getControlParametersEtatFrais() {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        return ret;
    }

    static Hashtable<String, Document> testPesAller() throws Exception {
        File fileToRead = new File("P:/laurent.meckert/FichiersPES/PES_DEP_exemple_1000.xml");
        Controller controller = new Controller("PES_Aller");
        Hashtable<String, Document> result = controller.controle(fileToRead, ControllerTester.getControlParametersPES());
        return result;
    }

    static Hashtable<String, Document> testEtatFrais() throws Exception {
        File fileToRead = new File("c:/LME/Xemelios/UblInvoice/os-UBL-2.0/fenokok");
        Controller controller = new Controller("DocEtatsFrais");
        Hashtable<String, Document> result = controller.controle(fileToRead, ControllerTester.getControlParametersEtatFrais());
        return result;
    }

    public static void main(String[] args) {
        try {
            Hashtable<String, Document> result = ControllerTester.testEtatFrais();
            for (String k : result.keySet()) {
                Document doc = result.get(k);
                try {
                    FileOutputStream f = new FileOutputStream(k + ".xml");
                    TransformerFactory tf = TransformerFactoryImpl.newInstance();
                    Transformer t = tf.newTransformer();
                    t.setOutputProperty("encoding", "ISO-8859-1");
                    t.setOutputProperty("method", "xml");
                    t.setOutputProperty("indent", "yes");
                    t.transform(new DOMSource(doc), new StreamResult(f));
                    f.flush();
                    f.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (Error e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

