/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.comm;

import fr.gouv.finances.cp.xemelios.controls.AbstractControlContentHandler;
import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.utils.XmlUtils;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COLLBUDG
extends AbstractUnitControl {
    public static final transient String CTRL_ID = "COLLBUDG";
    private static Logger logger = Logger.getLogger(COLLBUDG.class);
    private String coll_path = null;
    private String budg_path = null;
    private String coll_lib = null;
    private String budg_lib = null;
    private AbstractControlContentHandler cch = null;
    private Stack<StringBuilder> charactersStack = new Stack();
    private Stack<QName> tagStack = new Stack();

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        String tagName = XmlUtils.getShortTagName((String)uri, (String)localName, (String)qName);
        QName _qName = XmlUtils.getQName((String)uri, (String)localName, (String)qName);
        this.tagStack.push(_qName);
        for (int i = 0; i < atts.getLength(); ++i) {
            String attUri = atts.getURI(i);
            String prefix = null;
            if (attUri != null) {
                prefix = this.getDocumentModel().getNamespaces().getPrefix(attUri);
            }
            String attQName = (prefix != null ? prefix + ":" : "") + atts.getLocalName(i);
            String path = "/".concat(xpath).concat("@").concat(attQName);
            String value = atts.getValue(i);
            this.checkPath(path, value);
        }
        this.charactersStack.push(new StringBuilder());
    }

    public void checkPath(String path, String value) {
        Pair p;
        if (this.coll_path.equals(path)) {
            p = this.cch.getCollectivite();
            if (p == null) {
                p = new Pair();
            }
            p.key = value;
            this.cch.setCollectivite(p);
        }
        if (this.coll_lib.equals(path)) {
            p = this.cch.getCollectivite();
            if (p == null) {
                p = new Pair();
            }
            p.libelle = value;
            this.cch.setCollectivite(p);
        }
        if (this.budg_path.equals(path)) {
            p = this.cch.getBudget();
            if (p == null) {
                p = new Pair();
            }
            p.key = value;
            this.cch.setBudget(p);
        }
        if (this.budg_lib.equals(path)) {
            p = this.cch.getBudget();
            if (p == null) {
                p = new Pair();
            }
            p.libelle = value;
            this.cch.setBudget(p);
        }
    }

    @Override
    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) {
        String path = XmlUtils.getPath(this.tagStack, (NamespaceContext)this.getDocumentModel().getNamespaces());
        String innerData = this.charactersStack.pop().toString();
        this.checkPath(path, innerData);
        this.tagStack.pop();
        return null;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length, String xpath) {
        String s = new String(ch, start, length).trim();
        if (s.length() > 0) {
            this.charactersStack.peek().append(new String(ch, start, length));
        }
        this.checkPath(xpath.concat("/text()"), new String(ch, start, length));
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    @Override
    public void endPrefixMapping(String prefix, String xpath) {
    }

    @Override
    public void processingInstruction(String target, String data, String xpath) {
    }

    @Override
    public void skippedEntity(String name, String xpath) {
    }

    @Override
    public void setParameters(Hashtable<String, Object> params) {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    public String getColl_path() {
        return this.coll_path;
    }

    public void setColl_path(String coll_path) {
        this.coll_path = coll_path;
    }

    public AbstractControlContentHandler getCch() {
        return this.cch;
    }

    public void setCch(AbstractControlContentHandler cch) {
        this.cch = cch;
    }

    public String getBudg_path() {
        return this.budg_path;
    }

    public void setBudg_path(String budg_path) {
        this.budg_path = budg_path;
    }

    public String getBudg_lib() {
        return this.budg_lib;
    }

    public void setBudg_lib(String budg_lib) {
        this.budg_lib = budg_lib;
    }

    public String getColl_lib() {
        return this.coll_lib;
    }

    public void setColl_lib(String coll_lib) {
        this.coll_lib = coll_lib;
    }
}

