/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls;

import fr.gouv.finances.cp.xemelios.controls.AbstractControlContentHandler;
import fr.gouv.finances.cp.xemelios.controls.ControlProgressListener;
import fr.gouv.finances.cp.xemelios.controls.models.DocumentControlModel;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.auth.UnauthorizedException;
import fr.gouv.finances.dgfip.xemelios.common.ToolException;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.data.DataAccessException;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultControlContentHandler
extends AbstractControlContentHandler {
    private static final Logger logger = Logger.getLogger(DefaultControlContentHandler.class);

    public DefaultControlContentHandler(DocumentModel dm, DocumentControlModel docCtrlMod, Hashtable<String, Object> parameters, MainWindow frame, String file, ControlProgressListener cpl) {
        super(dm, docCtrlMod, parameters, frame, file, cpl);
    }

    @Override
    public Pair getCollectivite(DocumentModel dm, String fileName) throws ToolException {
        Pair ret = null;
        if (ret == null) {
            AbstractControlContentHandler.QueryCollectivite qc = new AbstractControlContentHandler.QueryCollectivite(fileName);
            qc.setDefaultCollectivite(this.collectivite);
            if (SwingUtilities.isEventDispatchThread()) {
                qc.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(qc);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            ret = qc.getRet();
            if (ret == null) {
                throw new ToolException("Action interrompue", 1);
            }
        }
        return ret;
    }

    @Override
    public Pair getBudget(DocumentModel dm, Pair collectivite, String fileName) throws ToolException, UnauthorizedException {
        Pair ret = null;
        if (ret == null) {
            TreeSet<Pair> existing = new TreeSet<Pair>();
            try {
                existing.addAll(DataLayerManager.getImplementation().getBudgets(dm, collectivite, this.owner.getConnectedUser()));
            }
            catch (DataConfigurationException e) {
                logger.error((Object)"in getBudget", (Throwable)e);
            }
            catch (DataAccessException e) {
                logger.error((Object)"in getBudget", (Throwable)e);
            }
            Vector budgetsDm = dm.getDefaultBudgets();
            existing.addAll(budgetsDm);
            if (this.budget != null && (this.budget.libelle == null || this.budget.libelle.length() == 0) && existing.contains(this.budget)) {
                for (Pair p : existing) {
                    if (!p.key.equals(this.budget.key)) continue;
                    return p;
                }
            }
            AbstractControlContentHandler.QueryBudget qb = new AbstractControlContentHandler.QueryBudget(fileName, existing, collectivite.libelle);
            if (SwingUtilities.isEventDispatchThread()) {
                qb.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(qb);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            ret = qb.getRet();
            if (ret == null) {
                throw new ToolException("Action interrompue", 1);
            }
        }
        return ret;
    }
}

