/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls;

import fr.gouv.finances.cp.utils.ui.DlgGetPair;
import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.ControlProgressListener;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.SaxXmlWriter;
import fr.gouv.finances.cp.xemelios.controls.comm.COLLBUDG;
import fr.gouv.finances.cp.xemelios.controls.models.AddOnModel;
import fr.gouv.finances.cp.xemelios.controls.models.ControlModel;
import fr.gouv.finances.cp.xemelios.controls.models.DocumentControlModel;
import fr.gouv.finances.cp.xemelios.controls.processors.Processor;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.utils.xml.XmlAttributesImpl;
import fr.gouv.finances.dgfip.xemelios.auth.UnauthorizedException;
import fr.gouv.finances.dgfip.xemelios.common.ToolException;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractControlContentHandler
extends DefaultHandler
implements ContentHandler {
    private static final Logger logger = Logger.getLogger(AbstractControlContentHandler.class);
    protected Pair collectivite;
    protected Pair budget;
    public int MAX_ANOS = 300;
    private ArrayList<AbstractUnitControl> controlsToCall;
    private DocumentControlModel docControlMod;
    private DocumentModel docModel;
    private Hashtable<String, Object> hParams;
    private Stack<String> stack;
    protected MainWindow owner;
    private Vector<Anomalie> anos = new Vector();
    private Vector<Anomalie> vTotalAnomalies;
    private Vector<ControlModel> controlsModel;
    private SaxXmlWriter saxXmlWriter;
    private NamespaceContext nsCtx;
    private boolean startEtatPassed = false;
    public boolean importInterupted = false;
    private String fileName;
    private ControlProgressListener cpl;
    ArrayList<AddOnModel> addOns = null;

    public void setControlProgressListener(ControlProgressListener cpl) {
        this.cpl = cpl;
    }

    public AbstractControlContentHandler(DocumentModel dm, DocumentControlModel docCtrlMod, Hashtable<String, Object> parameters, MainWindow frame, String file, ControlProgressListener cpl) {
        this.setControlProgressListener(cpl);
        this.docModel = dm;
        this.docControlMod = docCtrlMod;
        this.owner = frame;
        this.fileName = file;
        this.nsCtx = dm.getNamespaces();
        this.vTotalAnomalies = new Vector();
        this.stack = new Stack();
        this.controlsToCall = new ArrayList();
        this.hParams = parameters;
        if (docCtrlMod.getEngine() != null) {
            this.addOns = docCtrlMod.getEngine().getAddOns();
        }
        if (this.addOns == null) {
            this.addOns = new ArrayList();
        }
        for (AddOnModel addOn : this.addOns) {
            addOn.getProcessor().setNamespaceContext(this.nsCtx);
        }
        try {
            COLLBUDG cbc = new COLLBUDG();
            cbc.setDocumentModel(this.docControlMod);
            cbc.setCch(this);
            cbc.setColl_path(docCtrlMod.getCollectivitePath().getCodePath().getPath());
            cbc.setColl_lib(docCtrlMod.getCollectivitePath().getLibellePath().getPath());
            cbc.setBudg_path(docCtrlMod.getBudgetPath().getCodePath().getPath());
            cbc.setBudg_lib(docCtrlMod.getBudgetPath().getLibellePath().getPath());
            this.controlsToCall.add(cbc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (ControlModel ctrlm : docCtrlMod.getControls()) {
            try {
                Object o = new Object();
                if (!ctrlm.id.startsWith("TECH")) {
                    o = Class.forName(ctrlm.getClasse()).newInstance();
                }
                if (!(o instanceof AbstractUnitControl)) continue;
                AbstractUnitControl auc = (AbstractUnitControl)o;
                auc.setParameters(this.getParameters());
                auc.setDocumentModel(this.docControlMod);
                auc.setFileName(this.fileName);
                this.controlsToCall.add(auc);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void setFileName(String fileName) {
        for (AbstractUnitControl auc : this.controlsToCall) {
            auc.setFileName(fileName);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        for (AddOnModel addOn : this.addOns) {
            if (!addOn.isConcernedBy(Processor.EVENT.START_DOCUMENT, null, null, null)) continue;
            addOn.process(Processor.EVENT.START_DOCUMENT);
        }
        for (AbstractUnitControl auc : this.controlsToCall) {
            try {
                auc.startDocument();
            }
            catch (SAXException saxEx) {
                logger.debug((Object)"in startDocument cch !!!", (Throwable)saxEx);
            }
        }
        this.saxXmlWriter.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.stack.push(localName);
        String xpath = this.getXpathExpression();
        XmlAttributesImpl attrs = new XmlAttributesImpl();
        for (int i = 0; i < atts.getLength(); ++i) {
            attrs.addAttribute(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getType(i), atts.getValue(i));
        }
        if (this.stack.size() == 1) {
            this.startEtatPassed = true;
            this.saxXmlWriter.startPrefixMapping(this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally"), "http://projets.admisource.gouv.fr/xemelios/namespaces#anomally");
        }
        attrs.addAttribute("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally", "node-id", (this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally") != null ? this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally") + ":" : "") + "node-id", "CDATA", IdGenerator.nextId());
        for (AddOnModel addOn : this.addOns) {
            if (!addOn.isConcernedBy(Processor.EVENT.START_ELEMENT, uri, localName, qName)) continue;
            addOn.process(Processor.EVENT.START_ELEMENT, uri, localName, qName, attrs);
        }
        for (AbstractUnitControl auc : this.controlsToCall) {
            auc.startElement(uri, localName, qName, (Attributes)attrs, this.getXpathExpression());
        }
        this.saxXmlWriter.startElement(uri, localName, qName, (Attributes)attrs);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Vector<Anomalie> vAno = new Vector<Anomalie>();
        for (AbstractUnitControl auc : this.controlsToCall) {
            try {
                this.anos = auc.endElement(uri, localName, qName, this.getXpathExpression());
                if (this.anos == null || this.anos.isEmpty() || this.vTotalAnomalies.size() > this.MAX_ANOS) continue;
                this.vTotalAnomalies.addAll(this.anos);
                vAno.addAll(this.anos);
            }
            catch (SAXException saxEx) {
                logger.debug((Object)"in endElement!!!", (Throwable)saxEx);
            }
        }
        if (!vAno.isEmpty()) {
            for (Anomalie ano : vAno) {
                this.saxXmlWriter.writeAnomally(ano);
            }
        }
        if (this.stack.size() == 1) {
            this.saxXmlWriter.endPrefixMapping(this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally"));
        }
        this.saxXmlWriter.endElement(uri, localName, qName);
        this.stack.pop();
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            if (this.collectivite == null || this.collectivite.key == null || this.collectivite.libelle == null) {
                try {
                    this.collectivite = this.getCollectivite(this.docModel, this.fileName);
                    if (!this.owner.getConnectedUser().hasCollectivite(this.collectivite.key, this.docModel)) {
                        throw new UnauthorizedException("Voux n'\u00eates pas autoris\u00e9 \u00e0 contr\u00f4ler des fichier de cette collectivite" + this.collectivite.libelle != null ? " (" + this.collectivite.libelle + ")" : "");
                    }
                }
                catch (ToolException e) {
                    e.printStackTrace();
                }
            }
            if (this.budget == null || this.budget.key == null || this.budget.libelle == null || this.budget.libelle.equals("")) {
                try {
                    this.budget = this.getBudget(this.docModel, this.collectivite, this.fileName);
                }
                catch (ToolException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (UnauthorizedException ex) {
            throw new SAXException((Exception)((Object)ex));
        }
        this.saxXmlWriter.endDocument();
    }

    private Hashtable<String, Object> getParameters() {
        return this.hParams;
    }

    public void setParameters(Hashtable<String, Object> ho) {
        this.hParams = ho;
    }

    private String getXpathExpression() {
        StringBuffer sb = new StringBuffer();
        for (String s : this.stack) {
            sb.append(s + "/");
        }
        return sb.toString();
    }

    public void setControlsModel(Vector<ControlModel> cm) {
        this.controlsModel = cm;
    }

    public void setSaxWriter(SaxXmlWriter sxw) {
        this.saxXmlWriter = sxw;
    }

    public Vector<Anomalie> getVTotalAnomalies() {
        return this.vTotalAnomalies;
    }

    public abstract Pair getCollectivite(DocumentModel var1, String var2) throws ToolException;

    public abstract Pair getBudget(DocumentModel var1, Pair var2, String var3) throws ToolException, UnauthorizedException;

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        for (AbstractUnitControl auc : this.controlsToCall) {
            auc.startPrefixMapping(prefix, uri, this.getXpathExpression());
        }
        this.saxXmlWriter.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
        for (AbstractUnitControl auc : this.controlsToCall) {
            auc.endPrefixMapping(prefix, this.getXpathExpression());
        }
        this.saxXmlWriter.endPrefixMapping(prefix);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        for (AbstractUnitControl auc : this.controlsToCall) {
            try {
                auc.characters(ch, start, length, this.getXpathExpression());
            }
            catch (SAXException saxEx) {
                logger.debug((Object)"in characters!!!", (Throwable)saxEx);
            }
        }
        this.saxXmlWriter.characters(ch, start, length);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.saxXmlWriter.setDocumentLocator(locator);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.saxXmlWriter.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) {
        try {
            this.saxXmlWriter.processingInstruction(target, data);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.saxXmlWriter.skippedEntity(name);
    }

    public void setNamespaceContext(NamespaceContext nsCtx) {
        this.nsCtx = nsCtx;
    }

    public Pair getBudget() {
        return this.budget;
    }

    public void setBudget(Pair budget) {
        this.budget = budget;
    }

    public Pair getCollectivite() {
        return this.collectivite;
    }

    public void setCollectivite(Pair collectivite) {
        this.collectivite = collectivite;
        logger.debug((Object)("setting collectivite: " + collectivite));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class QueryBudget
    implements Runnable {
        private String fileName;
        private TreeSet<Pair> existing;
        private Pair ret;
        private String collectivite = null;

        public QueryBudget(String fileName, TreeSet<Pair> existing, String collectivite) {
            this.fileName = fileName;
            this.existing = existing;
            this.collectivite = collectivite;
        }

        @Override
        public void run() {
            DlgGetPair dlg = null;
            dlg = new DlgGetPair(AbstractControlContentHandler.this.owner, "Sur quel budget porte ce document : " + this.fileName + " ?", this.existing, this.collectivite, AbstractControlContentHandler.this.budget);
            if (dlg.run()) {
                this.ret = new Pair(dlg.getCode(), dlg.getLibelle());
            } else if (!AbstractControlContentHandler.this.importInterupted) {
                AbstractControlContentHandler.this.importInterupted = true;
                AbstractControlContentHandler.this.cpl.notifyImportInterrupted(false);
            }
            logger.debug((Object)"fin de QueryBudget.run()");
        }

        public Pair getRet() {
            logger.debug((Object)"QueryBudget.getRet()");
            return this.ret;
        }
    }

    protected class QueryCollectivite
    implements Runnable {
        private Pair ret;
        private String fileName;
        private Pair defaultCollectivite = null;

        public Pair getDefaultCollectivite() {
            return this.defaultCollectivite;
        }

        public void setDefaultCollectivite(Pair defaultCollectivite) {
            this.defaultCollectivite = defaultCollectivite;
        }

        public QueryCollectivite(String fileName) {
            this.fileName = fileName;
        }

        public void run() {
            DlgGetPair dlg = new DlgGetPair(AbstractControlContentHandler.this.owner, "Sur quelle collectivit\u00e9 porte ce document : " + this.fileName + " ?", null, null, AbstractControlContentHandler.this.collectivite);
            if (dlg.run()) {
                this.ret = new Pair(dlg.getCode(), dlg.getLibelle());
            } else {
                AbstractControlContentHandler.this.importInterupted = true;
                AbstractControlContentHandler.this.cpl.notifyImportInterrupted(true);
            }
        }

        public Pair getRet() {
            return this.ret;
        }
    }
}

