/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils.ui;

import fr.gouv.finances.cp.utils.StringUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;

public class IhmFactory {
    private Hashtable<String, Font> fonts = new Hashtable();
    private Hashtable<String, Color> colors = new Hashtable();

    private IhmFactory() {
    }

    public static IhmFactory newInstance() {
        return new IhmFactory();
    }

    public JLabel newLabel(String text, String txtClass) {
        Color col;
        String fontSpec = null;
        String fontColor = null;
        String backColor = null;
        if (txtClass != null) {
            StringTokenizer st = new StringTokenizer(txtClass, ":");
            fontSpec = st.nextToken();
            if (st.hasMoreTokens()) {
                fontColor = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                backColor = st.nextToken();
            }
        }
        String fontName = "dialog-" + (fontSpec != null ? fontSpec.toLowerCase() : "");
        JLabel ret = new JLabel(text);
        if (txtClass == null) {
            return ret;
        }
        Font font = this.getFont(ret.getFont(), fontName);
        ret.setFont(font);
        if (fontColor != null && (col = this.decodeColor(fontColor)) != null) {
            ret.setForeground(col);
        }
        if (backColor != null && (col = this.decodeColor(backColor)) != null) {
            ret.setBackground(col);
        }
        return ret;
    }

    public JLabel newLabel(String text) {
        return this.newLabel(text, null);
    }

    protected Font getFont(Font font, String c) {
        Font ret = this.fonts.get(c);
        if (ret == null) {
            ret = font;
            if (c.indexOf("normal") >= 0) {
                ret = ret.deriveFont(0);
            }
            if (c.indexOf("italic") >= 0) {
                ret = ret.deriveFont(2);
            }
            if (c.indexOf("bold") >= 0) {
                ret = ret.deriveFont(1);
            }
            this.fonts.put(c, ret);
        }
        return ret;
    }

    public Color decodeColor(String col) {
        String c = col.toLowerCase();
        Color ret = this.colors.get(c);
        if (ret == null) {
            if ("black".equals(col)) {
                ret = Color.BLACK;
            } else if ("blue".equals(col)) {
                ret = Color.BLUE;
            } else if ("cyan".equals(col)) {
                ret = Color.CYAN;
            } else if ("darkgray".equals(col)) {
                ret = Color.DARK_GRAY;
            } else if ("gray".equals(col)) {
                ret = Color.GRAY;
            } else if ("green".equals(col)) {
                ret = Color.GREEN;
            } else if ("lightgray".equals(col)) {
                ret = Color.LIGHT_GRAY;
            } else if ("magenta".equals(col)) {
                ret = Color.MAGENTA;
            } else if ("orange".equals(col)) {
                ret = Color.ORANGE;
            } else if ("pink".equals(col)) {
                ret = Color.PINK;
            } else if ("red".equals(col)) {
                ret = Color.RED;
            } else if ("white".equals(col)) {
                ret = Color.WHITE;
            } else if ("yellow".equals(col)) {
                ret = Color.YELLOW;
            } else if (col.startsWith("#") && col.length() == 7) {
                String s = col.toUpperCase();
                int r = Integer.parseInt(s.substring(1, 2));
                int g = Integer.parseInt(s.substring(3, 4));
                int b = Integer.parseInt(s.substring(5, 6));
                ret = new Color(r, g, b);
            }
            if (ret != null) {
                this.colors.put(col, ret);
            }
        }
        return ret;
    }

    public JButton newButton(String text) {
        JButton ret = new JButton(text);
        this.addInfoMgr(ret);
        return ret;
    }

    public JButton newButton(Icon icon) {
        JButton ret = new JButton(icon);
        this.addInfoMgr(ret);
        return ret;
    }

    public JButton newButton(String text, Icon icon) {
        JButton ret = new JButton(text, icon);
        this.addInfoMgr(ret);
        return ret;
    }

    public JButton newButton(Action action) {
        JButton ret = new JButton(action);
        this.addInfoMgr(ret);
        return ret;
    }

    protected void addInfoMgr(JButton button) {
        button.setBorderPainted(false);
        button.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                ((JButton)e.getSource()).setBorderPainted(true);
                ((JButton)e.getSource()).setOpaque(true);
            }

            public void mouseExited(MouseEvent e) {
                ((JButton)e.getSource()).setBorderPainted(false);
                ((JButton)e.getSource()).setOpaque(false);
            }
        });
    }

    public static ImageIcon getIconFromResource(String resName) {
        Iterator<ImageReader> it = ImageIO.getImageReadersBySuffix(StringUtilities.getFileNameSuffix(resName));
        if (it.hasNext()) {
            ImageReader ir = it.next();
            InputStream is = IhmFactory.class.getClassLoader().getResourceAsStream(resName);
            try {
                MemoryCacheImageInputStream fiis = new MemoryCacheImageInputStream(is);
                ir.setInput(fiis);
                BufferedImage bi = ir.read(0);
                fiis.close();
                ImageIcon icon = new ImageIcon(bi);
                return icon;
            }
            catch (IOException ioEx) {
                return null;
            }
        }
        return null;
    }
}

