/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.quittancement;

import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.importers.docetatProvider.AbstractWriter;
import fr.gouv.finances.dgfip.xemelios.importers.docetatProvider.AttributesHolder;
import fr.gouv.finances.dgfip.xemelios.importers.docetatProvider.NamespaceHolder;
import fr.gouv.finances.dgfip.xemelios.importers.docetatProvider.NodesHolder;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class QuittancementWriter
extends AbstractWriter {
    private static final Logger logger = Logger.getLogger(QuittancementWriter.class);
    public static final transient String FACTURE_NS = "http://www.minefi.gouv.fr/cp/helios/pes_v2/facture";
    private boolean inNomenclature = false;
    private boolean writtingNomenclature = false;
    private Element nomenclatures = null;
    private Element currentElement = null;
    private Document doc = null;
    private boolean hasAlreadyWrittenHeader = false;

    public QuittancementWriter(DocumentModel dm, OutputStream out, String encoding, AttributesHolder attHolder, NodesHolder nodeHolder, NamespaceHolder ns) {
        super(dm, out, encoding, attHolder, nodeHolder, ns);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.hasAlreadyWrittenHeader) {
            this.hasAlreadyWrittenHeader = true;
            AttributesImpl attrs = new AttributesImpl();
            this.startElement(FACTURE_NS, "DOC_PES_Facture", "DOC_PES_Facture", attrs);
        }
        if (this.writtingNomenclature) {
            super.startElement(uri, localName, qName, atts);
        } else if ("Nomenclatures".equals(localName)) {
            this.inNomenclature = true;
            try {
                DocumentBuilderFactory domF = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = domF.newDocumentBuilder();
                this.doc = db.newDocument();
                this.currentElement = this.nomenclatures = this.doc.createElement("Nomenclatures");
            }
            catch (Exception ex) {
                logger.error(null, (Throwable)ex);
            }
        } else if (this.inNomenclature) {
            try {
                Element localNode = this.doc.createElement(localName);
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attName = atts.getLocalName(i);
                    Attr att = this.doc.createAttribute(attName == null ? atts.getQName(i) : attName);
                    att.setValue(atts.getValue(i));
                    localNode.setAttributeNode(att);
                }
                this.currentElement.appendChild(localNode);
                this.currentElement = localNode;
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        } else {
            super.startElement(uri, localName, qName, atts);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.writtingNomenclature) {
            if (this.inNomenclature) {
                if ("Nomenclatures".equals(localName)) {
                    this.inNomenclature = false;
                } else {
                    this.currentElement = (Element)this.currentElement.getParentNode();
                }
            } else {
                super.endElement(uri, localName, qName);
                if ("PESFacture".equals(localName) && this.nomenclatures != null) {
                    this.writtingNomenclature = true;
                    this.writeNode(this.nomenclatures);
                    this.writtingNomenclature = false;
                }
            }
        } else {
            super.endElement(uri, localName, qName);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.inNomenclature && !this.writtingNomenclature) {
            super.characters(ch, start, length);
        }
    }

    public void endDocument() throws SAXException {
        this.endElement(FACTURE_NS, "DOC_PES_Facture", "DOC_PES_Facture");
        super.endDocument();
    }
}

