/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.PatternMatcher;

public class PatternFilter
extends Filter
implements PatternMatcher {
    private ArrayList<Integer> toPrevious;
    protected Pattern pattern = null;

    public PatternFilter() {
        this(null, 0, 0);
    }

    public PatternFilter(String string, int n, int n2) {
        super(n2);
        this.setPattern(string, n);
    }

    protected void init() {
        this.toPrevious = new ArrayList();
    }

    public void setPattern(String string, int n) {
        if (string == null || string.length() == 0) {
            string = ".*";
        }
        this.setPattern(Pattern.compile(string, n));
    }

    public void setPattern(Pattern pattern) {
        if (pattern == null) {
            this.setPattern(null, 0);
        } else {
            this.pattern = pattern;
            this.refresh();
        }
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    protected void reset() {
        this.toPrevious.clear();
        int n = this.getInputSize();
        this.fromPrevious = new int[n];
        for (int i = 0; i < n; ++i) {
            this.fromPrevious[i] = -1;
        }
    }

    protected void filter() {
        if (this.pattern != null) {
            int n = this.getInputSize();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (!this.test(i)) continue;
                this.toPrevious.add(new Integer(i));
                this.fromPrevious[i] = n2++;
            }
        }
    }

    public boolean test(int n) {
        if (this.pattern == null) {
            return false;
        }
        if (!this.adapter.isTestable(this.getColumnIndex())) {
            return false;
        }
        Object object = this.getInputValue(n, this.getColumnIndex());
        if (object == null) {
            return false;
        }
        boolean bl = this.pattern.matcher(object.toString()).find();
        return bl;
    }

    public int getSize() {
        return this.toPrevious.size();
    }

    protected int mapTowardModel(int n) {
        return this.toPrevious.get(n);
    }
}

