/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.importers.batch;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.xemelios.common.ToolException;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.importers.ImportServiceProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class ImportServiceBatchProvider
implements ImportServiceProvider {
    private static Logger logger = Logger.getLogger(ImportServiceBatchProvider.class);
    public Pair collectivite;
    public Pair budget;
    public DocumentModel dm;

    public ImportServiceBatchProvider(DocumentModel dm, Pair collectivite, Pair budget) {
        this.dm = dm;
        this.budget = budget;
        this.collectivite = collectivite;
    }

    public Pair getBudget(DocumentModel dm, Pair collectivite, String fileName) throws ToolException {
        logger.debug((Object)"getBudget");
        String codeBudget = null;
        String libBudget = null;
        if (this.budget == null) {
            InputStreamReader reader1 = new InputStreamReader(System.in);
            System.out.println("Quel est le Code Budget de ce document : " + fileName + " ?");
            BufferedReader line1 = new BufferedReader(reader1);
            try {
                codeBudget = line1.readLine().toString();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            InputStreamReader reader2 = new InputStreamReader(System.in);
            System.out.println("Quel est le Libelle du Budget de ce document : " + fileName + " ?");
            BufferedReader line2 = new BufferedReader(reader2);
            try {
                libBudget = line2.readLine().toString();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.budget = new Pair(codeBudget, libBudget);
        }
        return this.budget;
    }

    public Pair getCollectivite(DocumentModel dm, String fileName) throws ToolException {
        logger.debug((Object)"getCollectivite");
        String codeColl = null;
        String libColl = null;
        if (this.budget == null) {
            InputStreamReader reader = new InputStreamReader(System.in);
            System.out.println("Quel est le SIRET de la collectivit\u00e9 de ce document : " + fileName + " ?");
            BufferedReader line = new BufferedReader(reader);
            try {
                codeColl = line.readLine().toString();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            System.out.println("Quel est le Libelle de la collectivit\u00e9 de ce document : " + fileName + " ?");
            line = new BufferedReader(reader);
            try {
                libColl = line.readLine().toString();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.collectivite = new Pair(codeColl, libColl);
        }
        return this.collectivite;
    }

    public boolean getOverwrite(String docName) throws Exception {
        logger.debug((Object)"getOverwrite");
        boolean ret = false;
        InputStreamReader reader = new InputStreamReader(System.in);
        BufferedReader line = new BufferedReader(reader);
        System.out.println("Voulez vous ecrasez le document " + docName + "? Repondre par oui ou non.");
        if (line.readLine().toLowerCase().matches("oui")) {
            ret = true;
        }
        return ret;
    }

    public void displayMessage(String msg, int msgType) {
        System.out.println(msgType == 1 ? "INFO : " + msg : "ERROR : " + msg);
    }

    public void displayException(Throwable t) {
    }

    public void displayProgress(int nbFiles) {
    }

    public void endLongWait() {
    }

    public void pushCurrentProgress(int progress) throws NullPointerException {
    }

    public void startLongWait() {
    }

    public void setDisplayFeedback(boolean display) {
    }

    public boolean shouldDisplayFeedback() {
        return true;
    }

    public void setBudget(Pair p) {
    }

    public void setCollectivite(Pair p) {
    }
}

