/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.importers.batch;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.xemelios.common.PJRef;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsParser;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.importers.EtatImporteur;
import fr.gouv.finances.cp.xemelios.importers.ImportServiceProvider;
import fr.gouv.finances.cp.xemelios.importers.batch.ImportServiceBatchProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class BatchRealImporter {
    private static Logger logger = null;
    private ArrayList<File> files;
    private Pair budg;
    private Pair coll;
    private DocumentsModel docModels;
    private String documentid;
    private Vector<String> cmopts;
    private Options opts = new Options();
    private String[] arguments;
    private PosixParser posixparser;
    private boolean budgIsInterractif = false;
    private boolean collIsInterractif = false;

    public BatchRealImporter() throws Exception {
        this.files = new ArrayList();
    }

    public static void main(String[] args) throws Exception {
        int i;
        BatchRealImporter o = new BatchRealImporter();
        o.arguments = args;
        o.createLogger();
        o.loadConfig();
        o.setCommandLineOptions();
        o.posixparser = new PosixParser();
        CommandLine cm = o.posixparser.parse(o.opts, args);
        Option[] s = cm.getOptions();
        o.cmopts = new Vector();
        for (i = 0; i < s.length; ++i) {
            o.cmopts.add(s[i].getOpt());
        }
        if (!o.cmopts.contains("h")) {
            if (o.cmopts.contains("d")) {
                int i2;
                for (i = 0; i < args.length; ++i) {
                    if (!args[i].matches("-d")) continue;
                    o.documentid = args[i + 1];
                    System.out.println("docId =" + o.documentid);
                }
                if (o.cmopts.contains("f")) {
                    Vector<String> fil = new Vector<String>();
                    for (i2 = 0; i2 < args.length; ++i2) {
                        if (!args[i2].matches("-f")) continue;
                        for (int j = i2 + 1; j < args.length; ++j) {
                            fil.add(args[j]);
                        }
                    }
                    o.setFilesToImport(fil.toArray());
                }
                if (o.cmopts.contains("f") && o.cmopts.contains("i")) {
                    Vector fil = new Vector();
                    for (i2 = 0; i2 < args.length; ++i2) {
                        if (!args[i2].matches("-i")) continue;
                        if (args[i2 + 1].matches("yes")) {
                            o.budgIsInterractif = true;
                        }
                        if (!args[i2 + 2].matches("yes")) continue;
                        o.collIsInterractif = true;
                    }
                    o.setFilesToImport(fil.toArray());
                } else {
                    System.out.println("L'option fichier(s) est obligatoire dans la ligne de commande lorsque le mode interractif est declarer.");
                }
                o.importer(o.documentid);
            } else {
                System.out.println("L'option type de document est obligatoire dans la ligne de commande.");
            }
        } else {
            System.out.println("\n\nAide de l'importer batch.\n_________________________\n\nSyntaxe : importerBatch \u0096d [typeDoc] \u0096b [code][libelle] \u0096c [code][libelle] -i [budget][collectivite] -f [fichier(s)]\n\n-d : MODELE DU DOCUMENT \u00e0 importer >> Option Obligatoire.\n\n-b : BUDGET DU FICHIER  >> Option Facultative.\n\n       - Si le budget est pr\u00e9sent dans le fichier cette option est inutile.\n       - Sinon pr\u00e9cisez le libell\u00e9 puis le code du budget.\n\t\t- Si pas d\u0092argument pour le budget :\n\t\t\t- Si pr\u00e9sence d\u0092un budget par defaut dans fichier de conf, alors on celui-ci sera pris.\n\t\t\t- Sinon, abandon de l\u0092import car le budget n'est pas d\u00e9finit.\n\t\t- Si option particuli\u00e8re \u0096i y n alors mode interactif avec l\u0092utilisateur dans la console.Pour chaque fichier sans budget, on pause la question \u00e0 l\u0092utilisateur.\n\n-c : COLLECTIVITE DU FICHIER  >> Option Facultative.\n\n\t\t- Si la collectivit\u00e9 est pr\u00e9sente dans le fichier, on l\u0092utilise.\n\t\t- Sinon on prend celui de l\u0092argument.\n\t\t- Si pas d\u0092argument pour la collectivit\u00e9, alors mode interactif avec l\u0092utilisateur dans la console.\nPour chaque fichier sans collectivit\u00e9, on pause la question \u00e0 l\u0092utilisateur.\n\n-i : MODE INTERACTIF  >> Option Facultative.\n\t\t- y ou n permet d'activer l'option interactive pour l'element en question.\n\n-f : NOM DU/DES FICHIER(S) \u00e0 importer");
        }
    }

    private void setFilesToImport(Object[] nomFichier) {
        for (int i = 0; i < nomFichier.length; ++i) {
            this.files.add(new File(nomFichier[i].toString()));
        }
    }

    private void setCommandLineOptions() {
        this.opts.addOption("d", true, "Modele de Document");
        this.opts.getOption("d").setArgs(1);
        this.opts.addOption("b", true, "Budget du document");
        this.opts.getOption("b").setArgs(2);
        this.opts.addOption("c", true, "Collectivite du document");
        this.opts.getOption("c").setArgs(2);
        this.opts.addOption("i", true, "Mode interractif pour la saisie du budget ou de la collectivite du document");
        this.opts.getOption("i").setArgs(2);
        this.opts.addOption("f", true, "Fichier(s) a importer");
        this.opts.addOption("h", true, "Aide");
    }

    private void importer(String docId) {
        DocumentModel dm = this.docModels.getDocumentById(docId);
        try {
            int i;
            Class<?> clazz = Class.forName(dm.getImportClass());
            Object obj = clazz.newInstance();
            if (!(obj instanceof EtatImporteur)) {
                System.out.println("Cette classe n'est pas un importeur.\nLe fichier de configuration qui vous a \u00e9t\u00e9 livr\u00e9 est certainement invalide.\nVeuillez contacter votre fournisseur.");
                return;
            }
            EtatImporteur ei = (EtatImporteur)obj;
            if (!this.collIsInterractif && this.cmopts.contains("c") && this.coll == null) {
                for (i = 0; i < this.arguments.length; ++i) {
                    if (!this.arguments[i].matches("-c")) continue;
                    this.coll = new Pair(this.arguments[i + 1], this.arguments[i + 2]);
                }
            }
            if (!this.budgIsInterractif) {
                if (this.cmopts.contains("b") && this.budg == null) {
                    for (i = 0; i < this.arguments.length; ++i) {
                        if (!this.arguments[i].matches("-b")) continue;
                        this.budg = new Pair(this.arguments[i + 1], this.arguments[i + 2]);
                    }
                } else if (!dm.getDefaultBudgets().isEmpty()) {
                    this.budg = (Pair)dm.getDefaultBudgets().firstElement();
                } else {
                    System.out.println("Aucun budget d\u00e9finit pour ce fichier.\nLe budget n'est definit ni dans le fichier,ni dans le fichier de configuration et ni dans la ligne de commande.\nL'import a donc \u00e9t\u00e9 annul\u00e9 pour faute de budget.");
                }
            }
            ImportServiceBatchProvider isbp = new ImportServiceBatchProvider(dm, this.coll, this.budg);
            ei.setImpSvcProvider((ImportServiceProvider)isbp);
            ei.setDocument(dm);
            ImportContent fToImport = this.files(dm.getExtension(), dm.getBalise());
            ei.setFilesToImport(fToImport.filesToImport);
            ei.setPjs(fToImport.pjs);
            ei.execute();
        }
        catch (Exception ex) {
            logger.error((Object)"private void importer(String docId)");
            ex.printStackTrace();
        }
    }

    private void createLogger() {
        String log4jConfFile = System.getProperty("xemelios.log4j.xml");
        DOMConfigurator.configure((String)log4jConfFile);
        logger = Logger.getLogger(BatchRealImporter.class);
        logger.info((Object)"log4J initialise");
    }

    protected void loadConfig() throws DataConfigurationException {
        this.docModels = this.getDocumentsInfos(System.getProperty("xemelios.documents.def.dir"));
        this.initDataLayer();
    }

    protected void initDataLayer() throws DataConfigurationException {
        String availableLayers = System.getProperty("xemelios.available.datalayers");
        StringTokenizer tokenizer = new StringTokenizer(availableLayers, ",");
        while (tokenizer.hasMoreTokens()) {
            String className = tokenizer.nextToken();
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException cnfEx) {
                logger.error((Object)"instanciating data layer: ", (Throwable)cnfEx);
            }
        }
        DataLayerManager.setDataImpl((String)System.getProperty("xemelios.data.impl"));
    }

    protected DocumentsModel getDocumentsInfos(String repertoire) {
        DocumentsModel ret = null;
        try {
            File dir = new File(repertoire);
            logger.debug((Object)("Searching " + repertoire));
            if (!dir.exists()) {
                logger.info((Object)(repertoire + " does not exists."));
                return null;
            }
            File[] fichiers = dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toUpperCase().endsWith(".XML");
                }
            });
            if (fichiers == null) {
                logger.info((Object)("No file found in " + repertoire));
                return null;
            }
            DocumentsParser dp = new DocumentsParser();
            for (int i = 0; i < fichiers.length; ++i) {
                dp.parse(fichiers[i]);
                DocumentsModel dm = (DocumentsModel)dp.getMarshallable();
                if (ret == null) {
                    ret = dm;
                    continue;
                }
                Enumeration enumer = dm.getDocuments().elements();
                while (enumer.hasMoreElements()) {
                    ret.addChild((XmlMarshallable)enumer.nextElement(), "document");
                }
            }
            ret.validate();
        }
        catch (Exception ex) {
            logger.error((Object)"getDocumentsInfos", (Throwable)ex);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImportContent files(String extension, String titreEtat) {
        ImportContent ic = new ImportContent(this.files);
        Vector<File> ret = new Vector<File>();
        for (int i = 0; i < ic.filesToImport.size(); ++i) {
            ret.add(ic.filesToImport.get(i));
        }
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        for (int i = 0; i < ret.size(); ++i) {
            if (((File)ret.get(i)).getName().toLowerCase().endsWith(".zip")) {
                if (!((File)ret.get(i)).exists()) continue;
                ZipFile zf = null;
                try {
                    zf = new ZipFile((File)ret.get(i));
                    Enumeration<? extends ZipEntry> enumer = zf.entries();
                    while (enumer.hasMoreElements()) {
                        ZipEntry ze = enumer.nextElement();
                        if (ze.isDirectory()) continue;
                        String fileName = ze.getName();
                        String entryName = fileName.toLowerCase();
                        fileName = fileName.replace(File.pathSeparatorChar, '_').replace(File.separatorChar, '_').replace(':', '|').replace('\'', '_').replace('/', '_');
                        logger.debug((Object)entryName);
                        if (PJRef.isPJ((ZipEntry)ze)) {
                            PJRef pj = new PJRef(ze);
                            pj.writeTmpFile(tmpDir, zf);
                            ic.pjs.add(pj);
                            continue;
                        }
                        if (!entryName.endsWith(extension.toLowerCase()) && !entryName.endsWith(".xml") || fileName.startsWith("_")) continue;
                        InputStream is = zf.getInputStream(ze);
                        BufferedInputStream bis = new BufferedInputStream(is);
                        File output = new File(tmpDir, fileName);
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(output));
                        byte[] buffer = new byte[1024];
                        int read = bis.read(buffer);
                        while (read > 0) {
                            bos.write(buffer, 0, read);
                            read = bis.read(buffer);
                        }
                        bos.flush();
                        bos.close();
                        bis.close();
                        ic.filesToImport.add(output);
                    }
                    zf.close();
                    continue;
                }
                catch (ZipException zEx) {
                    System.out.println("Le fichier " + ((File)ret.get(i)).getName() + " n'est pas une archive ZIP valide.");
                    continue;
                }
                catch (IOException ioEx) {
                    ioEx.printStackTrace();
                    continue;
                }
                finally {
                    if (zf != null) {
                        try {
                            zf.close();
                        }
                        catch (Throwable t) {}
                    }
                }
            }
            ic.filesToImport.add((File)ret.get(i));
        }
        return ic;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ImportContent {
        ArrayList<File> filesToImport = new ArrayList();
        ArrayList<PJRef> pjs;

        public ImportContent(ArrayList<File> f) {
            this.filesToImport = f;
            this.pjs = new ArrayList();
        }
    }
}

