/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.importers.batch;

import fr.gouv.finances.cp.utils.PropertiesExpansion;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Properties;

public class BatchImporter {
    private static final Class[] parameters = new Class[]{URL.class};

    static void restoreProperties() {
        PropertiesExpansion properties = new PropertiesExpansion();
        String propsFileName = System.getProperty("xemelios.properties");
        if (propsFileName == null) {
            propsFileName = "xemelios.properties";
        }
        File propsFile = new File(propsFileName);
        try {
            if (!propsFile.isFile() || !propsFile.canRead()) {
                System.err.println("Impossible d'acc\u00e9der \u00e0 " + propsFileName);
            }
        }
        catch (SecurityException se) {
            System.err.println("Probl\u00e8me d'acc\u00e8s au fichier " + propsFileName);
        }
        if (propsFile != null) {
            try {
                FileInputStream in = new FileInputStream(propsFile);
                ((Properties)properties).load(in);
            }
            catch (IOException ioe) {
                System.err.println("Cannot load properties " + ioe);
                return;
            }
        }
        Enumeration<Object> en = properties.keys();
        while (en.hasMoreElements()) {
            String k = (String)en.nextElement();
            Object v = properties.get(k);
            if (!(v instanceof String)) continue;
            System.setProperty(k, (String)v);
        }
    }

    public static void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public static void main(String[] args) throws Exception {
        BatchImporter.restoreProperties();
        String classdirs = System.getProperty("classdirs");
        String startclass = "fr.gouv.finances.cp.xemelios.importers.batch.BatchRealImporter";
        String[] classdirsArray = classdirs.split(";");
        for (int dir = 0; dir < classdirsArray.length; ++dir) {
            try {
                File jarsdir = new File(classdirsArray[dir]);
                BatchImporter.addURL(new URL("file:" + jarsdir.getAbsolutePath()));
                File[] listJars = jarsdir.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        String s = pathname.getPath();
                        return s.endsWith(".jar");
                    }
                });
                for (int i = 0; i < listJars.length; ++i) {
                    BatchImporter.addURL(new URL("file:" + listJars[i].getAbsolutePath()));
                }
                continue;
            }
            catch (NullPointerException n) {
                System.err.println("Impossible de trouver le repertoire " + classdirsArray[dir]);
            }
        }
        String SnewInstance = System.getProperty("startclass.newInstance");
        boolean newInstance = new Boolean(SnewInstance);
        String SinstanceMethod = System.getProperty("startclass.instanceMethod");
        String SclassMethod = System.getProperty("startclass.classMethod");
        String SclassMethodArgs = null;
        if ("main".equals(SclassMethod)) {
            if (args != null && args.length > 0) {
                StringBuffer sb = new StringBuffer();
                for (String arg : args) {
                    sb.append(arg).append(",");
                }
                SclassMethodArgs = sb.toString();
            } else {
                SclassMethodArgs = "/xxx";
            }
        } else {
            SclassMethodArgs = System.getProperty("startclass.classMethod.Args");
        }
        Class<?> startClass = Class.forName(startclass);
        if (SclassMethod != null) {
            if (SclassMethodArgs != null) {
                String[] classMethodArgsArray = SclassMethodArgs.split(",");
                System.out.print("classMethodArgsArray=");
                for (String s : classMethodArgsArray) {
                    System.out.print(s);
                    System.out.print(";");
                }
                System.out.println();
                Class[] params = new Class[]{String[].class};
                Method classMethod = startClass.getDeclaredMethod(SclassMethod, params);
                Object[] parametersValues = new Object[]{classMethodArgsArray};
                System.out.println("parametersValues=" + parametersValues);
                classMethod.invoke(null, parametersValues);
            } else {
                Method classMethod = startClass.getDeclaredMethod(SclassMethod, new Class[0]);
                classMethod.invoke(null, new Object[0]);
            }
        }
        if (SinstanceMethod != null) {
            newInstance = true;
        }
        if (newInstance) {
            Object instance = startClass.newInstance();
            if (SinstanceMethod != null) {
                Method instanceMethod = startClass.getDeclaredMethod(SinstanceMethod, new Class[0]);
                instanceMethod.invoke(instance, new Object[0]);
            }
        }
    }
}

