/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.utils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class TextWriter {
    private static final String DefaultIndentBuffer;
    private String defaultEncoding = "ISO-8859-1";
    private Node node;
    private boolean produceHTML;
    private boolean prettyPrint;
    private int indentSize = 4;
    private int indentLevel = 0;
    private String indentTemplate = DefaultIndentBuffer;
    private StringBuffer textBuffer = new StringBuffer();

    public TextWriter(Node node, boolean produceHTML, boolean prettyPrint, int indentSize) {
        this.node = node;
        this.produceHTML = produceHTML;
        this.prettyPrint = prettyPrint;
        this.indentSize = indentSize;
    }

    public TextWriter(Node node, boolean produceHTML, boolean prettyPrint) {
        this.node = node;
        this.produceHTML = produceHTML;
        this.prettyPrint = prettyPrint;
    }

    public TextWriter(Node node, boolean produceHTML) {
        this.node = node;
        this.produceHTML = produceHTML;
    }

    public TextWriter(Node node) {
        this.node = node;
    }

    public TextWriter(Node node, String encoding) {
        this.node = node;
        if (encoding != null) {
            this.defaultEncoding = encoding;
        }
    }

    public boolean isProduceHTML() {
        return this.produceHTML;
    }

    public void setProduceHTML(boolean produceHTML) {
        this.produceHTML = produceHTML;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    private void writeNode(Writer writer, Node node) throws IOException {
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this.document(writer, (Document)node);
                break;
            }
            case 11: {
                this.documentFragment(writer, (DocumentFragment)node);
                break;
            }
            case 10: {
                this.documentType(writer, (DocumentType)node);
                break;
            }
            case 1: {
                this.element(writer, (Element)node);
                break;
            }
            case 2: {
                this.attribute(writer, (Attr)node);
                break;
            }
            case 5: {
                this.entityReference(writer, (EntityReference)node);
                break;
            }
            case 6: {
                this.entity(writer, (Entity)node);
                break;
            }
            case 12: {
                this.notation(writer, (Notation)node);
                break;
            }
            case 7: {
                this.procInst(writer, (ProcessingInstruction)node);
                break;
            }
            case 3: {
                this.text(writer, (Text)node);
                break;
            }
            case 4: {
                this.cDataSection(writer, (CDATASection)node);
                break;
            }
            case 8: {
                this.comment(writer, (Comment)node);
            }
        }
    }

    private String getChildText(Node node) {
        StringBuffer sb = new StringBuffer();
        NodeList l = node.getChildNodes();
        int size = l.getLength();
        for (int i = 0; i < size; ++i) {
            Node n = l.item(i);
            if (n.getNodeType() != 3) {
                return null;
            }
            Text t = (Text)n;
            sb.append(t.getData());
        }
        return sb.toString();
    }

    private void writeChildren(Writer writer, Node node) throws IOException {
        NodeList l = node.getChildNodes();
        int size = l.getLength();
        for (int i = 0; i < size; ++i) {
            Node n = l.item(i);
            this.writeNode(writer, n);
        }
    }

    private void document(Writer writer, Document doc) throws IOException {
        if (!this.produceHTML) {
            writer.write("<?xml version=\"1.0\" encoding=\"");
            writer.write(this.defaultEncoding);
            writer.write("\"?>\n");
        }
        this.writeChildren(writer, doc);
    }

    private void documentFragment(Writer writer, DocumentFragment fragment) throws IOException {
        this.writeChildren(writer, fragment);
    }

    private void documentType(Writer writer, DocumentType docType) throws IOException {
        String is;
        writer.write("<!DOCTYPE ");
        writer.write(docType.getName());
        String pubID = docType.getPublicId();
        String sysID = docType.getSystemId();
        if (pubID != null) {
            writer.write(" PUBLIC ");
            writer.write(pubID);
            if (sysID != null) {
                writer.write(32);
                writer.write(sysID);
            }
        } else if (sysID != null) {
            writer.write(" SYSTEM ");
            writer.write(sysID);
        }
        if ((is = docType.getInternalSubset()) != null) {
            writer.write(" [");
            writer.write(is);
            writer.write("]");
        }
        writer.write(">\n");
    }

    private void element(Writer writer, Element elem) throws IOException {
        if (this.prettyPrint) {
            this.checkTextBuffer(writer);
            this.indent(writer);
        }
        String n = elem.getTagName();
        writer.write(60);
        this.writeText(writer, n);
        NamedNodeMap a = elem.getAttributes();
        int size = a.getLength();
        for (int i = 0; i < size; ++i) {
            Attr att = (Attr)a.item(i);
            writer.write(32);
            this.writeNode(writer, att);
        }
        if (elem.hasChildNodes()) {
            writer.write(62);
            if (this.prettyPrint) {
                String text = this.getChildText(elem);
                if (text != null) {
                    this.writeEscapedText(writer, this.normalizeString(text), false);
                } else {
                    writer.write(10);
                    ++this.indentLevel;
                    this.writeChildren(writer, elem);
                    this.checkTextBuffer(writer);
                    --this.indentLevel;
                    this.indent(writer);
                }
            } else {
                this.writeChildren(writer, elem);
            }
            writer.write("</");
            this.writeText(writer, n);
            writer.write(62);
        } else if (this.produceHTML) {
            writer.write(">");
        } else {
            writer.write("/>");
        }
        if (this.prettyPrint) {
            writer.write(10);
        }
    }

    private void attribute(Writer writer, Attr attr) throws IOException {
        this.writeText(writer, attr.getName());
        writer.write("=\"");
        writer.write(StringEscapeUtils.escapeXml(attr.getValue()));
        writer.write("\"");
    }

    private void entityReference(Writer writer, EntityReference entityRef) throws IOException {
    }

    private void entity(Writer writer, Entity entity) throws IOException {
    }

    private void notation(Writer writer, Notation notation) throws IOException {
        if (this.prettyPrint) {
            this.checkTextBuffer(writer);
            this.indent(writer);
        }
        writer.write("<!NOTATION ");
        writer.write(notation.getNodeName());
        String pubID = notation.getPublicId();
        String sysID = notation.getSystemId();
        if (pubID != null) {
            writer.write(" PUBLIC ");
            writer.write(pubID);
            if (sysID != null) {
                writer.write(32);
                writer.write(sysID);
            }
        } else if (sysID != null) {
            writer.write(" SYSTEM ");
            writer.write(sysID);
        }
        writer.write(">\n");
    }

    private void procInst(Writer writer, ProcessingInstruction pi) throws IOException {
        if (this.prettyPrint) {
            this.checkTextBuffer(writer);
            this.indent(writer);
        }
        writer.write("<?");
        this.writeText(writer, pi.getTarget());
        writer.write(" ");
        this.writeText(writer, pi.getData());
        writer.write("?>\n");
    }

    private void text(Writer writer, Text text) throws IOException {
        if (this.prettyPrint) {
            this.textBuffer.append(text.getData());
        } else {
            this.writeEscapedText(writer, text.getData(), false);
        }
    }

    private void cDataSection(Writer writer, CDATASection cdata) throws IOException {
        if (this.prettyPrint) {
            this.checkTextBuffer(writer);
            this.indent(writer);
        }
        writer.write("<![CDATA[");
        writer.write(cdata.getData());
        writer.write("]]>");
        if (this.prettyPrint) {
            writer.write(10);
        }
    }

    private void comment(Writer writer, Comment comment) throws IOException {
        if (this.prettyPrint) {
            this.checkTextBuffer(writer);
            this.indent(writer);
        }
        writer.write("<!--");
        this.writeText(writer, comment.getData());
        writer.write("-->");
        if (this.prettyPrint) {
            writer.write(10);
        }
    }

    private void writeText(Writer writer, String text) throws IOException {
        if (text != null) {
            writer.write(text);
        }
    }

    private void writeEscapedText(Writer writer, String text, boolean attr) throws IOException {
        if (text != null) {
            char[] value = text.toCharArray();
            String outval = null;
            int start = 0;
            int len = 0;
            block8: for (int i = 0; i < value.length; ++i) {
                char c = value[i];
                switch (c) {
                    case '\"': {
                        outval = "&quot;";
                        break;
                    }
                    case '<': {
                        outval = "&lt;";
                        break;
                    }
                    case '>': {
                        outval = "&gt;";
                        break;
                    }
                    case '&': {
                        if (this.produceHTML && attr) {
                            ++len;
                            break;
                        }
                        outval = "&amp;";
                        break;
                    }
                    case '\'': {
                        if (this.produceHTML) {
                            ++len;
                            break;
                        }
                        outval = "&apos;";
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        ++len;
                        continue block8;
                    }
                    default: {
                        ++len;
                        continue block8;
                    }
                }
                if (outval == null) continue;
                if (len > 0) {
                    String s = new String(value, start, len);
                    writer.write(value, start, len);
                }
                writer.write(outval);
                start = i + 1;
                len = 0;
                outval = null;
            }
            if (len > 0) {
                writer.write(value, start, len);
            }
        }
    }

    private void checkTextBuffer(Writer writer) throws IOException {
        if (this.textBuffer.length() > 0) {
            String val = this.normalizeString(this.textBuffer.toString());
            this.textBuffer.setLength(0);
            if (val.length() > 0) {
                this.indent(writer);
                this.writeEscapedText(writer, val, false);
                writer.write(10);
            }
        }
    }

    private void indent(Writer writer) throws IOException {
        this.indent(writer, this.indentLevel);
    }

    private void indent(Writer writer, int level) throws IOException {
        int size = level * this.indentSize;
        if (size > 0) {
            if (this.indentTemplate.length() < size) {
                StringBuffer sb = new StringBuffer(this.indentTemplate);
                for (int i = this.indentTemplate.length(); i < size; ++i) {
                    sb.append(' ');
                }
                this.indentTemplate = sb.toString();
            }
            writer.write(this.indentTemplate.substring(0, size));
        }
    }

    private String normalizeString(String value) {
        char[] c = value.toCharArray();
        char[] n = new char[c.length];
        boolean white = true;
        int pos = 0;
        for (int i = 0; i < c.length; ++i) {
            if (" \t\n\r".indexOf(c[i]) != -1) {
                if (white) continue;
                n[pos++] = 32;
                white = true;
                continue;
            }
            n[pos++] = c[i];
            white = false;
        }
        if (white && pos > 0) {
            --pos;
        }
        return new String(n, 0, pos);
    }

    public static void write(Node node, Writer writer) throws IOException {
        new TextWriter(node).write(writer);
    }

    public static void writeHTML(Node node, Writer writer) throws IOException {
        new TextWriter(node, true).write(writer);
    }

    public static void writePretty(Node node, Writer writer) throws IOException {
        new TextWriter(node, false, true).write(writer);
    }

    public static void writePrettyHTML(Node node, Writer writer) throws IOException {
        new TextWriter(node, true, true).write(writer);
    }

    public void write(Writer writer) throws IOException {
        try {
            BufferedWriter buf = new BufferedWriter(writer, 4096);
            this.writeNode(buf, this.node);
            buf.flush();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static void write(Node node, OutputStream output) throws IOException {
        new TextWriter(node).write(output);
    }

    public static void writeHTML(Node node, OutputStream output) throws IOException {
        new TextWriter(node, true).write(output);
    }

    public static void writePretty(Node node, OutputStream output) throws IOException {
        new TextWriter(node, false, true).write(output);
    }

    public static void writePrettyHTML(Node node, OutputStream output) throws IOException {
        new TextWriter(node, true, true).write(output);
    }

    public void write(OutputStream output) throws IOException {
        try {
            OutputStreamWriter o = new OutputStreamWriter(output, "UTF8");
            BufferedWriter buf = new BufferedWriter(o, 4096);
            this.writeNode(buf, this.node);
            buf.flush();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static String toString(Node node) {
        return new TextWriter(node).toString();
    }

    public static String toString(Node node, String encoding) {
        return new TextWriter(node, encoding).toString();
    }

    public static String toHTMLString(Node node) {
        return new TextWriter(node, true).toString();
    }

    public static String toPrettyString(Node node) {
        return new TextWriter(node, false, true).toString();
    }

    public static String toPrettyHTMLString(Node node) {
        return new TextWriter(node, true, true).toString();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.write(writer);
            return writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    static {
        StringBuffer sb = new StringBuffer(256);
        for (int i = 0; i < 256; ++i) {
            sb.append(' ');
        }
        DefaultIndentBuffer = sb.toString();
    }
}

