/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.xhtmlviewer;

import fr.gouv.finances.cp.xemelios.ui.xhtmlviewer.ScaleChangeEvent;
import fr.gouv.finances.cp.xemelios.ui.xhtmlviewer.ScaleChangeListener;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.print.PrinterGraphics;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.event.DocumentListener;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.PaintingInfo;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.swing.Java2DOutputDevice;

public class XemeliosXhtmlPanel
extends XHTMLPanel {
    private static final Logger logger = Logger.getLogger(XemeliosXhtmlPanel.class);
    public static final double SCALE_PAGE_WIDTH = -2.0;
    private double scale = -1.0;
    private Dimension lastLayoutSize = null;
    private ArrayList<ScaleChangeListener> listeners = new ArrayList();

    public XemeliosXhtmlPanel(UserAgentCallback uac) {
        super(uac);
        this.addDocumentListener(new DocumentListener(){

            public void documentLoaded() {
                String url = XemeliosXhtmlPanel.this.getURL().toExternalForm();
                int sharpPos = url.indexOf(35);
                if (sharpPos >= 0) {
                    String anchorName = url.substring(sharpPos + 1);
                    Box box = XemeliosXhtmlPanel.this.getSharedContext().getBoxById(anchorName);
                    if (box != null) {
                        Point pt;
                        if (box.getStyle().isInline()) {
                            pt = new Point(box.getAbsX(), box.getAbsY());
                        } else {
                            RectPropertySet margin = box.getMargin((CssContext)XemeliosXhtmlPanel.this.layout_context);
                            pt = new Point(box.getAbsX() + (int)margin.left(), box.getAbsY() + (int)margin.top());
                        }
                        Point transPoint = new Point((int)(pt.getX() / XemeliosXhtmlPanel.this.scale), (int)(pt.getY() / XemeliosXhtmlPanel.this.scale));
                        XemeliosXhtmlPanel.this.scrollTo(transPoint);
                        XemeliosXhtmlPanel.this.repaint();
                        return;
                    }
                    logger.error((Object)("anchor not found: " + anchorName));
                }
            }

            public void onLayoutException(Throwable throwable) {
            }

            public void onRenderException(Throwable throwable) {
            }
        });
    }

    protected void calculateScale(Dimension layoutSize) {
        Rectangle viewportBounds = this.getFixedRectangle();
        this.scale = viewportBounds.width < layoutSize.width ? (double)viewportBounds.width / (double)layoutSize.width : 1.0;
    }

    public double calculateScale() {
        if (this.lastLayoutSize == null) {
            return 1.0;
        }
        Rectangle viewportBounds = this.getFixedRectangle();
        double aScale = viewportBounds.width < this.lastLayoutSize.width ? (double)viewportBounds.width / (double)this.lastLayoutSize.width : 1.0;
        return aScale;
    }

    public void setScale(double newScale) throws IllegalArgumentException {
        this.scale = newScale;
        this.lastLayoutSize = null;
        this.repaint(this.getFixedRectangle());
        this.scaleChanged();
    }

    public void addScaleChangeListener(ScaleChangeListener scl) {
        this.listeners.add(scl);
    }

    public void removeScaleChangeListener(ScaleChangeListener scl) {
        this.listeners.remove(scl);
    }

    private void scaleChanged() {
        ScaleChangeEvent evt = new ScaleChangeEvent(this, this.scale);
        for (ScaleChangeListener scl : this.listeners) {
            scl.scaleChanged(evt);
        }
    }

    protected void doRender(RenderingContext c, Layer root) {
        logger.debug((Object)"doRender");
        Graphics2D g = ((Java2DOutputDevice)c.getOutputDevice()).getGraphics();
        if (!(g instanceof PrinterGraphics) && this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        AffineTransform current = g.getTransform();
        PaintingInfo pI = root.getMaster().getPaintingInfo();
        Dimension layoutSize = pI.getOuterMarginCorner();
        if (-1.0 == this.scale) {
            this.calculateScale(layoutSize);
            this.scaleChanged();
        }
        if (this.lastLayoutSize == null) {
            this.lastLayoutSize = layoutSize;
            this.setSize((int)((double)this.lastLayoutSize.width * this.scale), (int)((double)this.lastLayoutSize.height * this.scale));
        }
        g.transform(AffineTransform.getScaleInstance(this.scale, this.scale));
        super.doRender(c, root);
        g.setTransform(current);
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }

    public Dimension getMaximumSize() {
        return this.getSize();
    }

    public Box find(int x, int y) {
        int tX = (int)((double)x / this.scale);
        int tY = (int)((double)y / this.scale);
        Layer l = this.getRootLayer();
        if (l != null) {
            return l.find((CssContext)this.layout_context, tX, tY);
        }
        return null;
    }

    public void setDocument(Document doc, String url) {
        this.scale = -1.0;
        this.lastLayoutSize = null;
        super.setDocument(doc, url);
    }

    public void setDocument(InputStream stream, String url) throws Exception {
        this.scale = -1.0;
        this.lastLayoutSize = null;
        super.setDocument(stream, url);
    }

    public void setDocument(File file) throws Exception {
        this.scale = -1.0;
        this.lastLayoutSize = null;
        super.setDocument(file);
    }
}

