/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.xhtmlviewer;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.simple.extend.URLUTF8Encoder;
import org.xhtmlrenderer.simple.extend.XhtmlForm;
import org.xhtmlrenderer.swing.AWTFSImage;
import org.xhtmlrenderer.util.XRLog;

public class XemeliosHtmlForm
extends XhtmlForm {
    private static final Logger logger = Logger.getLogger(XemeliosHtmlForm.class);
    private Map<String, ButtonGroup> buttonGroups;
    private XHTMLPanel pane;

    public XemeliosHtmlForm(UserAgentCallback uac, Element e, XHTMLPanel pane) {
        super(uac, e);
        this.pane = pane;
    }

    public UserAgentCallback getUac() {
        return this.uac;
    }

    public JComponent addComponent(Element e) {
        JComponent cc = (JComboBox<String>)this.components.get(e);
        if (cc != null) {
            return cc;
        }
        if (e.getNodeName().equals("input")) {
            String label;
            String type = e.getAttribute("type");
            if (type == null || type.equals("")) {
                type = "button";
            }
            if ((label = e.getAttribute("value")) == null || label.equals("")) {
                if (type.equals("reset")) {
                    label = "Reset";
                }
                if (type.equals("submit")) {
                    label = "Submit";
                }
            }
            if (type.equals("button") || type.equals("reset") || type.equals("submit")) {
                JButton button = new JButton();
                button.setText(label);
                cc = button;
            } else if (type.equals("image")) {
                JButton jb = new JButton();
                Image im = null;
                if (e.hasAttribute("src")) {
                    System.out.println("pulling from here: " + e.getAttribute("src"));
                    FSImage fsImage = this.uac.getImageResource(e.getAttribute("src")).getImage();
                    if (fsImage != null) {
                        im = ((AWTFSImage)fsImage).getImage();
                    }
                }
                if (im == null) {
                    jb = new JButton("Image unreachable. " + e.getAttribute("alt"));
                } else {
                    ImageIcon ii = new ImageIcon(im, e.getAttribute("alt"));
                    jb = new JButton(ii);
                }
                jb.setBorder(BorderFactory.createEmptyBorder());
                cc = jb;
            } else if (type.equals("checkbox")) {
                JCheckBox checkbox = new JCheckBox();
                checkbox.setText("");
                checkbox.setOpaque(false);
                if (e.hasAttribute("checked") && e.getAttribute("checked").equals("checked")) {
                    checkbox.setSelected(true);
                }
                cc = checkbox;
            } else if (type.equals("password")) {
                JPasswordField pw = new JPasswordField();
                if (e.hasAttribute("size")) {
                    pw.setColumns(Integer.parseInt(e.getAttribute("size")));
                } else {
                    pw.setColumns(15);
                }
                if (e.hasAttribute("maxlength")) {
                    final int maxlength = Integer.parseInt(e.getAttribute("maxlength"));
                    pw.setDocument(new PlainDocument(){

                        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
                            if (str == null) {
                                return;
                            }
                            if (this.getLength() + str.length() <= maxlength) {
                                super.insertString(offset, str, attr);
                            }
                        }
                    });
                }
                cc = pw;
            } else if (type.equals("radio")) {
                String name;
                ButtonGroup group;
                JRadioButton radio = new JRadioButton();
                radio.setText("");
                radio.setOpaque(false);
                if (e.hasAttribute("checked") && e.getAttribute("checked").equals("checked")) {
                    radio.setSelected(true);
                }
                if (this.buttonGroups == null) {
                    this.buttonGroups = new HashMap<String, ButtonGroup>();
                }
                if ((group = this.buttonGroups.get(name = e.getAttribute("name"))) == null) {
                    group = new ButtonGroup();
                    this.buttonGroups.put(name, group);
                }
                group.add(radio);
                cc = radio;
            } else if (type.equals("text")) {
                JTextField text = new JTextField();
                if (e.hasAttribute("value")) {
                    text.setText(e.getAttribute("value"));
                }
                if (e.hasAttribute("size")) {
                    text.setColumns(Integer.parseInt(e.getAttribute("size")));
                } else {
                    text.setColumns(15);
                }
                if (e.hasAttribute("maxlength")) {
                    final int maxlength = Integer.parseInt(e.getAttribute("maxlength"));
                    text.setDocument(new PlainDocument(){

                        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
                            if (str == null) {
                                return;
                            }
                            if (this.getLength() + str.length() <= maxlength) {
                                super.insertString(offset, str, attr);
                            }
                        }
                    });
                }
                if (e.hasAttribute("readonly") && e.getAttribute("readonly").equals("readonly")) {
                    text.setEditable(false);
                }
                cc = text;
            } else if (type.equals("hidden")) {
                JTextField text = new JTextField();
                if (e.hasAttribute("value")) {
                    text.setText(e.getAttribute("value"));
                }
                cc = null;
                this.components.put(e, text);
                text.setSize(new Dimension(0, 0));
                text.setVisible(false);
            } else {
                XRLog.layout((String)("unknown input type " + type));
            }
            if (type.equals("submit") || type.equals("image")) {
                ((JButton)cc).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        XemeliosHtmlForm.this.submit((JComponent)evt.getSource());
                    }
                });
            }
        } else if (e.getNodeName().equals("textarea")) {
            int rows = 4;
            int cols = 10;
            if (e.hasAttribute("rows")) {
                rows = Integer.parseInt(e.getAttribute("rows"));
            }
            if (e.hasAttribute("cols")) {
                cols = Integer.parseInt(e.getAttribute("cols"));
            }
            JTextArea ta = new JTextArea(rows, cols);
            JScrollPane sp = new JScrollPane(ta);
            sp.setVerticalScrollBarPolicy(22);
            sp.setHorizontalScrollBarPolicy(32);
            if (e.getFirstChild() != null) {
                ta.setText(e.getFirstChild().getNodeValue());
            }
            cc = sp;
        } else if (e.getNodeName().equals("select")) {
            JComboBox<String> select = new JComboBox<String>();
            select.setEditable(false);
            NodeList options = e.getElementsByTagName("option");
            int selected = -1;
            for (int i = 0; i < options.getLength(); ++i) {
                Element value = (Element)options.item(i);
                String svalue = value.getFirstChild().getNodeValue();
                select.addItem(svalue);
                if (!value.hasAttribute("selected") || !value.getAttribute("selected").equals("selected")) continue;
                selected = i;
            }
            if (selected != -1) {
                select.setSelectedIndex(selected);
            }
            cc = select;
        }
        if (cc != null) {
            cc.setSize(cc.getPreferredSize());
            if (e.hasAttribute("disabled") && e.getAttribute("disabled").equals("disabled")) {
                ((JComponent)cc).setEnabled(false);
            }
            this.components.put(e, cc);
        }
        return cc;
    }

    public void submit(JComponent source) {
        StringBuffer data = new StringBuffer();
        for (Map.Entry field : this.components.entrySet()) {
            Element e = (Element)field.getKey();
            JComponent cc = (JComponent)field.getValue();
            if (e.hasAttribute("disabled") && e.getAttribute("disabled").equals("disabled")) continue;
            if (e.getNodeName().equals("input")) {
                String type = e.getAttribute("type");
                String name = e.getAttribute("name");
                logger.debug((Object)("<input name=" + name == null ? "null" : name + " type=" + type + "/>"));
                if (type == null || type.equals("")) {
                    type = "button";
                }
                if (type.equals("submit") && cc == source) {
                    String value = e.getAttribute("value");
                    if (value.equals("")) {
                        value = "submit";
                    }
                    data.append('&');
                    data.append(URLUTF8Encoder.encode((String)e.getAttribute("name")));
                    data.append("=");
                    data.append(URLUTF8Encoder.encode((String)value));
                    continue;
                }
                if (type.equals("image")) {
                    data.append('&');
                    data.append(URLUTF8Encoder.encode((String)e.getAttribute("name")));
                    data.append("=");
                    data.append(URLUTF8Encoder.encode((String)e.getAttribute("value")));
                    continue;
                }
                if (type.equals("checkbox")) {
                    JCheckBox checkbox = (JCheckBox)cc;
                    if (!checkbox.isSelected()) continue;
                    data.append('&');
                    data.append(URLUTF8Encoder.encode((String)e.getAttribute("name")));
                    data.append("=");
                    data.append(URLUTF8Encoder.encode((String)e.getAttribute("value")));
                    continue;
                }
                if (type.equals("password")) {
                    JPasswordField pw = new JPasswordField();
                    data.append('&');
                    data.append(URLUTF8Encoder.encode((String)e.getAttribute("name")));
                    data.append("=");
                    data.append(URLUTF8Encoder.encode((char[])pw.getPassword()));
                    continue;
                }
                if (type.equals("radio")) {
                    JRadioButton radio = (JRadioButton)cc;
                    if (!radio.isSelected()) continue;
                    data.append('&');
                    data.append(URLUTF8Encoder.encode((String)e.getAttribute("name")));
                    data.append("=");
                    data.append(URLUTF8Encoder.encode((String)e.getAttribute("value")));
                    continue;
                }
                if (!type.equals("text") && !type.equals("hidden")) continue;
                JTextField text = (JTextField)cc;
                data.append('&');
                data.append(URLUTF8Encoder.encode((String)e.getAttribute("name")));
                data.append("=");
                data.append(URLUTF8Encoder.encode((String)text.getText()));
                continue;
            }
            if (e.getNodeName().equals("textarea")) {
                JTextArea ta = (JTextArea)cc;
                data.append('&');
                data.append(URLUTF8Encoder.encode((String)e.getAttribute("name")));
                data.append("=");
                data.append(URLUTF8Encoder.encode((String)ta.getText()));
                continue;
            }
            if (!e.getNodeName().equals("select")) continue;
            JComboBox select = new JComboBox();
            data.append('&');
            data.append(URLUTF8Encoder.encode((String)e.getAttribute("name")));
            data.append("=");
            data.append(URLUTF8Encoder.encode((String)select.getSelectedItem().toString()));
        }
        data.deleteCharAt(0);
        String action = this.formElement.getAttribute("action");
        String method = this.formElement.getAttribute("method");
        if (method.equals("")) {
            method = "get";
        }
        if ("GET".equalsIgnoreCase(method)) {
            StringTokenizer st = new StringTokenizer(data.toString(), "&");
            Hashtable<String, String> params = new Hashtable<String, String>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int pos = token.indexOf(61);
                String paramName = token.substring(0, pos);
                String value = token.substring(pos + 1);
                try {
                    value = URLDecoder.decode(token.substring(pos + 1), "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    // empty catch block
                }
                params.put(paramName, value);
            }
            String path = (String)params.get("path");
            if (path != null) {
                Set keys = params.keySet();
                HashSet<String> toRemove = new HashSet<String>();
                for (String key : keys) {
                    if (key.equals("path") || path.indexOf("%" + key + "%") < 0) continue;
                    path = path.replaceAll("%" + key + "%", (String)params.get(key));
                    toRemove.add(key);
                }
                if (!toRemove.isEmpty()) {
                    keys.removeAll(toRemove);
                }
                params.put("path", URLUTF8Encoder.encode((String)path));
            }
            path = "";
            for (String key : params.keySet()) {
                path = path + key + "=" + (String)params.get(key) + "&";
            }
            path = path.substring(0, path.length() - 1);
            String request = action + "?" + path;
            String realUrl = this.uac.resolveURI(request);
            logger.info((Object)("realUrl=" + realUrl));
            if (this.pane == null) {
                logger.fatal((Object)"pane is NULL !");
            }
            this.pane.setDocument(realUrl);
        }
    }
}

