/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.search;

import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.cp.xemelios.data.DataResultSet;
import fr.gouv.finances.cp.xemelios.ui.SearchWindow;
import fr.gouv.finances.cp.xemelios.ui.resulttable.CachedData;
import fr.gouv.finances.cp.xemelios.ui.resulttable.DataHandler;
import fr.gouv.finances.cp.xemelios.ui.resulttable.EtatResultTableModel;
import fr.gouv.finances.cp.xemelios.ui.resulttable.ResultTable;
import java.awt.Component;
import java.awt.Cursor;
import java.text.DecimalFormat;
import java.util.TreeSet;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;

public class ResultDisplayerThread
extends Thread {
    private static Logger logger = Logger.getLogger(ResultDisplayerThread.class);
    private DataResultSet rs;
    private ListeResultatModel lrm;
    private long start;
    private long startParsing;
    private ElementModel em;
    private SearchWindow sw;

    public ResultDisplayerThread(DataResultSet rs, ListeResultatModel lrm, long start, ElementModel em, SearchWindow sw) {
        super("ResultDisplayer");
        this.rs = rs;
        this.lrm = lrm;
        this.start = start;
        this.em = em;
        this.sw = sw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.startParsing = System.currentTimeMillis();
        try {
            TreeSet<DataHandler> ts = new TreeSet<DataHandler>();
            int count = 0;
            CachedData cache = new CachedData();
            if (this.rs == null) {
                this.sw.setBottomText("Aucun enregistrement trouv\u00e9");
            } else {
                this.rs.setEnvironment(this.lrm, cache);
                while (this.rs.hasNext()) {
                    DataHandler dh = (DataHandler)this.rs.next();
                    if (dh == null) continue;
                    ts.add(dh);
                    ++count;
                }
                this.rs.clear();
                JXTable oldTable = (JXTable)this.sw.getTable();
                JXTable table = null;
                boolean tableIsNew = false;
                if (oldTable != null) {
                    EtatResultTableModel oldModel = (EtatResultTableModel)oldTable.getModel();
                    oldModel.dispose();
                    table = oldTable;
                } else {
                    table = new ResultTable(null, this.sw, this.em);
                    tableIsNew = true;
                }
                EtatResultTableModel tm = new EtatResultTableModel(this.lrm, ts, this.rs);
                table.setModel((TableModel)tm);
                if (tableIsNew) {
                    this.sw.setTable((JTable)table);
                    int pos = this.sw.getSplitter().getDividerLocation();
                    JScrollPane scrollTable = new JScrollPane((Component)table);
                    scrollTable.setVerticalScrollBarPolicy(22);
                    scrollTable.setHorizontalScrollBarPolicy(32);
                    this.sw.getSplitter().setRightComponent(scrollTable);
                    this.sw.getSplitter().setDividerLocation(pos);
                    this.sw.getSplitter().paintImmediately(this.sw.getSplitter().getBounds());
                }
                double duration = (double)(System.currentTimeMillis() - this.start) / 1000.0;
                double durationSearch = (double)(this.startParsing - this.start) / 1000.0;
                double durationParsing = (double)(System.currentTimeMillis() - this.startParsing) / 1000.0;
                DecimalFormat nf = new DecimalFormat("0.0##");
                this.sw.setBottomText(this.rs.getEstimatedSize() + " enregistrement(s) trouv\u00e9(s) en " + nf.format(duration) + " s (" + nf.format(durationSearch) + " s recherche, " + nf.format(durationParsing) + " s affichage)");
                this.sw.getPageSeeker().updateData(this.rs);
            }
            this.sw.setCanExport(ts.size() > 0);
            this.sw.notifyParentStateChanged();
        }
        finally {
            this.sw.setCursor(Cursor.getDefaultCursor());
            this.sw.getParentFrame().stopWaiter();
            this.sw.setSearchEnabled(true);
        }
    }
}

