/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.resulttable;

import fr.gouv.finances.cp.utils.Amount;
import fr.gouv.finances.cp.utils.IoUtils;
import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.StartUrl;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.xemelios.common.DematTransform;
import fr.gouv.finances.cp.xemelios.common.PJRef;
import fr.gouv.finances.cp.xemelios.common.ToolException;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.HiddenModel;
import fr.gouv.finances.cp.xemelios.common.config.PluginModel;
import fr.gouv.finances.cp.xemelios.data.DataAccessException;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataImpl;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.ui.SearchWindow;
import fr.gouv.finances.cp.xemelios.ui.ia.JTRIS;
import fr.gouv.finances.cp.xemelios.ui.resulttable.DataHandler;
import fr.gouv.finances.cp.xemelios.ui.resulttable.EtatResultTableModel;
import fr.gouv.finances.cp.xemelios.ui.resulttable.PJRefInfo;
import fr.gouv.finances.cp.xemelios.ui.resulttable.PjRefHandler;
import fr.gouv.finances.cp.xemelios.utils.XmlUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.AlternateRowHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterPipeline;
import org.w3c.dom.Document;

public class ResultTable
extends JXTable {
    private static final long serialVersionUID = 3311785168156347546L;
    private static Logger logger = Logger.getLogger(ResultTable.class);
    private ElementModel em;
    private SearchWindow searchWindow;
    private static final IhmFactory iF = IhmFactory.newInstance();
    private DataImpl impl = null;

    public ResultTable(TableModel model, final SearchWindow sw, final ElementModel em) {
        super(model);
        this.em = em;
        this.searchWindow = sw;
        AmountRenderer amrenderer = new AmountRenderer();
        this.setDefaultRenderer(Amount.class, amrenderer);
        DateRenderer drenderer = new DateRenderer();
        this.setDefaultRenderer(Date.class, drenderer);
        PjRenderer renderer = new PjRenderer();
        this.setDefaultRenderer(PjRefHandler.class, renderer);
        this.setDefaultEditor(PjRefHandler.class, new PjEditor(sw.getCurrentCollectivite(), sw.getCurrentBudget()));
        this.setAutoResizeMode(0);
        this.setColumnControlVisible(true);
        this.setRolloverEnabled(true);
        if (!"remove".equals(System.getProperty("xemelios.jxtable.highlighter"))) {
            HighlighterPipeline hp = new HighlighterPipeline();
            hp.addHighlighter((Highlighter)new AlternateRowHighlighter());
            this.setHighlighters(hp);
        }
        InputMap im = this.getInputMap();
        KeyStroke ks = KeyStroke.getKeyStroke("control P");
        im.put(ks, "print");
        im.put(KeyStroke.getKeyStroke("control T"), "TT");
        ActionMap am = this.getActionMap();
        am.put("TT", new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JTRIS tetris = new JTRIS(sw.getParentFrame());
                ((Dialog)tetris).setVisible(true);
            }
        });
        PopupListener popupListener = new PopupListener();
        this.getTableHeader().addMouseListener(popupListener);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Point p = evt.getPoint();
                int row = sw.getTable().rowAtPoint(p);
                if (row >= 0 && evt.getClickCount() == 2) {
                    if (em.getXslt() == null || em.getXslt().length() == 0) {
                        return;
                    }
                    try {
                        row = ((JXTable)sw.getTable()).convertRowIndexToModel(row);
                        EtatResultTableModel etrm = (EtatResultTableModel)sw.getTable().getModel();
                        DataHandler dh = etrm.getRowAt(row, 0);
                        Document doc = dh.getDocument();
                        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
                        parameters.put("browser-destination", em.getParent().useExternalBrowser() ? "external" : "internal");
                        for (int pos = 0; pos < etrm.getHiddens().size(); ++pos) {
                            HiddenModel hm = etrm.getHiddens().get(pos);
                            if (!hm.getName().startsWith("xsl-param:")) continue;
                            String paramName = hm.getName().substring("xsl-param:".length());
                            Object paramValue = dh.getValueAtColumn(etrm.getListeChamps().size() + pos);
                            parameters.put(paramName, paramValue);
                        }
                        Document repository = DataLayerManager.getImplementation().getRepositoryAsDom(em.getParent().getParent(), sw.getCurrentCollectivite());
                        parameters.put("repository", repository);
                        InputStream is = IoUtils.getInputStream(em.getXslt());
                        InputStream htmlStream = DematTransform.transform(doc, is, parameters);
                        sw.parentFrame.displayHtmlStream(htmlStream, em.getParent(), sw.getDesktopPane());
                    }
                    catch (Exception ex) {
                        Container comp2;
                        for (comp2 = sw.getTable(); comp2 != null && !(comp2 instanceof JFrame); comp2 = comp2.getParent()) {
                        }
                        if (comp2 != null) {
                            new DisplayExceptionDlg((Frame)((JFrame)comp2), (Throwable)ex);
                        }
                        ex.printStackTrace();
                    }
                }
            }
        });
        try {
            this.impl = DataLayerManager.getImplementation();
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    private class PjDisplayAction
    implements ActionListener {
        private Pair collectivite;
        private Pair budget;
        private PJRefInfo pj;

        public PjDisplayAction(Pair collectivite, Pair budget, PJRefInfo pj) {
            this.collectivite = collectivite;
            this.budget = budget;
            this.pj = pj;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                DataImpl impl = DataLayerManager.getImplementation();
                PJRef pjRef = impl.getPj(this.collectivite, this.pj.getNom());
                if (pjRef != null) {
                    File tmpDir = new File(System.getProperty("java.io.tmpdir"));
                    File tmpFile = File.createTempFile("tmp-", pjRef.getFileName(), tmpDir);
                    FileOutputStream fos = new FileOutputStream(tmpFile);
                    fos.write(pjRef.getData());
                    fos.flush();
                    fos.close();
                    StartUrl.startUrl(tmpFile.toURL().toString());
                } else {
                    JOptionPane.showMessageDialog(null, "Pi\u00e8ce non trouv\u00e9e.");
                }
            }
            catch (DataConfigurationException e) {
                e.printStackTrace();
            }
            catch (DataAccessException daEx) {
                daEx.printStackTrace();
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
            }
            catch (ToolException tEx) {
                tEx.printStackTrace();
            }
        }
    }

    class PjEditor
    extends DefaultCellEditor {
        protected JButton button;
        private Object data;
        private boolean isPushed;
        private Pair collectivite;
        private Pair budget;
        private Point point;
        private JTable table;

        public PjEditor(Pair collectivite, Pair budget) {
            super(new JCheckBox());
            this.collectivite = collectivite;
            this.budget = budget;
            this.button = new JButton("...");
            this.button.setOpaque(true);
            this.button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PjEditor.this.fireEditingStopped();
                }
            });
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.button.setForeground(table.getSelectionForeground());
            this.button.setBackground(table.getSelectionBackground());
            this.data = value;
            Rectangle rect = table.getCellRect(row, column, false);
            this.point = rect.getLocation();
            this.table = table;
            this.isPushed = true;
            return this.button;
        }

        public Object getCellEditorValue() {
            if (this.isPushed) {
                JPopupMenu popup = new JPopupMenu("Pi\u00e8ces jointes");
                if (this.data instanceof PjRefHandler) {
                    PjRefHandler pjs = (PjRefHandler)this.data;
                    for (PJRefInfo pj : pjs.getPjs()) {
                        ImageIcon icon = null;
                        boolean available = false;
                        if ("01".equals(pj.getSupport())) {
                            icon = iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/pj-paper.png");
                        } else if ("02".equals(pj.getSupport())) {
                            icon = iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/pj-dvd.png");
                        } else if ("00".equals(pj.getSupport())) {
                            icon = iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/pj-online.png");
                        } else if ("10".equals(pj.getSupport())) {
                            try {
                                available = ResultTable.this.impl.isPjAvailable(this.collectivite, pj.getNom());
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            icon = available ? iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/pj-available.png") : iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/pj-unavailable.png");
                        }
                        JMenuItem mnu = new JMenuItem(pj.getNom(), icon);
                        if (available) {
                            mnu.addActionListener(new PjDisplayAction(this.collectivite, this.budget, pj));
                        }
                        popup.add(mnu);
                    }
                } else {
                    logger.debug((Object)(this.data.getClass().getName() + " --> " + this.data.toString()));
                }
                popup.show(this.table, this.point.x, this.point.y);
            }
            this.isPushed = false;
            return "...";
        }

        public boolean stopCellEditing() {
            this.isPushed = false;
            return super.stopCellEditing();
        }

        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    class DateRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component parent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel lbl = (JLabel)parent;
            if (value != null && value instanceof Date) {
                Date d = (Date)value;
                SimpleDateFormat sdf = new SimpleDateFormat(System.getProperty("xemelios.date.format", "yyyy-MM-dd"));
                lbl.setText(sdf.format(d));
                lbl.setHorizontalAlignment(2);
            }
            return parent;
        }
    }

    class AmountRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component parent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel lbl = (JLabel)parent;
            if (value != null && value instanceof Amount) {
                Amount am = (Amount)value;
                lbl.setText(am.stringRepresentation());
                lbl.setHorizontalAlignment(4);
            }
            return parent;
        }
    }

    class PjRenderer
    extends JButton
    implements TableCellRenderer {
        public PjRenderer() {
            this.setOpaque(true);
            this.setText("...");
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
            return this;
        }
    }

    class PopupListener
    extends MouseAdapter
    implements ActionListener {
        Pair[] operators;
        HashMap<String, String> operatorList = new HashMap();
        int columnIndex = 0;

        PopupListener() {
        }

        public void mouseReleased(MouseEvent e) {
            if (!e.isConsumed()) {
                this.maybeShowPopup(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (!e.isConsumed()) {
                this.maybeShowPopup(e);
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            Point p = e.getPoint();
            if (e.isPopupTrigger()) {
                e.consume();
                EtatResultTableModel etrm = (EtatResultTableModel)ResultTable.this.searchWindow.getTable().getModel();
                this.columnIndex = ResultTable.this.convertColumnIndexToModel(ResultTable.this.columnAtPoint(p));
                boolean showPopup = etrm.isSumOperationPermittedOnColumn(this.columnIndex);
                logger.debug((Object)("showPopup=" + (showPopup ? "true" : "false")));
                PluginModel pm = ResultTable.this.searchWindow.getPluginModel();
                if (pm != null) {
                    showPopup = showPopup && pm.isSumPossible();
                }
                try {
                    if (showPopup) {
                        DataImpl impl = DataLayerManager.getImplementation();
                        this.operators = impl.getAggregateOperators(etrm.getColumnDatatype(this.columnIndex));
                        if (this.operators.length > 0) {
                            JPopupMenu popup = new JPopupMenu();
                            for (Pair ope : this.operators) {
                                JMenuItem menuItem = new JMenuItem(ope.libelle);
                                menuItem.addActionListener(this);
                                popup.add(menuItem);
                                this.operatorList.put(ope.libelle, ope.key);
                            }
                            popup.show(e.getComponent(), e.getX(), e.getY());
                        }
                    }
                }
                catch (DataConfigurationException dce) {
                    dce.printStackTrace();
                    logger.debug((Object)"DataLayer not implemented");
                }
            }
        }

        public void actionPerformed(ActionEvent ae) {
            JMenuItem item = (JMenuItem)ae.getSource();
            try {
                EtatResultTableModel etrm = (EtatResultTableModel)ResultTable.this.searchWindow.getTable().getModel();
                DocumentModel dm = ResultTable.this.em.getParent().getParent();
                String xpath = etrm.getColumnXPath(this.columnIndex);
                xpath = XmlUtils.normalizeNS(xpath, dm.getNamespaces());
                logger.debug((Object)xpath);
                final String resultat = DataLayerManager.getImplementation().calculateAggregate(ResultTable.this.searchWindow.getDocumentModel(), ResultTable.this.em.getParent(), xpath, this.operatorList.get(item.getText()), etrm.getListeChamps().get(this.columnIndex), etrm.getResultSet());
                final JDialog dialog = new JDialog();
                dialog.setTitle(ResultTable.this.searchWindow.getTitle());
                JLabel texte = new JLabel(item.getText() + " de " + etrm.getColumnHeader(this.columnIndex) + " : " + resultat);
                JButton boutonFermer = new JButton("Fermer");
                JButton boutonCopier = new JButton("Copier");
                boutonCopier.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Clipboard system = Toolkit.getDefaultToolkit().getSystemClipboard();
                        StringSelection ss = new StringSelection(resultat);
                        system.setContents(ss, ss);
                    }
                });
                boutonFermer.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                });
                Box haut = Box.createVerticalBox();
                Box bas = Box.createHorizontalBox();
                bas.add(boutonFermer);
                bas.add(Box.createHorizontalStrut(20));
                bas.add(boutonCopier);
                texte.setAlignmentX(0.5f);
                bas.setAlignmentX(0.5f);
                haut.add(texte);
                haut.add(Box.createVerticalStrut(20));
                haut.add(bas);
                dialog.add(haut);
                dialog.setSize(250, 100);
                dialog.setLocation(600, 500);
                dialog.setVisible(true);
            }
            catch (DataConfigurationException dce) {
                dce.printStackTrace();
            }
            catch (DataAccessException dataAccessException) {
                // empty catch block
            }
        }
    }
}

