/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.ia;

import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.xemelios.ui.ia.Joueur;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Plateau
extends JFrame {
    private static final long serialVersionUID = 3258413915443704633L;
    protected static Color BACK_COLOR = new Color(212, 208, 200);
    private static IhmFactory iF = IhmFactory.newInstance();
    JPanel contentPane;
    JPanel buttonPane = new JPanel();
    JButton jButtonEffacer;
    JButton pbOrdi;
    JPanel jPanelJeu = new JPanel();
    Joueur joueur = new Joueur("X", iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/iconX.png"));
    Joueur ordi = new Joueur("O", iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/iconO.png"));

    public Plateau() {
        super("Faire une ligne de 5 pions...");
        try {
            this.jbInit();
            for (int i = 0; i < 100; ++i) {
                JButton jbt = new JButton();
                jbt.setBackground(BACK_COLOR);
                jbt.setFont(new Font("Dialog", 1, 8));
                jbt.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Plateau.this.jButton_actionPerformed(e);
                    }
                });
                this.jPanelJeu.add((Component)jbt, null);
            }
            Dimension sSz = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension fSz = this.getSize();
            this.setLocation((sSz.width - fSz.width) / 2, (sSz.height - fSz.height) / 2);
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.jButtonEffacer = new JButton("Effacer");
        this.jButtonEffacer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Plateau.this.jButtonEffacer_actionPerformed(e);
            }
        });
        this.jPanelJeu.setLayout(new GridLayout(10, 10));
        this.jPanelJeu.setMaximumSize(new Dimension(300, Integer.MAX_VALUE));
        this.jPanelJeu.setMinimumSize(new Dimension(300, 100));
        this.jPanelJeu.setPreferredSize(new Dimension(300, 300));
        this.contentPane.add((Component)this.buttonPane, "East");
        this.buttonPane.add((Component)this.jButtonEffacer, null);
        this.contentPane.add((Component)this.jPanelJeu, "Center");
        this.pack();
    }

    void jButton_actionPerformed(ActionEvent e) {
        JButton source = (JButton)e.getSource();
        if (source.getActionCommand().length() != 0) {
            JOptionPane.showMessageDialog(this, "Tricheur !");
            return;
        }
        source.setActionCommand(this.joueur.getMarque());
        source.setIcon(this.joueur.getIcon());
        this.joueur.modelise(this.jPanelJeu);
        if (this.joueur.victoire(this.jPanelJeu)) {
            this.termine(this.joueur.getMarque());
        } else {
            this.ordi.joue(this.jPanelJeu);
            if (this.ordi.victoire(this.jPanelJeu)) {
                this.termine(this.ordi.getMarque());
            }
        }
    }

    void jButtonEffacer_actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.jPanelJeu.getComponentCount(); ++i) {
            ((JButton)this.jPanelJeu.getComponent(i)).setActionCommand("");
            ((JButton)this.jPanelJeu.getComponent(i)).setIcon(null);
            ((JButton)this.jPanelJeu.getComponent(i)).setForeground(Color.black);
            ((JButton)this.jPanelJeu.getComponent(i)).setBackground(BACK_COLOR);
        }
    }

    public void termine(String s) {
        String msg = "X".equals(s) ? "Bravo, vous avez gagn\u00e9." : "Yeap ! J'ai gagn\u00e9 !";
        JOptionPane.showMessageDialog(this, msg, "Morpion", 1);
    }

    void pbOrdi_actionPerformed(ActionEvent e) {
        this.ordi.joue(this.jPanelJeu);
        if (this.ordi.victoire(this.jPanelJeu)) {
            this.termine(this.ordi.getMarque());
        }
    }

    void pbJoueur_actionPerformed(ActionEvent e) {
        this.joueur.joue(this.jPanelJeu);
        if (this.joueur.victoire(this.jPanelJeu)) {
            this.termine(this.joueur.getMarque());
        }
    }
}

