/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.ia;

import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.xemelios.ui.ia.Grille;
import fr.gouv.finances.cp.xemelios.ui.ia.Piece;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class DisplayScore
extends JComponent {
    private static final long serialVersionUID = 3256725091285872945L;
    private Grille laGrille;
    private Font laFont = new Font("Arial", 1, 16);
    private FontMetrics fm = this.getFontMetrics(this.laFont);
    private Image offscreenImg;
    private Graphics offscreenG;
    private static final String POINTS = "POINTS";
    private static final String LINES = "LIGNES";
    private static final String LEVEL = "NIVEAU";
    private static final String NEXT = "SUIVANTE";

    public DisplayScore(Grille pGrille) {
        this.setBackground(Color.black);
        this.laGrille = pGrille;
        this.laGrille.ds = this;
        this.setPreferredSize(pGrille.getPreferredSize());
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.laGrille == null) {
            return;
        }
        if (this.offscreenImg == null) {
            this.offscreenImg = this.createImage(this.getSize().width, this.getSize().height);
            this.offscreenG = this.offscreenImg.getGraphics();
        }
        this.offscreenG.setColor(Color.black);
        this.offscreenG.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.offscreenG.setFont(this.laFont);
        this.offscreenG.setColor(new Color(0, 128, 224));
        this.offscreenG.drawString(POINTS, (this.getSize().width - this.fm.stringWidth(POINTS)) / 2, 15);
        String s = "" + this.laGrille.cptPoints;
        this.offscreenG.drawString(s, (this.getSize().width - this.fm.stringWidth(s)) / 2, 30);
        this.offscreenG.setColor(new Color(0, 192, 0));
        this.offscreenG.drawString(LINES, (this.getSize().width - this.fm.stringWidth(LINES)) / 2, 50);
        s = "" + this.laGrille.cptLines;
        this.offscreenG.drawString(s, (this.getSize().width - this.fm.stringWidth(s)) / 2, 65);
        this.offscreenG.setColor(Color.yellow);
        this.offscreenG.drawString(LEVEL, (this.getSize().width - this.fm.stringWidth(LEVEL)) / 2, 85);
        s = "" + this.laGrille.level;
        this.offscreenG.drawString(s, (this.getSize().width - this.fm.stringWidth(s)) / 2, 100);
        if (this.laGrille.gameFinished) {
            ImageIcon ii = IhmFactory.newInstance().getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/logo_editeur.jpg");
            this.offscreenG.drawImage(ii.getImage(), (this.getWidth() - ii.getIconWidth()) / 2, this.getHeight() - ii.getIconHeight() - 5, ii.getIconWidth(), ii.getIconHeight(), this);
        } else {
            this.offscreenG.setColor(Color.white);
            this.offscreenG.drawString(NEXT, (this.getSize().width - this.fm.stringWidth(NEXT)) / 2, 140);
            Piece p = new Piece(this.laGrille.nextOne);
            p.firstRotation();
            p.reset((this.getSize().width - p.getWidth() * 15) / 2, 155);
            p.display(this.offscreenG);
        }
        g.drawImage(this.offscreenImg, 0, 0, this);
    }
}

