/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import fr.gouv.finances.cp.utils.ui.IhmFactory;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class WindowMenu
extends JMenu {
    private static Logger logger = Logger.getLogger(WindowMenu.class);
    private JMenuItem[] cstMenus = null;
    private static Icon flagIcon = IhmFactory.newInstance().getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/flagMenu.png");
    private static final long serialVersionUID = 3257572810372100920L;
    private JDesktopPane desk = null;

    public WindowMenu(JDesktopPane desk) {
        this.desk = desk;
        this.initialize();
    }

    public WindowMenu(String s, JDesktopPane desk) {
        super(s);
        this.desk = desk;
        this.initialize();
    }

    public WindowMenu(Action a, JDesktopPane desk) {
        super(a);
        this.desk = desk;
        this.initialize();
    }

    public WindowMenu(String s, boolean b, JDesktopPane desk) {
        super(s, b);
        this.desk = desk;
        this.initialize();
    }

    private void initialize() {
        this.cstMenus = new JMenuItem[3];
        this.cstMenus[0] = new JMenuItem("Cascade");
        this.cstMenus[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WindowMenu.cascade(WindowMenu.this.desk);
            }
        });
        this.cstMenus[1] = new JMenuItem("Mosa\u00efque");
        this.cstMenus[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WindowMenu.tile(WindowMenu.this.desk);
            }
        });
        this.cstMenus[2] = new JMenuItem("Tout r\u00e9duire");
        this.cstMenus[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                for (JInternalFrame frame : WindowMenu.this.desk.getAllFrames()) {
                    try {
                        frame.setIcon(true);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void menuSelectionChanged(boolean isIncluded) {
        if (isIncluded) {
            this.showWindowMenu();
        }
        super.menuSelectionChanged(isIncluded);
    }

    private void showWindowMenu() {
        if (this.desk == null) {
            logger.error((Object)"desk is null !");
            return;
        }
        JInternalFrame[] frames = this.desk.getAllFrames();
        this.removeAll();
        this.reAddMenus(frames);
        for (JInternalFrame frame : frames) {
            JMenuItem item = new JMenuItem(new ToFrontAction(frame));
            if (this.desk.getSelectedFrame() == frame) {
                item.setIcon(flagIcon);
            }
            this.add(item);
        }
    }

    private void reAddMenus(JInternalFrame[] frames) {
        for (JMenuItem it : this.cstMenus) {
            this.add(it);
        }
        if (frames != null && frames.length > 0) {
            this.addSeparator();
        }
    }

    public static void cascade(JDesktopPane desktopPane, int layer) {
        JInternalFrame[] frames = desktopPane.getAllFramesInLayer(layer);
        if (frames.length == 0) {
            return;
        }
        WindowMenu.cascade(frames, desktopPane.getBounds(), 24);
    }

    public static void cascade(JDesktopPane desktopPane) {
        JInternalFrame[] frames = desktopPane.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        WindowMenu.cascade(frames, desktopPane.getBounds(), 24);
    }

    private static void cascade(JInternalFrame[] frames, Rectangle dBounds, int separation) {
        int margin = frames.length * separation + separation;
        int width = dBounds.width - margin;
        int height = dBounds.height - margin;
        for (int i = frames.length - 1; i >= 0; --i) {
            frames[i].setBounds(dBounds.x + (frames.length - i - 1) * separation, dBounds.y + (frames.length - i - 1) * separation, width, height);
            try {
                frames[i].setIcon(false);
            }
            catch (Throwable t) {
                // empty catch block
            }
            frames[i].toFront();
            if (i != 0) continue;
            frames[i].getDesktopPane().getDesktopManager().activateFrame(frames[i]);
            try {
                frames[i].setSelected(true);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public static void tile(JDesktopPane desktopPane, int layer) {
        JInternalFrame[] frames = desktopPane.getAllFramesInLayer(layer);
        if (frames.length == 0) {
            return;
        }
        WindowMenu.tile(frames, desktopPane.getBounds());
    }

    public static void tile(JDesktopPane desktopPane) {
        JInternalFrame[] frames = desktopPane.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        WindowMenu.tile(frames, desktopPane.getBounds());
    }

    private static void tile(JInternalFrame[] frames, Rectangle dBounds) {
        int width;
        int height;
        int rows;
        int cols = (int)Math.sqrt(frames.length);
        int lastRow = frames.length - cols * ((rows = (int)Math.ceil((double)frames.length / (double)cols)) - 1);
        if (lastRow == 0) {
            height = dBounds.height / --rows;
        } else {
            height = dBounds.height / rows;
            if (lastRow < cols) {
                --rows;
                width = dBounds.width / lastRow;
                for (int i = 0; i < lastRow; ++i) {
                    frames[cols * rows + i].setBounds(i * width, rows * height, width, height);
                    try {
                        frames[cols * rows + i].setIcon(false);
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
        }
        width = dBounds.width / cols;
        for (int j = 0; j < rows; ++j) {
            for (int i = 0; i < cols; ++i) {
                frames[i + j * cols].setBounds(i * width, j * height, width, height);
                try {
                    frames[i + j * cols].setIcon(false);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }

    public class ToFrontAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private JInternalFrame frame;

        public ToFrontAction(JInternalFrame frame) {
            super(frame.getTitle());
            this.frame = null;
            this.frame = frame;
        }

        public void actionPerformed(ActionEvent evt) {
            if (!this.frame.isSelected()) {
                this.frame.getDesktopPane().getDesktopManager().activateFrame(this.frame);
                try {
                    this.frame.setIcon(false);
                    this.frame.setSelected(true);
                }
                catch (Throwable t) {}
            } else if (this.frame.isIcon()) {
                this.frame.getDesktopPane().getDesktopManager().activateFrame(this.frame);
                try {
                    this.frame.setIcon(false);
                    this.frame.setSelected(true);
                }
                catch (Throwable t) {}
            } else {
                try {
                    this.frame.setIcon(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

