/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import fr.gouv.finances.cp.utils.NavigationContext;
import fr.gouv.finances.cp.utils.StartUrl;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.xemelios.common.ToolException;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.cp.xemelios.ui.UpdatableToolbar;
import fr.gouv.finances.cp.xemelios.ui.xhtmlviewer.Dest;
import fr.gouv.finances.cp.xemelios.ui.xhtmlviewer.ScaleChangeEvent;
import fr.gouv.finances.cp.xemelios.ui.xhtmlviewer.ScaleChangeListener;
import fr.gouv.finances.cp.xemelios.ui.xhtmlviewer.XemeliosReplacedElementFactory;
import fr.gouv.finances.cp.xemelios.ui.xhtmlviewer.XemeliosUserAgent;
import fr.gouv.finances.cp.xemelios.ui.xhtmlviewer.XemeliosXhtmlPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.text.html.FormSubmitEvent;
import org.apache.log4j.Logger;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.simple.XHTMLPrintable;
import org.xhtmlrenderer.swing.LinkListener;
import org.xhtmlrenderer.util.Uu;

public class HtmlViewer
extends JInternalFrame
implements UpdatableToolbar,
ScaleChangeListener {
    private static Logger logger = Logger.getLogger(HtmlViewer.class);
    public static final String PARAM_DESTINATION = "browser-destination";
    public static final String VALUE_DESTINATION_EXTERNAL = "external";
    public static final String VALUE_DESTINATION_INTERNAL = "internal";
    public static final boolean EXTERNAL_DESTINATION = true;
    public static final boolean INTERNAL_DESTINATION = false;
    private static final long serialVersionUID = 3257008752400807221L;
    private static final int WIDTH = 540;
    private static final int HEIGHT = 320;
    private URL documentUrl;
    private final XemeliosXhtmlPanel xhtmlRenderer;
    private JTextField dfUrl;
    private MainWindow mainWindow;
    private JButton pbPrint;
    private JButton pbPrevious;
    private JButton pbNext;
    private XemeliosUserAgent userAgent = null;
    private JComboBox cbxZoom;
    private ScaleFactor[] availableScales;
    private NavigationContext nc;

    public HtmlViewer(URL documentToDisplay, String title, NavigationContext nc, MainWindow mw) {
        this(documentToDisplay, title, mw);
        this.nc = nc;
    }

    public HtmlViewer(URL documentToDisplay, String title, MainWindow mw) {
        super(title, true, true, true, true);
        this.documentUrl = documentToDisplay;
        this.mainWindow = mw;
        this.userAgent = new XemeliosUserAgent(this.mainWindow, this, this);
        this.xhtmlRenderer = new XemeliosXhtmlPanel((UserAgentCallback)this.userAgent);
        this.initializeComponents();
        this.setDefaultCloseOperation(2);
    }

    public HtmlViewer(String uri, String title, MainWindow mw) {
        super(title, true, true, true, true);
        this.mainWindow = mw;
        this.userAgent = new XemeliosUserAgent(this.mainWindow, this, this);
        this.xhtmlRenderer = new XemeliosXhtmlPanel((UserAgentCallback)this.userAgent);
        this.initializeComponents();
        this.setDefaultCloseOperation(2);
        Dest dest = this.userAgent.calculateQuery(uri);
        try {
            this.browseUrl(dest);
        }
        catch (Throwable t) {
            logger.error((Object)"in HtmlViewer(String,String,MainWindow)", t);
        }
    }

    private static ScaleFactor[] initializeScales() {
        ScaleFactor[] scales = new ScaleFactor[9];
        int i = 0;
        scales[i++] = new ScaleFactor(2.0, "200%");
        scales[i++] = new ScaleFactor(1.5, "150%");
        scales[i++] = new ScaleFactor(1.0, "100%");
        scales[i++] = new ScaleFactor(0.85, "85%");
        scales[i++] = new ScaleFactor(0.75, "75%");
        scales[i++] = new ScaleFactor(0.5, "50%");
        scales[i++] = new ScaleFactor(0.33, "33%");
        scales[i++] = new ScaleFactor(0.25, "25%");
        scales[i++] = new ScaleFactor(-2.0, "Largeur page");
        return scales;
    }

    public void scaleChanged(ScaleChangeEvent evt) {
        if (evt.getComponent() == this.xhtmlRenderer) {
            ItemListener[] iListeners;
            double scale = evt.getScale();
            logger.debug((Object)("received scaleChanged with " + scale));
            int ix = -1;
            for (int i = 0; i < this.availableScales.length; ++i) {
                ScaleFactor sf = this.availableScales[i];
                if (sf.getFactor() == scale) {
                    ix = i;
                    break;
                }
                if (sf.getFactor() != -2.0) continue;
                ix = i;
            }
            for (ItemListener il : iListeners = this.cbxZoom.getItemListeners()) {
                this.cbxZoom.removeItemListener(il);
            }
            this.cbxZoom.setSelectedIndex(ix);
            for (ItemListener il : iListeners) {
                this.cbxZoom.addItemListener(il);
            }
        }
    }

    protected void initializeComponents() {
        ScaleFactor[] scales = HtmlViewer.initializeScales();
        this.availableScales = scales;
        IhmFactory iF = IhmFactory.newInstance();
        this.xhtmlRenderer.getSharedContext().setReplacedElementFactory((ReplacedElementFactory)new XemeliosReplacedElementFactory(this.xhtmlRenderer));
        this.xhtmlRenderer.addScaleChangeListener(this);
        MouseListener[] lls = this.xhtmlRenderer.getMouseListeners();
        for (int i = 0; i < lls.length; ++i) {
            MouseListener ll = lls[i];
            if (!(ll instanceof LinkListener)) continue;
            this.xhtmlRenderer.addMouseMotionListener((MouseMotionListener)((LinkListener)ll));
        }
        this.getContentPane().setLayout(new BorderLayout());
        JToolBar tb = new JToolBar();
        this.pbPrevious = new JButton(iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/previous.png"));
        tb.add(this.pbPrevious);
        this.pbNext = new JButton(iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/next.png"));
        tb.add(this.pbNext);
        this.pbPrint = new JButton(iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/print.png"));
        tb.add(this.pbPrint);
        tb.addSeparator();
        tb.add(iF.newLabel("URL ", "normal"));
        this.dfUrl = new JTextField();
        tb.add(this.dfUrl);
        this.dfUrl.setEditable(false);
        Dimension dim = this.dfUrl.getMinimumSize();
        this.dfUrl.setMinimumSize(new Dimension(100, (int)dim.getHeight()));
        tb.addSeparator();
        tb.add(iF.newLabel("Zoom ", "normal"));
        this.cbxZoom = new JComboBox<ScaleFactor>(scales);
        this.cbxZoom.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ScaleFactor factor = (ScaleFactor)e.getItem();
                    if (factor.getFactor() == -2.0) {
                        double scale = HtmlViewer.this.xhtmlRenderer.calculateScale();
                        HtmlViewer.this.xhtmlRenderer.setScale(scale);
                    } else {
                        HtmlViewer.this.xhtmlRenderer.setScale(factor.getFactor());
                    }
                }
            }
        });
        tb.add(this.cbxZoom);
        this.getContentPane().add((Component)tb, "First");
        FSScrollPane scroller = new FSScrollPane((JPanel)((Object)this.xhtmlRenderer));
        this.getContentPane().add((Component)scroller, "Center");
        scroller.setPreferredSize(new Dimension(540, 320));
        scroller.setIgnoreRepaint(false);
        this.pbPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                final PrinterJob printJob = PrinterJob.getPrinterJob();
                printJob.setPrintable((Printable)new XHTMLPrintable((XHTMLPanel)HtmlViewer.this.xhtmlRenderer));
                if (printJob.printDialog()) {
                    new Thread(new Runnable(){

                        public void run() {
                            try {
                                Uu.p((Object)"starting printing");
                                printJob.print();
                                Uu.p((Object)"done printing");
                            }
                            catch (PrinterException ex) {
                                Uu.p((Object)ex);
                            }
                        }
                    }).start();
                }
            }
        });
        this.pbPrint.setToolTipText("Imprimer");
        this.pbPrevious.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HtmlViewer.this.goBack();
            }
        });
        this.pbNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HtmlViewer.this.goForward();
            }
        });
        this.pbPrevious.setEnabled(false);
        this.pbNext.setEnabled(false);
        if (this.documentUrl != null) {
            try {
                this.browseUrl(this.documentUrl, false);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.pack();
    }

    protected void browseUri(URI uri) throws ToolException {
        String query = uri.getQuery();
        Dest dest = this.userAgent.calculateQuery(query);
        this.browseUrl(dest);
    }

    protected void browseUrl(Dest dest) throws ToolException {
        this.browseUrl(dest.url, dest.toExternal);
    }

    protected void browseUrl(URL url, boolean toExternalDestination) throws ToolException {
        try {
            if (toExternalDestination) {
                StartUrl.startUrl(url.toString());
            } else {
                String eForm = url.toExternalForm();
                this.dfUrl.setText(eForm);
                this.xhtmlRenderer.setDocument(eForm);
            }
        }
        catch (Exception ioEx) {
            throw new ToolException(ioEx, 10);
        }
    }

    protected Dest browseFormSubmission(FormSubmitEvent fse) throws UnsupportedEncodingException {
        StringTokenizer st = new StringTokenizer(fse.getData(), "&");
        Hashtable<String, String> params = new Hashtable<String, String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int pos = token.indexOf(61);
            String paramName = token.substring(0, pos);
            String value = URLDecoder.decode(token.substring(pos + 1), "UTF-8");
            params.put(paramName, value);
        }
        String path = (String)params.get("path");
        if (path != null) {
            Set keys = params.keySet();
            HashSet<String> toRemove = new HashSet<String>();
            for (String key : keys) {
                if (key.equals("path") || path.indexOf("%" + key + "%") < 0) continue;
                path = path.replaceAll("%" + key + "%", (String)params.get(key));
                toRemove.add(key);
            }
            if (!toRemove.isEmpty()) {
                keys.removeAll(toRemove);
            }
            params.put("path", URLEncoder.encode(path, "UTF-8"));
        }
        path = "";
        for (String key : params.keySet()) {
            path = path + key + "=" + (String)params.get(key) + "&";
        }
        path = path.substring(0, path.length() - 1);
        return this.userAgent.calculateQuery(path);
    }

    protected void output(NavigationContext ctx) {
        Hashtable<String, Object> params = new Hashtable<String, Object>();
        params.put(PARAM_DESTINATION, VALUE_DESTINATION_EXTERNAL);
        Dest dest = this.userAgent.generateDestContext(ctx, params, true);
        try {
            this.browseUrl(dest.url, true);
        }
        catch (ToolException tEx) {
            // empty catch block
        }
    }

    protected void goBack() {
        if (this.userAgent.hasBack()) {
            this.xhtmlRenderer.setDocument(this.userAgent.getBack());
        } else {
            this.updateToolbarButtons();
        }
    }

    protected void goForward() {
        if (this.userAgent.hasForward()) {
            this.xhtmlRenderer.setDocument(this.userAgent.getForward());
        } else {
            this.updateToolbarButtons();
        }
    }

    public void updateToolbarButtons() {
        this.pbPrevious.setEnabled(this.userAgent.hasBack());
        this.pbNext.setEnabled(this.userAgent.hasForward());
    }

    public void setBaseUrl(String url) {
        this.dfUrl.setText(url);
    }

    private static class ScaleFactor {
        private Double factor;
        private String libelle;

        public ScaleFactor(double factor, String libelle) {
            this.factor = new Double(factor);
            this.libelle = libelle;
        }

        public double getFactor() {
            return this.factor;
        }

        public String getLibelle() {
            return this.libelle;
        }

        public String toString() {
            return this.getLibelle();
        }
    }
}

