/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.utils.ui.InfiniteGlassPane;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.data.DataAccessException;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdesktop.swingworker.SwingWorker;

public class DlgCleanDatabase
extends JDialog {
    private static final long serialVersionUID = 3256721779816151348L;
    private Action escapeAction;
    private DocumentsModel dm;
    private static Logger logger = Logger.getLogger(DlgCleanDatabase.class);
    private JTree tree = null;
    private JButton pbClose = null;
    private JButton pbPurge = null;

    public DlgCleanDatabase(JFrame parent, DocumentsModel dm) {
        super(parent);
        this.dm = dm;
        this.initComponents();
    }

    protected void initComponents() {
        int sepInfo = 2;
        int lineInfo = sepInfo + 2;
        int sepData = lineInfo + 2;
        int treeLine = sepData + 2;
        int buttonLine1 = treeLine + 2;
        JTextArea area = null;
        FormLayout fl = new FormLayout("3dlu,20dlu,140dlu,3dlu", "7dlu,pref,3dlu,pref,7dlu,pref,3dlu,140dlu,7dlu,pref,7dlu");
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(fl);
        this.tree = new JTree(new DatabaseTreeData(this.dm));
        pb.addSeparator("Informations", cc.xyw(2, sepInfo, 2));
        area = new JTextArea();
        pb.add((Component)area, cc.xy(3, lineInfo));
        pb.addSeparator("Documents", cc.xyw(2, sepData, 2));
        pb.add((Component)new JScrollPane(this.tree), cc.xy(3, treeLine));
        this.pbPurge = new JButton("Supprimer");
        JPanel bPane = new JPanel(new BorderLayout());
        bPane.add((Component)this.pbPurge, "West");
        bPane.add(Box.createHorizontalGlue(), "Center");
        this.pbClose = new JButton(this.escapeAction);
        bPane.add((Component)this.pbClose, "East");
        pb.add((Component)bPane, cc.xyw(2, buttonLine1, 2));
        area.setEditable(false);
        area.setLineWrap(true);
        area.setRows(3);
        area.setBackground(this.getBackground());
        area.setText("S\u00e9lectionnez dans le graphique ci-dessous\nles \u00e9l\u00e9ments que vous souhaitez purger.");
        this.tree.setScrollsOnExpand(true);
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.getRootPane().setDefaultButton(this.pbClose);
        this.setContentPane(pb.getPanel());
        this.pbPurge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgCleanDatabase.this.purge(DlgCleanDatabase.this.tree.getSelectionPath());
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setGlassPane(new InfiniteGlassPane());
        this.setVisible(true);
    }

    protected void purge(TreePath tp) {
        if (tp == null) {
            return;
        }
        DataNode node = (DataNode)tp.getLastPathComponent();
        if (JOptionPane.showConfirmDialog(this, "Etes-vous sur de vouloir supprimer les informations\nconcernant " + node + " d\u00e9finitivement ?\n\nCette op\u00e9ration peut prendre beaucoup de temps\nsi le nombre d'\u00e9l\u00e9ments \u00e0 supprimer est important.", "Suppression", 0) == 0) {
            this.purge(node);
        }
    }

    protected void purge(DataNode dn) {
        int level = dn.getType();
        Runnable process = null;
        switch (level) {
            case 1: {
                final DocumentModel dm = (DocumentModel)dn.getData();
                process = new Runnable(){

                    public void run() {
                        try {
                            DlgCleanDatabase.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeDocumentModel(dm);
                            DlgCleanDatabase.this.getGlassPane().setVisible(false);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)dcEx);
                        }
                    }
                };
                break;
            }
            case 2: {
                final DocumentModel dm = (DocumentModel)dn.getParent().getData();
                final Pair collectivite = (Pair)dn.getData();
                process = new Runnable(){

                    public void run() {
                        try {
                            DlgCleanDatabase.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeCollectivite(dm, collectivite);
                            DlgCleanDatabase.this.getGlassPane().setVisible(false);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)dcEx);
                        }
                    }
                };
                break;
            }
            case 3: {
                final Pair budget = (Pair)dn.getData();
                final Pair collectivite = (Pair)dn.getParent().getData();
                final DocumentModel dm = (DocumentModel)dn.getParent().getParent().getData();
                process = new Runnable(){

                    public void run() {
                        try {
                            DlgCleanDatabase.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeBudget(dm, collectivite, budget);
                            DlgCleanDatabase.this.getGlassPane().setVisible(false);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)dcEx);
                        }
                    }
                };
                break;
            }
            case 4: {
                final Pair perso1 = (Pair)dn.getData();
                final Pair budget = (Pair)dn.getParent().getData();
                final Pair collectivite = (Pair)dn.getParent().getParent().getData();
                final DocumentModel dm = (DocumentModel)dn.getParent().getParent().getParent().getData();
                process = new Runnable(){

                    public void run() {
                        try {
                            DlgCleanDatabase.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeSpecialKey1(dm, collectivite, budget, perso1);
                            DlgCleanDatabase.this.getGlassPane().setVisible(false);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)dcEx);
                        }
                    }
                };
                break;
            }
            case 5: {
                final Pair perso2 = (Pair)dn.getData();
                final Pair perso1 = (Pair)dn.getParent().getData();
                final Pair budget = (Pair)dn.getParent().getParent().getData();
                final Pair collectivite = (Pair)dn.getParent().getParent().getParent().getData();
                final DocumentModel dm = (DocumentModel)dn.getParent().getParent().getParent().getParent().getData();
                process = new Runnable(){

                    public void run() {
                        try {
                            DlgCleanDatabase.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeSpecialKey2(dm, collectivite, budget, perso1, perso2);
                            DlgCleanDatabase.this.getGlassPane().setVisible(false);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabase.this, (Throwable)dcEx);
                        }
                    }
                };
                break;
            }
        }
        if (process != null) {
            logger.debug((Object)"deleting");
            Deleter deleter = new Deleter(process, this);
            deleter.execute();
        }
    }

    protected JRootPane createRootPane() {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JRootPane rp = new JRootPane();
        this.escapeAction = new AbstractAction("Fermer"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                DlgCleanDatabase.this.setVisible(false);
            }
        };
        rp.registerKeyboardAction(this.escapeAction, "TOTOTOTO", ks, 2);
        return rp;
    }

    private void enableButtons(boolean activate) {
        this.pbClose.setEnabled(activate);
        this.pbPurge.setEnabled(activate);
    }

    private class Deleter
    extends SwingWorker {
        private Runnable process = null;
        private DlgCleanDatabase dlg = null;

        public Deleter(Runnable process, DlgCleanDatabase dlg) {
            this.process = process;
            this.dlg = dlg;
        }

        public String doInBackground() {
            this.dlg.enableButtons(false);
            this.dlg.setCursor(Cursor.getPredefinedCursor(3));
            this.process.run();
            return null;
        }

        public void done() {
            this.dlg.tree.setModel(new DatabaseTreeData(DlgCleanDatabase.this.dm));
            this.dlg.setCursor(Cursor.getDefaultCursor());
            this.dlg.enableButtons(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DataNode {
        public static final transient int TYPE_ROOT = 0;
        public static final transient int TYPE_DOCUMENT = 1;
        public static final transient int TYPE_COLLECTIVITE = 2;
        public static final transient int TYPE_BUDGET = 3;
        public static final transient int TYPE_PERSO1 = 4;
        public static final transient int TYPE_PERSO2 = 5;
        public static final transient int TYPE_PERSO3 = 6;
        private boolean areChildrenLoaded = false;
        private Object data;
        private int type;
        private Vector<DataNode> children;
        private DataNode parent;
        private DatabaseTreeData tree = null;

        public DataNode(Object data, int type) {
            this.data = data;
            this.type = type;
            this.children = new Vector();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof DataNode) {
                return this.data.equals(((DataNode)o).data);
            }
            return o.equals(this.data);
        }

        public String toString() {
            return this.data.toString();
        }

        public DataNode getParent() {
            return this.parent;
        }

        public Vector<DataNode> getChildren() {
            return this.children;
        }

        public void addChild(Object child) {
            if (child == null) {
                return;
            }
            DataNode node = null;
            node = !(child instanceof DataNode) ? new DataNode(child, this.type + 1) : (DataNode)child;
            node.parent = this;
            this.children.add(node);
            node.tree = this.tree;
        }

        public int getChildCount() {
            if (!this.areChildrenLoaded) {
                this.tree.loadChildren(this);
            }
            return this.children.size();
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public void childrenLoaded() {
            this.areChildrenLoaded = true;
        }

        public boolean areChildrenLoaded() {
            return this.areChildrenLoaded;
        }

        public int getType() {
            return this.type;
        }

        public Object getData() {
            return this.data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DatabaseTreeData
    implements TreeModel {
        private ArrayList<TreeModelListener> listeners;
        private DocumentsModel dm;
        private DataNode root;

        public DatabaseTreeData(DocumentsModel dm) {
            this.dm = dm;
            this.root = new DataNode(dm, 0);
            this.root.tree = this;
            this.loadChildren(this.root);
            this.listeners = new ArrayList();
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public Object getChild(Object parent, int index) {
            DataNode dn = (DataNode)parent;
            if (!dn.areChildrenLoaded()) {
                this.loadChildren(dn);
            }
            return dn.getChildren().elementAt(index);
        }

        @Override
        public int getChildCount(Object parent) {
            DataNode dn = (DataNode)parent;
            if (!dn.areChildrenLoaded()) {
                this.loadChildren(dn);
            }
            return dn.getChildren().size();
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            DataNode dn = (DataNode)parent;
            return dn.getChildren().indexOf(child);
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public boolean isLeaf(Object node) {
            DataNode dn = (DataNode)node;
            return dn.getType() == 5;
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        protected Vector<Pair> getCollectivitesFromDocumentModel(DocumentModel dm) {
            Vector<Pair> ret = null;
            try {
                ret = DataLayerManager.getImplementation().getCollectivites(dm);
            }
            catch (DataAccessException daEx) {
                logger.warn((Object)"", (Throwable)daEx);
                ret = new Vector();
            }
            catch (DataConfigurationException dcEx) {
                logger.error((Object)"", (Throwable)dcEx);
                ret = new Vector();
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void loadChildren(DataNode dn) {
            switch (dn.getType()) {
                case 0: {
                    for (DocumentModel doc : this.dm.getDocuments()) {
                        dn.addChild(doc);
                    }
                    dn.childrenLoaded();
                    break;
                }
                case 1: {
                    Vector<Pair> collectivites = this.getCollectivitesFromDocumentModel((DocumentModel)dn.getData());
                    for (Pair p : collectivites) {
                        dn.addChild(p);
                    }
                    dn.childrenLoaded();
                    break;
                }
                case 2: {
                    Vector<Object> budgets = null;
                    try {
                        Pair collectivite = (Pair)dn.getData();
                        DocumentModel dm = (DocumentModel)dn.getParent().getData();
                        budgets = DataLayerManager.getImplementation().getBudgets(dm, collectivite);
                    }
                    catch (DataAccessException daEx) {
                        logger.error((Object)"", (Throwable)daEx);
                        budgets = new Vector();
                    }
                    catch (DataConfigurationException dcEx) {
                        logger.error((Object)"", (Throwable)dcEx);
                        budgets = new Vector();
                    }
                    for (Pair budget : budgets) {
                        dn.addChild(budget);
                    }
                    dn.childrenLoaded();
                    break;
                }
                case 3: {
                    DlgCleanDatabase.this.setCursor(new Cursor(3));
                    DocumentModel doc = (DocumentModel)dn.getParent().getParent().getData();
                    Pair collectivite = (Pair)dn.getParent().getData();
                    Pair budget = (Pair)dn.getData();
                    Vector<Object> ret = new Vector();
                    try {
                        ret = DataLayerManager.getImplementation().getSpecialKeys1(doc, collectivite, budget, true);
                    }
                    catch (DataAccessException daEx) {
                        logger.error((Object)"", (Throwable)daEx);
                        ret = new Vector();
                    }
                    catch (DataConfigurationException dcEx) {
                        logger.error((Object)"", (Throwable)dcEx);
                        ret = new Vector();
                    }
                    finally {
                        DlgCleanDatabase.this.setCursor(Cursor.getDefaultCursor());
                    }
                    for (Pair pair : ret) {
                        dn.addChild(pair);
                    }
                    dn.childrenLoaded();
                    break;
                }
                case 4: {
                    DlgCleanDatabase.this.setCursor(new Cursor(3));
                    DocumentModel doc = (DocumentModel)dn.getParent().getParent().getParent().getData();
                    Pair collectivite = (Pair)dn.getParent().getParent().getData();
                    Pair budget = (Pair)dn.getParent().getData();
                    Pair key1 = (Pair)dn.getData();
                    Vector<Pair> ret = null;
                    try {
                        ret = DataLayerManager.getImplementation().getSpecialKeys2(doc, collectivite, budget, key1, true);
                    }
                    catch (DataAccessException dataAccessException) {
                        logger.error((Object)"", (Throwable)dataAccessException);
                        ret = new Vector();
                    }
                    catch (DataConfigurationException dataConfigurationException) {
                        logger.error((Object)"", (Throwable)dataConfigurationException);
                        ret = new Vector();
                    }
                    finally {
                        DlgCleanDatabase.this.setCursor(Cursor.getDefaultCursor());
                    }
                    for (Pair p : ret) {
                        dn.addChild(p);
                    }
                    dn.childrenLoaded();
                    break;
                }
            }
        }
    }
}

