/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.importers;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.xemelios.common.FileInfo;
import fr.gouv.finances.cp.xemelios.common.PJRef;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.data.DataImpl;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.importers.ImportServiceProvider;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EtatImporteur
extends SwingWorker<String, String> {
    private static Logger logger = Logger.getLogger(EtatImporteur.class);
    protected DocumentModel dm;
    protected Pair col;
    protected Pair bdg;
    protected File[] filesToImport;
    protected PJRef[] pjs;
    protected Exception inProcessException = null;
    protected long start;
    private ImportServiceProvider impSvcProvider;

    public String doInBackground() {
        FileInfo fileInfo = new FileInfo();
        this.start = System.currentTimeMillis();
        this.getImpSvcProvider().displayProgress(this.filesToImport.length + this.pjs.length);
        try {
            this.preProcess();
            for (int i = 0; i < this.filesToImport.length && !this.isCancelled(); ++i) {
                try {
                    File f = this.filesToImport[i];
                    final String fName = f.getName();
                    try {
                        if (SwingUtilities.isEventDispatchThread()) {
                            this.firePropertyChange("FILE_NAME", null, fName);
                        } else {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                public void run() {
                                    EtatImporteur.this.firePropertyChange("FILE_NAME", null, fName);
                                }
                            });
                        }
                    }
                    catch (Throwable t) {
                        logger.fatal((Object)"in fireFileName:", t);
                    }
                    this.preImportFile(f);
                    fileInfo.merge(this.importFile(f));
                    this.postImportFile(f);
                    continue;
                }
                catch (Exception ex) {
                    this.inProcessException = ex;
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            this.inProcessException = ex;
            ex.printStackTrace();
        }
        try {
            this.postProcess(this.inProcessException != null);
        }
        catch (Exception ex) {
            this.inProcessException = ex;
            ex.printStackTrace();
        }
        if (!this.isCancelled()) {
            try {
                DataImpl di = DataLayerManager.getImplementation();
                for (PJRef pj : this.pjs) {
                    final String fName = pj.getFileName();
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                EtatImporteur.this.firePropertyChange("FILE_NAME", null, fName);
                            }
                        });
                    }
                    catch (Throwable t) {
                        logger.fatal((Object)"in fireFileName:", t);
                    }
                    if (!pj.isValid()) continue;
                    di.importPj(pj);
                }
            }
            catch (Exception ex) {
                this.inProcessException = ex;
                ex.printStackTrace();
            }
        }
        StringBuffer msg = new StringBuffer();
        if (!this.isCancelled()) {
            msg.append("L'import des fichiers est termin\u00e9.\n");
            if (fileInfo.getGlobalCount() == 0L) {
                msg.append("Pas de donn\u00e9es import\u00e9es.");
            } else {
                msg.append(fileInfo.toString());
                msg.append(this.getAdditionalMessage());
            }
        } else {
            msg.append("L'import des fichiers a \u00e9t\u00e9 interrompu.");
        }
        logger.info((Object)("\n" + msg));
        this.firePropertyChange("terminated", null, msg);
        return msg.toString();
    }

    protected void done() {
        super.done();
        if (this.inProcessException != null) {
            this.getImpSvcProvider().displayException(this.inProcessException);
        }
        String msg = "";
        try {
            msg = (String)this.get();
        }
        catch (InterruptedException iEx) {
            iEx.printStackTrace();
        }
        catch (ExecutionException eEx) {
            eEx.printStackTrace();
        }
        catch (CancellationException cEx) {
            msg = "Import annul\u00e9";
        }
        this.getImpSvcProvider().displayMessage(msg, 1);
    }

    public void setDocument(DocumentModel dm) {
        this.dm = dm;
    }

    public void setDocument(DocumentModel dm, Pair collectivite, Pair budget) {
        this.dm = dm;
        this.bdg = budget;
        this.col = collectivite;
    }

    public abstract String getAdditionalMessage();

    public void setFilesToImport(Collection<File> fichiers) throws Exception {
        Object[] data = fichiers.toArray();
        this.filesToImport = new File[data.length];
        for (int i = 0; i < data.length; ++i) {
            this.filesToImport[i] = (File)data[i];
        }
    }

    public void setFilesToImport(File[] fichiers) throws Exception {
        this.filesToImport = fichiers;
    }

    public void setPjs(Collection<PJRef> piecesJointes) throws Exception {
        Object[] data = piecesJointes.toArray();
        this.pjs = new PJRef[data.length];
        for (int i = 0; i < data.length; ++i) {
            this.pjs[i] = (PJRef)data[i];
        }
    }

    protected void preProcess() throws Exception {
    }

    protected void postProcess(boolean isErrorOccured) throws Exception {
    }

    protected void preImportFile(File f) throws Exception {
    }

    protected void postImportFile(File f) throws Exception {
    }

    protected abstract FileInfo importFile(File var1) throws Exception;

    public ImportServiceProvider getImpSvcProvider() {
        return this.impSvcProvider;
    }

    public void setImpSvcProvider(ImportServiceProvider impSvcProvider) {
        this.impSvcProvider = impSvcProvider;
    }
}

