/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.tech;

import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.DlgControl;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.tech.PreHandler;
import fr.gouv.finances.cp.xemelios.controls.tech.XmlValidatorSchemaHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.apache.xerces.jaxp.validation.XMLSchemaFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlValidator {
    private static final Logger logger = Logger.getLogger(XmlValidator.class);
    private String URLschema;
    private String nameSpaceURIDoc;
    private String DocId;
    private Stack<Object> stack = new Stack();
    public String message = "";
    public Vector<Anomalie> anos = new Vector();
    private DocumentModel docModel;
    public String domainesControles = "";
    public DlgControl dlgControl;
    private boolean exceptionOccurs = false;
    private SAXException exceptionSaxe = new SAXException();

    public XmlValidator(String URLschema, String nameSpaceURIDoc, String docid, DocumentModel dm) {
        this.URLschema = URLschema;
        this.nameSpaceURIDoc = nameSpaceURIDoc;
        this.DocId = docid;
        this.docModel = dm;
    }

    public boolean doValidationSyntaxe(File xml) {
        SAXParserFactory factorySAX = SAXParserFactory.newInstance();
        factorySAX.setNamespaceAware(true);
        PreHandler ph = new PreHandler();
        try {
            SAXParser parserXml = factorySAX.newSAXParser();
            FileInputStream fis = new FileInputStream(xml);
            ph.setDocModel(this.docModel);
            parserXml.parse((InputStream)fis, (DefaultHandler)ph);
            this.domainesControles = ph.domaines.toString() == null ? "" : ph.domaines.toString();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (SAXException e) {
            logger.debug((Object)("Le fichier de paye n'est pas un fichier XML valide.\nLa balise " + ph.baliseCourante + " est en anomalie.\n" + e.getMessage()));
            SAXParseException saxe = (SAXParseException)e;
            Anomalie ano = new Anomalie(IdGenerator.nextId(), "TECH01", "Contr\u00f4le de la validit\u00e9 du XML", this.DocId, this.domainesControles, "", "", "", "", ph.message.toString(), "Le fichier doit \u00eatre un fichier XML valide.", "BLOQUANT", "xpath namespacise", new Hashtable<String, Object>());
            ano.addNode(new Node(null));
            this.anos.add(ano);
            return false;
        }
        catch (IOException e) {
            logger.debug((Object)"Erreur d'entree sortie.");
            e.printStackTrace();
        }
        return true;
    }

    public boolean doValidationSchema(File xml) {
        try {
            logger.debug((Object)"Correction de l'entete du fichier pour la validation ... ");
            FileInputStream fis = new FileInputStream(xml);
            BufferedReader br = new BufferedReader(new FileReader(xml));
            File outputfile = this.modifEntete(br, xml);
            if (outputfile.length() != 0L) {
                Schema schema;
                logger.debug((Object)"Verification de la conformite du document XML au schema ... ");
                XMLSchemaFactory xmlsf = new XMLSchemaFactory();
                File fileSchema = null;
                fileSchema = new File(this.URLschema);
                try {
                    schema = xmlsf.newSchema(fileSchema);
                }
                catch (SAXException saxe) {
                    this.exceptionOccurs = true;
                    this.exceptionSaxe = saxe;
                    logger.debug((Object)"[tech.XmlValidator doValidationSchema()] : Erreur lors de la cr\u00e9tion du sch\u00e9ma.", (Throwable)saxe);
                    saxe.printStackTrace();
                    return false;
                }
                Validator validateur = schema.newValidator();
                fis = new FileInputStream(outputfile);
                SAXSource saxSrc = new SAXSource(new InputSource(fis));
                XmlValidatorSchemaHandler vsh = new XmlValidatorSchemaHandler(this.DocId);
                vsh.domainesControles = this.domainesControles;
                validateur.setErrorHandler(vsh);
                try {
                    validateur.validate(saxSrc);
                }
                catch (SAXException saxe) {
                    logger.debug((Object)"Erreur de parseur SAX durant la validation.", (Throwable)saxe);
                    saxe.printStackTrace();
                    return false;
                }
                fis.close();
                this.anos = vsh.anos;
                return this.anos.size() <= 0;
            }
            logger.debug((Object)"L'Entete du document n'a pas pu \u00eatre modifi\u00e9.");
        }
        catch (IOException e) {
            logger.debug((Object)"Erreur d'entree sortie.");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private File modifEntete(BufferedReader br, File xml) {
        String nameEnteteMod = "entete_valide_" + xml.getName();
        File dirfile = new File(System.getProperty("java.io.tmpdir"), "XEMELIOS");
        File outputfile = new File(dirfile, nameEnteteMod);
        try {
            int lu;
            FileWriter fr = new FileWriter(outputfile);
            do {
                if ((lu = br.read()) == -1) continue;
                this.stack.push(Character.valueOf((char)lu));
                if (!this.stack.lastElement().toString().matches(">")) continue;
                if (this.balise(this.stack).matches("^[\\p{Space}]*<[-_\\.a-zA-Z0-9]*:" + this.DocId + "[^>]*>$")) {
                    fr.append("<n:" + this.DocId + " xmlns:n=\"" + this.nameSpaceURIDoc + "\" xmlns:ano=\"http://projets.admisource.gouv.fr/xemelios/namespaces#anomally\">");
                    this.stack.removeAllElements();
                    continue;
                }
                if (this.balise(this.stack).matches("^[\\p{Space}]*</[-_\\.a-zA-Z0-9]*:" + this.DocId + ">$")) {
                    fr.append("</n:" + this.DocId + ">");
                    this.stack.removeAllElements();
                    continue;
                }
                if (this.balise(this.stack).matches("^[\\p{Space}]*<" + this.DocId + "[^>]*>$")) {
                    fr.append("<n:" + this.DocId + " xmlns:n=\"" + this.nameSpaceURIDoc + "\" xmlns:ano=\"http://projets.admisource.gouv.fr/xemelios/namespaces#anomally\">");
                    this.stack.removeAllElements();
                    continue;
                }
                if (this.balise(this.stack).matches("^[\\p{Space}]*</" + this.DocId + ">$")) {
                    fr.append("</n:" + this.DocId + ">");
                    this.stack.removeAllElements();
                    continue;
                }
                fr.append(this.balise(this.stack));
                this.stack.removeAllElements();
            } while (lu != -1);
            fr.close();
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputfile;
    }

    private String balise(Stack s) {
        StringBuffer sb = new StringBuffer();
        Iterator it = s.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
        }
        return sb.toString();
    }

    public void setDlgControl(DlgControl dlgControl) {
        this.dlgControl = dlgControl;
    }

    public boolean getExceptionOccurs() {
        return this.exceptionOccurs;
    }

    public SAXException getExceptionSaxe() {
        return this.exceptionSaxe;
    }
}

