/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.models;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.controls.models.ControlModel;
import fr.gouv.finances.cp.xemelios.controls.models.ParamModel;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentControlModel
implements XmlMarshallable {
    public static final transient String TAG = "document";
    public String id;
    public String schemaLocation;
    private Vector<ParamModel> params = new Vector();
    private Vector<ControlModel> controls = new Vector();
    private Hashtable<String, ControlModel> indexedControls = new Hashtable();

    public DocumentControlModel(String tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("param".equals(tagName)) {
            this.params.add((ParamModel)child);
        } else if ("control".equals(tagName)) {
            ControlModel cm = (ControlModel)child;
            this.controls.add(cm);
            this.indexedControls.put(cm.getId(), cm);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.schemaLocation = attributes.getValue("schemaLocation");
        return this;
    }

    public void validate() throws InvalidXmlDefinition {
        for (ParamModel pcm : this.params) {
            pcm.validate();
        }
        for (ControlModel cm : this.controls) {
            cm.validate();
        }
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.id);
        output.addAttribute("schemaLocation", this.schemaLocation);
        for (ParamModel pm : this.params) {
            pm.marshall(output);
        }
        for (ControlModel cm : this.controls) {
            cm.marshall(output);
        }
        output.endTag(TAG);
    }

    public String getDocumentById() {
        return this.id;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public ParamModel getParamById(String etatId) {
        for (ParamModel param : this.params) {
            if (!param.getId().equals(etatId)) continue;
            return param;
        }
        return null;
    }

    public ControlModel getControlById(String ctrlId) {
        return this.indexedControls.get(ctrlId);
    }

    public Vector<ControlModel> getControls() {
        return this.controls;
    }

    public Vector<ParamModel> getParams() {
        return this.params;
    }

    public DocumentControlModel clone() {
        DocumentControlModel dcm = new DocumentControlModel(TAG);
        dcm.id = this.id;
        dcm.schemaLocation = this.schemaLocation;
        dcm.controls = this.controls;
        dcm.params = this.params;
        return dcm;
    }
}

