/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.models;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.controls.models.MessageModel;
import fr.gouv.finances.cp.xemelios.controls.models.RefIdModel;
import fr.gouv.finances.cp.xemelios.controls.models.RegleModel;
import java.util.Vector;
import org.xml.sax.SAXException;

public class ControlModel
implements XmlMarshallable {
    public static final transient String TAG = "control";
    public String id;
    public String libelle;
    public String severity;
    public String classe;
    public RegleModel regle;
    public Vector<RefIdModel> params = new Vector();
    public MessageModel message;

    public ControlModel(String tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("regle-fonctionnelle".equals(tagName)) {
            this.regle = (RegleModel)child;
        } else if ("refId".equals(tagName)) {
            this.params.add((RefIdModel)child);
        } else if ("message-echec".equals(tagName)) {
            this.message = (MessageModel)child;
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.libelle = attributes.getValue("libelle");
        this.severity = attributes.getValue("severity");
        this.classe = attributes.getValue("class");
        return this;
    }

    public void validate() throws InvalidXmlDefinition {
        this.regle.validate();
        for (RefIdModel pcm : this.params) {
            pcm.validate();
        }
        this.message.validate();
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.id);
        output.addAttribute("libelle", this.libelle);
        output.addAttribute("severity", this.severity);
        output.addAttribute("class", this.classe);
        if (this.regle != null) {
            this.regle.marshall(output);
        }
        for (RefIdModel pcm : this.params) {
            pcm.marshall(output);
        }
        this.message.marshall(output);
        output.endTag(TAG);
    }

    public String getId() {
        return this.id;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getClasse() {
        return this.classe;
    }

    public RegleModel getRegle() {
        return this.regle;
    }

    public RefIdModel getRefIdModel() {
        return this.params.firstElement();
    }

    public MessageModel getMessage() {
        return this.message;
    }

    public RegleModel getRegleFonctionnelle(String etatId) {
        return this.regle;
    }

    public ControlModel clone() {
        ControlModel cm = new ControlModel(TAG);
        cm.id = this.id;
        cm.libelle = this.libelle;
        cm.severity = this.severity;
        cm.classe = this.classe;
        cm.regle = this.regle.clone();
        for (RefIdModel pcm : this.params) {
            try {
                cm.addChild(pcm.clone(), "refId");
            }
            catch (Throwable t) {}
        }
        return cm;
    }
}

