/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls;

import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.Node;
import javax.xml.namespace.NamespaceContext;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.IdentityTransformerHandler;
import org.apache.log4j.Logger;
import org.xml.sax.helpers.AttributesImpl;

public class SaxXmlWriter
extends IdentityTransformerHandler {
    private static Logger logger = Logger.getLogger(SaxXmlWriter.class);
    private String encoding = "UTF-8";
    private NamespaceContext nsCtx;

    public SaxXmlWriter() {
        super(new Controller(new Configuration()));
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setNamespaceContext(NamespaceContext nsCtx) {
        this.nsCtx = nsCtx;
    }

    public void writeAnomally(Anomalie ano) {
        char[] ch;
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally", "anoId", this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally") + ":anoId", "string", ano.getIdAnomalie());
        attrs.addAttribute("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally", "ctrlId", this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally") + ":ctrlId", "string", ano.getControleID());
        attrs.addAttribute("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally", "severity", this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally") + ":severity", "string", ano.getSeverity());
        try {
            this.startElement("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally", "Anomalie", this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally") + ":Anomalie", attrs);
        }
        catch (Throwable t) {
            logger.error((Object)"while calling startElement on Anomalie", t);
        }
        try {
            this.startElement("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally", "ctrlRegleFonct", this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally") + ":ctrlRegleFonct", new AttributesImpl());
            ch = ano.getRegle().toCharArray();
            this.characters(ch, 0, ch.length);
            this.endElement("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally", "ctrlRegleFonct", this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally") + ":ctrlRegleFonct");
        }
        catch (Throwable t) {
            logger.error((Object)"while writting ctrlRegleFonct", t);
        }
        try {
            this.startElement("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally", "message", this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally") + ":message", new AttributesImpl());
            ch = ano.getMessage().toCharArray();
            this.characters(ch, 0, ch.length);
            this.endElement("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally", "message", this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally") + ":message");
        }
        catch (Throwable t) {
            logger.error((Object)"while writting message", t);
        }
        for (Node node : ano.getNodes()) {
            AttributesImpl attrs2 = new AttributesImpl();
            attrs2.addAttribute("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally", "id", this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally") + ":id", "string", node.getId());
            try {
                this.startElement("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally", "node", this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally") + ":node", attrs2);
                this.endElement("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally", "node", this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally") + ":node");
            }
            catch (Throwable t) {
                logger.error((Object)"while writtind node", t);
            }
        }
        try {
            this.endElement("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally", "Anomalie", this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally") + ":Anomalie");
        }
        catch (Throwable t) {
            logger.error((Object)"while calling endElement on Anomalie", t);
        }
    }
}

